/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IoUsageTrend
extends ExplicitlySetBmcModel {
    @JsonProperty(value="endTimestamp")
    private final Date endTimestamp;
    @JsonProperty(value="diskBytesReadInMBs")
    private final Double diskBytesReadInMBs;
    @JsonProperty(value="diskBytesWrittenInMBs")
    private final Double diskBytesWrittenInMBs;
    @JsonProperty(value="diskIopsRead")
    private final Double diskIopsRead;
    @JsonProperty(value="diskIopsWritten")
    private final Double diskIopsWritten;
    @JsonProperty(value="diskIops")
    private final Double diskIops;

    @Deprecated
    @ConstructorProperties(value={"endTimestamp", "diskBytesReadInMBs", "diskBytesWrittenInMBs", "diskIopsRead", "diskIopsWritten", "diskIops"})
    public IoUsageTrend(Date endTimestamp, Double diskBytesReadInMBs, Double diskBytesWrittenInMBs, Double diskIopsRead, Double diskIopsWritten, Double diskIops) {
        this.endTimestamp = endTimestamp;
        this.diskBytesReadInMBs = diskBytesReadInMBs;
        this.diskBytesWrittenInMBs = diskBytesWrittenInMBs;
        this.diskIopsRead = diskIopsRead;
        this.diskIopsWritten = diskIopsWritten;
        this.diskIops = diskIops;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public Double getDiskBytesReadInMBs() {
        return this.diskBytesReadInMBs;
    }

    public Double getDiskBytesWrittenInMBs() {
        return this.diskBytesWrittenInMBs;
    }

    public Double getDiskIopsRead() {
        return this.diskIopsRead;
    }

    public Double getDiskIopsWritten() {
        return this.diskIopsWritten;
    }

    public Double getDiskIops() {
        return this.diskIops;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IoUsageTrend(");
        sb.append("super=").append(super.toString());
        sb.append("endTimestamp=").append(String.valueOf(this.endTimestamp));
        sb.append(", diskBytesReadInMBs=").append(String.valueOf(this.diskBytesReadInMBs));
        sb.append(", diskBytesWrittenInMBs=").append(String.valueOf(this.diskBytesWrittenInMBs));
        sb.append(", diskIopsRead=").append(String.valueOf(this.diskIopsRead));
        sb.append(", diskIopsWritten=").append(String.valueOf(this.diskIopsWritten));
        sb.append(", diskIops=").append(String.valueOf(this.diskIops));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IoUsageTrend)) {
            return false;
        }
        IoUsageTrend other = (IoUsageTrend)((Object)o);
        return Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.diskBytesReadInMBs, other.diskBytesReadInMBs) && Objects.equals(this.diskBytesWrittenInMBs, other.diskBytesWrittenInMBs) && Objects.equals(this.diskIopsRead, other.diskIopsRead) && Objects.equals(this.diskIopsWritten, other.diskIopsWritten) && Objects.equals(this.diskIops, other.diskIops) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.endTimestamp == null ? 43 : this.endTimestamp.hashCode());
        result = result * 59 + (this.diskBytesReadInMBs == null ? 43 : this.diskBytesReadInMBs.hashCode());
        result = result * 59 + (this.diskBytesWrittenInMBs == null ? 43 : this.diskBytesWrittenInMBs.hashCode());
        result = result * 59 + (this.diskIopsRead == null ? 43 : this.diskIopsRead.hashCode());
        result = result * 59 + (this.diskIopsWritten == null ? 43 : this.diskIopsWritten.hashCode());
        result = result * 59 + (this.diskIops == null ? 43 : this.diskIops.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="endTimestamp")
        private Date endTimestamp;
        @JsonProperty(value="diskBytesReadInMBs")
        private Double diskBytesReadInMBs;
        @JsonProperty(value="diskBytesWrittenInMBs")
        private Double diskBytesWrittenInMBs;
        @JsonProperty(value="diskIopsRead")
        private Double diskIopsRead;
        @JsonProperty(value="diskIopsWritten")
        private Double diskIopsWritten;
        @JsonProperty(value="diskIops")
        private Double diskIops;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder endTimestamp(Date endTimestamp) {
            this.endTimestamp = endTimestamp;
            this.__explicitlySet__.add("endTimestamp");
            return this;
        }

        public Builder diskBytesReadInMBs(Double diskBytesReadInMBs) {
            this.diskBytesReadInMBs = diskBytesReadInMBs;
            this.__explicitlySet__.add("diskBytesReadInMBs");
            return this;
        }

        public Builder diskBytesWrittenInMBs(Double diskBytesWrittenInMBs) {
            this.diskBytesWrittenInMBs = diskBytesWrittenInMBs;
            this.__explicitlySet__.add("diskBytesWrittenInMBs");
            return this;
        }

        public Builder diskIopsRead(Double diskIopsRead) {
            this.diskIopsRead = diskIopsRead;
            this.__explicitlySet__.add("diskIopsRead");
            return this;
        }

        public Builder diskIopsWritten(Double diskIopsWritten) {
            this.diskIopsWritten = diskIopsWritten;
            this.__explicitlySet__.add("diskIopsWritten");
            return this;
        }

        public Builder diskIops(Double diskIops) {
            this.diskIops = diskIops;
            this.__explicitlySet__.add("diskIops");
            return this;
        }

        public IoUsageTrend build() {
            IoUsageTrend model = new IoUsageTrend(this.endTimestamp, this.diskBytesReadInMBs, this.diskBytesWrittenInMBs, this.diskIopsRead, this.diskIopsWritten, this.diskIops);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IoUsageTrend model) {
            if (model.wasPropertyExplicitlySet("endTimestamp")) {
                this.endTimestamp(model.getEndTimestamp());
            }
            if (model.wasPropertyExplicitlySet("diskBytesReadInMBs")) {
                this.diskBytesReadInMBs(model.getDiskBytesReadInMBs());
            }
            if (model.wasPropertyExplicitlySet("diskBytesWrittenInMBs")) {
                this.diskBytesWrittenInMBs(model.getDiskBytesWrittenInMBs());
            }
            if (model.wasPropertyExplicitlySet("diskIopsRead")) {
                this.diskIopsRead(model.getDiskIopsRead());
            }
            if (model.wasPropertyExplicitlySet("diskIopsWritten")) {
                this.diskIopsWritten(model.getDiskIopsWritten());
            }
            if (model.wasPropertyExplicitlySet("diskIops")) {
                this.diskIops(model.getDiskIops());
            }
            return this;
        }
    }
}

