/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationSummary;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource")
@JsonFilter(value="explicitlySetFilter")
public final class MdsMysqlDatabaseConfigurationSummary
extends DatabaseConfigurationSummary {
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="isHeatWaveClusterAttached")
    private final Boolean isHeatWaveClusterAttached;
    @JsonProperty(value="isHighlyAvailable")
    private final Boolean isHighlyAvailable;
    @JsonProperty(value="shapeName")
    private final String shapeName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MdsMysqlDatabaseConfigurationSummary(String databaseInsightId, String compartmentId, String databaseName, String databaseDisplayName, String databaseType, String databaseVersion, String cdbName, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, Integer processorCount, String databaseId, Boolean isHeatWaveClusterAttached, Boolean isHighlyAvailable, String shapeName) {
        super(databaseInsightId, compartmentId, databaseName, databaseDisplayName, databaseType, databaseVersion, cdbName, definedTags, freeformTags, processorCount);
        this.databaseId = databaseId;
        this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
        this.isHighlyAvailable = isHighlyAvailable;
        this.shapeName = shapeName;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Boolean getIsHeatWaveClusterAttached() {
        return this.isHeatWaveClusterAttached;
    }

    public Boolean getIsHighlyAvailable() {
        return this.isHighlyAvailable;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MdsMysqlDatabaseConfigurationSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", isHeatWaveClusterAttached=").append(String.valueOf(this.isHeatWaveClusterAttached));
        sb.append(", isHighlyAvailable=").append(String.valueOf(this.isHighlyAvailable));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MdsMysqlDatabaseConfigurationSummary)) {
            return false;
        }
        MdsMysqlDatabaseConfigurationSummary other = (MdsMysqlDatabaseConfigurationSummary)((Object)o);
        return Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.isHeatWaveClusterAttached, other.isHeatWaveClusterAttached) && Objects.equals(this.isHighlyAvailable, other.isHighlyAvailable) && Objects.equals(this.shapeName, other.shapeName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.isHeatWaveClusterAttached == null ? 43 : this.isHeatWaveClusterAttached.hashCode());
        result = result * 59 + (this.isHighlyAvailable == null ? 43 : this.isHighlyAvailable.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseInsightId")
        private String databaseInsightId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="databaseDisplayName")
        private String databaseDisplayName;
        @JsonProperty(value="databaseType")
        private String databaseType;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="cdbName")
        private String cdbName;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="processorCount")
        private Integer processorCount;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="isHeatWaveClusterAttached")
        private Boolean isHeatWaveClusterAttached;
        @JsonProperty(value="isHighlyAvailable")
        private Boolean isHighlyAvailable;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseInsightId(String databaseInsightId) {
            this.databaseInsightId = databaseInsightId;
            this.__explicitlySet__.add("databaseInsightId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder databaseDisplayName(String databaseDisplayName) {
            this.databaseDisplayName = databaseDisplayName;
            this.__explicitlySet__.add("databaseDisplayName");
            return this;
        }

        public Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder cdbName(String cdbName) {
            this.cdbName = cdbName;
            this.__explicitlySet__.add("cdbName");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder processorCount(Integer processorCount) {
            this.processorCount = processorCount;
            this.__explicitlySet__.add("processorCount");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder isHeatWaveClusterAttached(Boolean isHeatWaveClusterAttached) {
            this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
            this.__explicitlySet__.add("isHeatWaveClusterAttached");
            return this;
        }

        public Builder isHighlyAvailable(Boolean isHighlyAvailable) {
            this.isHighlyAvailable = isHighlyAvailable;
            this.__explicitlySet__.add("isHighlyAvailable");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public MdsMysqlDatabaseConfigurationSummary build() {
            MdsMysqlDatabaseConfigurationSummary model = new MdsMysqlDatabaseConfigurationSummary(this.databaseInsightId, this.compartmentId, this.databaseName, this.databaseDisplayName, this.databaseType, this.databaseVersion, this.cdbName, this.definedTags, this.freeformTags, this.processorCount, this.databaseId, this.isHeatWaveClusterAttached, this.isHighlyAvailable, this.shapeName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MdsMysqlDatabaseConfigurationSummary model) {
            if (model.wasPropertyExplicitlySet("databaseInsightId")) {
                this.databaseInsightId(model.getDatabaseInsightId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseDisplayName")) {
                this.databaseDisplayName(model.getDatabaseDisplayName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("cdbName")) {
                this.cdbName(model.getCdbName());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("processorCount")) {
                this.processorCount(model.getProcessorCount());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("isHeatWaveClusterAttached")) {
                this.isHeatWaveClusterAttached(model.getIsHeatWaveClusterAttached());
            }
            if (model.wasPropertyExplicitlySet("isHighlyAvailable")) {
                this.isHighlyAvailable(model.getIsHighlyAvailable());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            return this;
        }
    }
}

