/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.PeComanagedDatabaseHostDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PeComanagedDatabaseConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hosts")
    private final List<PeComanagedDatabaseHostDetails> hosts;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="serviceName")
    private final String serviceName;

    @Deprecated
    @ConstructorProperties(value={"hosts", "protocol", "serviceName"})
    public PeComanagedDatabaseConnectionDetails(List<PeComanagedDatabaseHostDetails> hosts, Protocol protocol, String serviceName) {
        this.hosts = hosts;
        this.protocol = protocol;
        this.serviceName = serviceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<PeComanagedDatabaseHostDetails> getHosts() {
        return this.hosts;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PeComanagedDatabaseConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hosts=").append(String.valueOf(this.hosts));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeComanagedDatabaseConnectionDetails)) {
            return false;
        }
        PeComanagedDatabaseConnectionDetails other = (PeComanagedDatabaseConnectionDetails)((Object)o);
        return Objects.equals(this.hosts, other.hosts) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.serviceName, other.serviceName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hosts == null ? 43 : this.hosts.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Tcp("TCP"),
        Tcps("TCPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hosts")
        private List<PeComanagedDatabaseHostDetails> hosts;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hosts(List<PeComanagedDatabaseHostDetails> hosts) {
            this.hosts = hosts;
            this.__explicitlySet__.add("hosts");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public PeComanagedDatabaseConnectionDetails build() {
            PeComanagedDatabaseConnectionDetails model = new PeComanagedDatabaseConnectionDetails(this.hosts, this.protocol, this.serviceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PeComanagedDatabaseConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("hosts")) {
                this.hosts(model.getHosts());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            return this;
        }
    }
}

