/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.DatabaseDetails;
import com.oracle.bmc.opsi.model.SqlStatistics;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlStatisticAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlIdentifier")
    private final String sqlIdentifier;
    @JsonProperty(value="databaseDetails")
    private final DatabaseDetails databaseDetails;
    @JsonProperty(value="category")
    private final List<String> category;
    @JsonProperty(value="statistics")
    private final SqlStatistics statistics;

    @Deprecated
    @ConstructorProperties(value={"sqlIdentifier", "databaseDetails", "category", "statistics"})
    public SqlStatisticAggregation(String sqlIdentifier, DatabaseDetails databaseDetails, List<String> category, SqlStatistics statistics) {
        this.sqlIdentifier = sqlIdentifier;
        this.databaseDetails = databaseDetails;
        this.category = category;
        this.statistics = statistics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public DatabaseDetails getDatabaseDetails() {
        return this.databaseDetails;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public SqlStatistics getStatistics() {
        return this.statistics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlStatisticAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(", databaseDetails=").append(String.valueOf((Object)this.databaseDetails));
        sb.append(", category=").append(String.valueOf(this.category));
        sb.append(", statistics=").append(String.valueOf((Object)this.statistics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlStatisticAggregation)) {
            return false;
        }
        SqlStatisticAggregation other = (SqlStatisticAggregation)((Object)o);
        return Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals((Object)this.databaseDetails, (Object)other.databaseDetails) && Objects.equals(this.category, other.category) && Objects.equals((Object)this.statistics, (Object)other.statistics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.databaseDetails == null ? 43 : this.databaseDetails.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.statistics == null ? 43 : this.statistics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlIdentifier")
        private String sqlIdentifier;
        @JsonProperty(value="databaseDetails")
        private DatabaseDetails databaseDetails;
        @JsonProperty(value="category")
        private List<String> category;
        @JsonProperty(value="statistics")
        private SqlStatistics statistics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            this.__explicitlySet__.add("sqlIdentifier");
            return this;
        }

        public Builder databaseDetails(DatabaseDetails databaseDetails) {
            this.databaseDetails = databaseDetails;
            this.__explicitlySet__.add("databaseDetails");
            return this;
        }

        public Builder category(List<String> category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder statistics(SqlStatistics statistics) {
            this.statistics = statistics;
            this.__explicitlySet__.add("statistics");
            return this;
        }

        public SqlStatisticAggregation build() {
            SqlStatisticAggregation model = new SqlStatisticAggregation(this.sqlIdentifier, this.databaseDetails, this.category, this.statistics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlStatisticAggregation model) {
            if (model.wasPropertyExplicitlySet("sqlIdentifier")) {
                this.sqlIdentifier(model.getSqlIdentifier());
            }
            if (model.wasPropertyExplicitlySet("databaseDetails")) {
                this.databaseDetails(model.getDatabaseDetails());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("statistics")) {
                this.statistics(model.getStatistics());
            }
            return this;
        }
    }
}

