/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlText
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final Float version;
    @JsonProperty(value="sqlIdentifier")
    private final String sqlIdentifier;
    @JsonProperty(value="timeCollected")
    private final Date timeCollected;
    @JsonProperty(value="sqlCommand")
    private final String sqlCommand;
    @JsonProperty(value="exactMatchingSignature")
    private final String exactMatchingSignature;
    @JsonProperty(value="forceMatchingSignature")
    private final String forceMatchingSignature;
    @JsonProperty(value="sqlFullText")
    private final String sqlFullText;

    @Deprecated
    @ConstructorProperties(value={"version", "sqlIdentifier", "timeCollected", "sqlCommand", "exactMatchingSignature", "forceMatchingSignature", "sqlFullText"})
    public SqlText(Float version, String sqlIdentifier, Date timeCollected, String sqlCommand, String exactMatchingSignature, String forceMatchingSignature, String sqlFullText) {
        this.version = version;
        this.sqlIdentifier = sqlIdentifier;
        this.timeCollected = timeCollected;
        this.sqlCommand = sqlCommand;
        this.exactMatchingSignature = exactMatchingSignature;
        this.forceMatchingSignature = forceMatchingSignature;
        this.sqlFullText = sqlFullText;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getVersion() {
        return this.version;
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public Date getTimeCollected() {
        return this.timeCollected;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    public String getExactMatchingSignature() {
        return this.exactMatchingSignature;
    }

    public String getForceMatchingSignature() {
        return this.forceMatchingSignature;
    }

    public String getSqlFullText() {
        return this.sqlFullText;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlText(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(", timeCollected=").append(String.valueOf(this.timeCollected));
        sb.append(", sqlCommand=").append(String.valueOf(this.sqlCommand));
        sb.append(", exactMatchingSignature=").append(String.valueOf(this.exactMatchingSignature));
        sb.append(", forceMatchingSignature=").append(String.valueOf(this.forceMatchingSignature));
        sb.append(", sqlFullText=").append(String.valueOf(this.sqlFullText));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlText)) {
            return false;
        }
        SqlText other = (SqlText)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.timeCollected, other.timeCollected) && Objects.equals(this.sqlCommand, other.sqlCommand) && Objects.equals(this.exactMatchingSignature, other.exactMatchingSignature) && Objects.equals(this.forceMatchingSignature, other.forceMatchingSignature) && Objects.equals(this.sqlFullText, other.sqlFullText) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.timeCollected == null ? 43 : this.timeCollected.hashCode());
        result = result * 59 + (this.sqlCommand == null ? 43 : this.sqlCommand.hashCode());
        result = result * 59 + (this.exactMatchingSignature == null ? 43 : this.exactMatchingSignature.hashCode());
        result = result * 59 + (this.forceMatchingSignature == null ? 43 : this.forceMatchingSignature.hashCode());
        result = result * 59 + (this.sqlFullText == null ? 43 : this.sqlFullText.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private Float version;
        @JsonProperty(value="sqlIdentifier")
        private String sqlIdentifier;
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="sqlCommand")
        private String sqlCommand;
        @JsonProperty(value="exactMatchingSignature")
        private String exactMatchingSignature;
        @JsonProperty(value="forceMatchingSignature")
        private String forceMatchingSignature;
        @JsonProperty(value="sqlFullText")
        private String sqlFullText;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(Float version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            this.__explicitlySet__.add("sqlIdentifier");
            return this;
        }

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder sqlCommand(String sqlCommand) {
            this.sqlCommand = sqlCommand;
            this.__explicitlySet__.add("sqlCommand");
            return this;
        }

        public Builder exactMatchingSignature(String exactMatchingSignature) {
            this.exactMatchingSignature = exactMatchingSignature;
            this.__explicitlySet__.add("exactMatchingSignature");
            return this;
        }

        public Builder forceMatchingSignature(String forceMatchingSignature) {
            this.forceMatchingSignature = forceMatchingSignature;
            this.__explicitlySet__.add("forceMatchingSignature");
            return this;
        }

        public Builder sqlFullText(String sqlFullText) {
            this.sqlFullText = sqlFullText;
            this.__explicitlySet__.add("sqlFullText");
            return this;
        }

        public SqlText build() {
            SqlText model = new SqlText(this.version, this.sqlIdentifier, this.timeCollected, this.sqlCommand, this.exactMatchingSignature, this.forceMatchingSignature, this.sqlFullText);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlText model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("sqlIdentifier")) {
                this.sqlIdentifier(model.getSqlIdentifier());
            }
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("sqlCommand")) {
                this.sqlCommand(model.getSqlCommand());
            }
            if (model.wasPropertyExplicitlySet("exactMatchingSignature")) {
                this.exactMatchingSignature(model.getExactMatchingSignature());
            }
            if (model.wasPropertyExplicitlySet("forceMatchingSignature")) {
                this.forceMatchingSignature(model.getForceMatchingSignature());
            }
            if (model.wasPropertyExplicitlySet("sqlFullText")) {
                this.sqlFullText(model.getSqlFullText());
            }
            return this;
        }
    }
}

