/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.HostInsightHostRecommendations;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeHostInsightHostRecommendationAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceMetric")
    private final ResourceMetric resourceMetric;
    @JsonProperty(value="usageUnit")
    private final UsageUnit usageUnit;
    @JsonProperty(value="itemDurationInMs")
    private final Long itemDurationInMs;
    @JsonProperty(value="timeIntervalStart")
    private final Date timeIntervalStart;
    @JsonProperty(value="timeIntervalEnd")
    private final Date timeIntervalEnd;
    @JsonProperty(value="details")
    private final HostInsightHostRecommendations details;

    @Deprecated
    @ConstructorProperties(value={"resourceMetric", "usageUnit", "itemDurationInMs", "timeIntervalStart", "timeIntervalEnd", "details"})
    public SummarizeHostInsightHostRecommendationAggregation(ResourceMetric resourceMetric, UsageUnit usageUnit, Long itemDurationInMs, Date timeIntervalStart, Date timeIntervalEnd, HostInsightHostRecommendations details) {
        this.resourceMetric = resourceMetric;
        this.usageUnit = usageUnit;
        this.itemDurationInMs = itemDurationInMs;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.details = details;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResourceMetric getResourceMetric() {
        return this.resourceMetric;
    }

    public UsageUnit getUsageUnit() {
        return this.usageUnit;
    }

    public Long getItemDurationInMs() {
        return this.itemDurationInMs;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public HostInsightHostRecommendations getDetails() {
        return this.details;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeHostInsightHostRecommendationAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("resourceMetric=").append(String.valueOf((Object)this.resourceMetric));
        sb.append(", usageUnit=").append(String.valueOf((Object)this.usageUnit));
        sb.append(", itemDurationInMs=").append(String.valueOf(this.itemDurationInMs));
        sb.append(", timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", details=").append(String.valueOf((Object)this.details));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeHostInsightHostRecommendationAggregation)) {
            return false;
        }
        SummarizeHostInsightHostRecommendationAggregation other = (SummarizeHostInsightHostRecommendationAggregation)((Object)o);
        return Objects.equals((Object)this.resourceMetric, (Object)other.resourceMetric) && Objects.equals((Object)this.usageUnit, (Object)other.usageUnit) && Objects.equals(this.itemDurationInMs, other.itemDurationInMs) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals((Object)this.details, (Object)other.details) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.usageUnit == null ? 43 : this.usageUnit.hashCode());
        result = result * 59 + (this.itemDurationInMs == null ? 43 : this.itemDurationInMs.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UsageUnit implements BmcEnum
    {
        Cores("CORES"),
        Gb("GB"),
        Mbps("MBPS"),
        Iops("IOPS"),
        Percent("PERCENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UsageUnit> map;

        private UsageUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UsageUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UsageUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UsageUnit.class);
            map = new HashMap<String, UsageUnit>();
            for (UsageUnit v : UsageUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceMetric implements BmcEnum
    {
        Cpu("CPU"),
        Memory("MEMORY"),
        LogicalMemory("LOGICAL_MEMORY"),
        Storage("STORAGE"),
        Network("NETWORK"),
        GpuUtilization("GPU_UTILIZATION"),
        GpuMemoryUsage("GPU_MEMORY_USAGE"),
        Io("IO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceMetric> map;

        private ResourceMetric(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceMetric create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceMetric', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceMetric.class);
            map = new HashMap<String, ResourceMetric>();
            for (ResourceMetric v : ResourceMetric.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceMetric")
        private ResourceMetric resourceMetric;
        @JsonProperty(value="usageUnit")
        private UsageUnit usageUnit;
        @JsonProperty(value="itemDurationInMs")
        private Long itemDurationInMs;
        @JsonProperty(value="timeIntervalStart")
        private Date timeIntervalStart;
        @JsonProperty(value="timeIntervalEnd")
        private Date timeIntervalEnd;
        @JsonProperty(value="details")
        private HostInsightHostRecommendations details;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceMetric(ResourceMetric resourceMetric) {
            this.resourceMetric = resourceMetric;
            this.__explicitlySet__.add("resourceMetric");
            return this;
        }

        public Builder usageUnit(UsageUnit usageUnit) {
            this.usageUnit = usageUnit;
            this.__explicitlySet__.add("usageUnit");
            return this;
        }

        public Builder itemDurationInMs(Long itemDurationInMs) {
            this.itemDurationInMs = itemDurationInMs;
            this.__explicitlySet__.add("itemDurationInMs");
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }

        public Builder details(HostInsightHostRecommendations details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public SummarizeHostInsightHostRecommendationAggregation build() {
            SummarizeHostInsightHostRecommendationAggregation model = new SummarizeHostInsightHostRecommendationAggregation(this.resourceMetric, this.usageUnit, this.itemDurationInMs, this.timeIntervalStart, this.timeIntervalEnd, this.details);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeHostInsightHostRecommendationAggregation model) {
            if (model.wasPropertyExplicitlySet("resourceMetric")) {
                this.resourceMetric(model.getResourceMetric());
            }
            if (model.wasPropertyExplicitlySet("usageUnit")) {
                this.usageUnit(model.getUsageUnit());
            }
            if (model.wasPropertyExplicitlySet("itemDurationInMs")) {
                this.itemDurationInMs(model.getItemDurationInMs());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            return this;
        }
    }
}

