/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.HistoricalDataItem;
import com.oracle.bmc.opsi.model.ProjectedDataItem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeHostInsightResourceForecastTrendAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeIntervalStart")
    private final Date timeIntervalStart;
    @JsonProperty(value="timeIntervalEnd")
    private final Date timeIntervalEnd;
    @JsonProperty(value="highUtilizationThreshold")
    private final Integer highUtilizationThreshold;
    @JsonProperty(value="lowUtilizationThreshold")
    private final Integer lowUtilizationThreshold;
    @JsonProperty(value="resourceMetric")
    private final ResourceMetric resourceMetric;
    @JsonProperty(value="usageUnit")
    private final UsageUnit usageUnit;
    @JsonProperty(value="selectedForecastAlgorithm")
    private final String selectedForecastAlgorithm;
    @JsonProperty(value="pattern")
    private final Pattern pattern;
    @JsonProperty(value="historicalData")
    private final List<HistoricalDataItem> historicalData;
    @JsonProperty(value="projectedData")
    private final List<ProjectedDataItem> projectedData;

    @Deprecated
    @ConstructorProperties(value={"timeIntervalStart", "timeIntervalEnd", "highUtilizationThreshold", "lowUtilizationThreshold", "resourceMetric", "usageUnit", "selectedForecastAlgorithm", "pattern", "historicalData", "projectedData"})
    public SummarizeHostInsightResourceForecastTrendAggregation(Date timeIntervalStart, Date timeIntervalEnd, Integer highUtilizationThreshold, Integer lowUtilizationThreshold, ResourceMetric resourceMetric, UsageUnit usageUnit, String selectedForecastAlgorithm, Pattern pattern, List<HistoricalDataItem> historicalData, List<ProjectedDataItem> projectedData) {
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.highUtilizationThreshold = highUtilizationThreshold;
        this.lowUtilizationThreshold = lowUtilizationThreshold;
        this.resourceMetric = resourceMetric;
        this.usageUnit = usageUnit;
        this.selectedForecastAlgorithm = selectedForecastAlgorithm;
        this.pattern = pattern;
        this.historicalData = historicalData;
        this.projectedData = projectedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public Integer getHighUtilizationThreshold() {
        return this.highUtilizationThreshold;
    }

    public Integer getLowUtilizationThreshold() {
        return this.lowUtilizationThreshold;
    }

    public ResourceMetric getResourceMetric() {
        return this.resourceMetric;
    }

    public UsageUnit getUsageUnit() {
        return this.usageUnit;
    }

    public String getSelectedForecastAlgorithm() {
        return this.selectedForecastAlgorithm;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public List<HistoricalDataItem> getHistoricalData() {
        return this.historicalData;
    }

    public List<ProjectedDataItem> getProjectedData() {
        return this.projectedData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeHostInsightResourceForecastTrendAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", highUtilizationThreshold=").append(String.valueOf(this.highUtilizationThreshold));
        sb.append(", lowUtilizationThreshold=").append(String.valueOf(this.lowUtilizationThreshold));
        sb.append(", resourceMetric=").append(String.valueOf((Object)this.resourceMetric));
        sb.append(", usageUnit=").append(String.valueOf((Object)this.usageUnit));
        sb.append(", selectedForecastAlgorithm=").append(String.valueOf(this.selectedForecastAlgorithm));
        sb.append(", pattern=").append(String.valueOf((Object)this.pattern));
        sb.append(", historicalData=").append(String.valueOf(this.historicalData));
        sb.append(", projectedData=").append(String.valueOf(this.projectedData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeHostInsightResourceForecastTrendAggregation)) {
            return false;
        }
        SummarizeHostInsightResourceForecastTrendAggregation other = (SummarizeHostInsightResourceForecastTrendAggregation)((Object)o);
        return Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.highUtilizationThreshold, other.highUtilizationThreshold) && Objects.equals(this.lowUtilizationThreshold, other.lowUtilizationThreshold) && Objects.equals((Object)this.resourceMetric, (Object)other.resourceMetric) && Objects.equals((Object)this.usageUnit, (Object)other.usageUnit) && Objects.equals(this.selectedForecastAlgorithm, other.selectedForecastAlgorithm) && Objects.equals((Object)this.pattern, (Object)other.pattern) && Objects.equals(this.historicalData, other.historicalData) && Objects.equals(this.projectedData, other.projectedData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.highUtilizationThreshold == null ? 43 : this.highUtilizationThreshold.hashCode());
        result = result * 59 + (this.lowUtilizationThreshold == null ? 43 : this.lowUtilizationThreshold.hashCode());
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.usageUnit == null ? 43 : this.usageUnit.hashCode());
        result = result * 59 + (this.selectedForecastAlgorithm == null ? 43 : this.selectedForecastAlgorithm.hashCode());
        result = result * 59 + (this.pattern == null ? 43 : this.pattern.hashCode());
        result = result * 59 + (this.historicalData == null ? 43 : this.historicalData.hashCode());
        result = result * 59 + (this.projectedData == null ? 43 : this.projectedData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Pattern implements BmcEnum
    {
        Linear("LINEAR"),
        MonthlySeasons("MONTHLY_SEASONS"),
        MonthlyAndYearlySeasons("MONTHLY_AND_YEARLY_SEASONS"),
        WeeklySeasons("WEEKLY_SEASONS"),
        WeeklyAndMonthlySeasons("WEEKLY_AND_MONTHLY_SEASONS"),
        WeeklyMonthlyAndYearlySeasons("WEEKLY_MONTHLY_AND_YEARLY_SEASONS"),
        WeeklyAndYearlySeasons("WEEKLY_AND_YEARLY_SEASONS"),
        YearlySeasons("YEARLY_SEASONS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Pattern> map;

        private Pattern(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Pattern create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Pattern', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Pattern.class);
            map = new HashMap<String, Pattern>();
            for (Pattern v : Pattern.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UsageUnit implements BmcEnum
    {
        Cores("CORES"),
        Gb("GB"),
        Mbps("MBPS"),
        Iops("IOPS"),
        Percent("PERCENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UsageUnit> map;

        private UsageUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UsageUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UsageUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UsageUnit.class);
            map = new HashMap<String, UsageUnit>();
            for (UsageUnit v : UsageUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceMetric implements BmcEnum
    {
        Cpu("CPU"),
        Memory("MEMORY"),
        LogicalMemory("LOGICAL_MEMORY"),
        Storage("STORAGE"),
        Network("NETWORK"),
        GpuUtilization("GPU_UTILIZATION"),
        GpuMemoryUsage("GPU_MEMORY_USAGE"),
        Io("IO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceMetric> map;

        private ResourceMetric(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceMetric create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceMetric', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceMetric.class);
            map = new HashMap<String, ResourceMetric>();
            for (ResourceMetric v : ResourceMetric.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeIntervalStart")
        private Date timeIntervalStart;
        @JsonProperty(value="timeIntervalEnd")
        private Date timeIntervalEnd;
        @JsonProperty(value="highUtilizationThreshold")
        private Integer highUtilizationThreshold;
        @JsonProperty(value="lowUtilizationThreshold")
        private Integer lowUtilizationThreshold;
        @JsonProperty(value="resourceMetric")
        private ResourceMetric resourceMetric;
        @JsonProperty(value="usageUnit")
        private UsageUnit usageUnit;
        @JsonProperty(value="selectedForecastAlgorithm")
        private String selectedForecastAlgorithm;
        @JsonProperty(value="pattern")
        private Pattern pattern;
        @JsonProperty(value="historicalData")
        private List<HistoricalDataItem> historicalData;
        @JsonProperty(value="projectedData")
        private List<ProjectedDataItem> projectedData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }

        public Builder highUtilizationThreshold(Integer highUtilizationThreshold) {
            this.highUtilizationThreshold = highUtilizationThreshold;
            this.__explicitlySet__.add("highUtilizationThreshold");
            return this;
        }

        public Builder lowUtilizationThreshold(Integer lowUtilizationThreshold) {
            this.lowUtilizationThreshold = lowUtilizationThreshold;
            this.__explicitlySet__.add("lowUtilizationThreshold");
            return this;
        }

        public Builder resourceMetric(ResourceMetric resourceMetric) {
            this.resourceMetric = resourceMetric;
            this.__explicitlySet__.add("resourceMetric");
            return this;
        }

        public Builder usageUnit(UsageUnit usageUnit) {
            this.usageUnit = usageUnit;
            this.__explicitlySet__.add("usageUnit");
            return this;
        }

        public Builder selectedForecastAlgorithm(String selectedForecastAlgorithm) {
            this.selectedForecastAlgorithm = selectedForecastAlgorithm;
            this.__explicitlySet__.add("selectedForecastAlgorithm");
            return this;
        }

        public Builder pattern(Pattern pattern) {
            this.pattern = pattern;
            this.__explicitlySet__.add("pattern");
            return this;
        }

        public Builder historicalData(List<HistoricalDataItem> historicalData) {
            this.historicalData = historicalData;
            this.__explicitlySet__.add("historicalData");
            return this;
        }

        public Builder projectedData(List<ProjectedDataItem> projectedData) {
            this.projectedData = projectedData;
            this.__explicitlySet__.add("projectedData");
            return this;
        }

        public SummarizeHostInsightResourceForecastTrendAggregation build() {
            SummarizeHostInsightResourceForecastTrendAggregation model = new SummarizeHostInsightResourceForecastTrendAggregation(this.timeIntervalStart, this.timeIntervalEnd, this.highUtilizationThreshold, this.lowUtilizationThreshold, this.resourceMetric, this.usageUnit, this.selectedForecastAlgorithm, this.pattern, this.historicalData, this.projectedData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeHostInsightResourceForecastTrendAggregation model) {
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("highUtilizationThreshold")) {
                this.highUtilizationThreshold(model.getHighUtilizationThreshold());
            }
            if (model.wasPropertyExplicitlySet("lowUtilizationThreshold")) {
                this.lowUtilizationThreshold(model.getLowUtilizationThreshold());
            }
            if (model.wasPropertyExplicitlySet("resourceMetric")) {
                this.resourceMetric(model.getResourceMetric());
            }
            if (model.wasPropertyExplicitlySet("usageUnit")) {
                this.usageUnit(model.getUsageUnit());
            }
            if (model.wasPropertyExplicitlySet("selectedForecastAlgorithm")) {
                this.selectedForecastAlgorithm(model.getSelectedForecastAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("pattern")) {
                this.pattern(model.getPattern());
            }
            if (model.wasPropertyExplicitlySet("historicalData")) {
                this.historicalData(model.getHistoricalData());
            }
            if (model.wasPropertyExplicitlySet("projectedData")) {
                this.projectedData(model.getProjectedData());
            }
            return this;
        }
    }
}

