/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.ResourceInsightCurrentUtilization;
import com.oracle.bmc.opsi.model.ResourceInsightProjectedUtilization;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeHostInsightResourceUtilizationInsightAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeIntervalStart")
    private final Date timeIntervalStart;
    @JsonProperty(value="timeIntervalEnd")
    private final Date timeIntervalEnd;
    @JsonProperty(value="highUtilizationThreshold")
    private final Integer highUtilizationThreshold;
    @JsonProperty(value="lowUtilizationThreshold")
    private final Integer lowUtilizationThreshold;
    @JsonProperty(value="resourceMetric")
    private final ResourceMetric resourceMetric;
    @JsonProperty(value="projectedUtilization")
    private final ResourceInsightProjectedUtilization projectedUtilization;
    @JsonProperty(value="currentUtilization")
    private final ResourceInsightCurrentUtilization currentUtilization;

    @Deprecated
    @ConstructorProperties(value={"timeIntervalStart", "timeIntervalEnd", "highUtilizationThreshold", "lowUtilizationThreshold", "resourceMetric", "projectedUtilization", "currentUtilization"})
    public SummarizeHostInsightResourceUtilizationInsightAggregation(Date timeIntervalStart, Date timeIntervalEnd, Integer highUtilizationThreshold, Integer lowUtilizationThreshold, ResourceMetric resourceMetric, ResourceInsightProjectedUtilization projectedUtilization, ResourceInsightCurrentUtilization currentUtilization) {
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.highUtilizationThreshold = highUtilizationThreshold;
        this.lowUtilizationThreshold = lowUtilizationThreshold;
        this.resourceMetric = resourceMetric;
        this.projectedUtilization = projectedUtilization;
        this.currentUtilization = currentUtilization;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public Integer getHighUtilizationThreshold() {
        return this.highUtilizationThreshold;
    }

    public Integer getLowUtilizationThreshold() {
        return this.lowUtilizationThreshold;
    }

    public ResourceMetric getResourceMetric() {
        return this.resourceMetric;
    }

    public ResourceInsightProjectedUtilization getProjectedUtilization() {
        return this.projectedUtilization;
    }

    public ResourceInsightCurrentUtilization getCurrentUtilization() {
        return this.currentUtilization;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeHostInsightResourceUtilizationInsightAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", highUtilizationThreshold=").append(String.valueOf(this.highUtilizationThreshold));
        sb.append(", lowUtilizationThreshold=").append(String.valueOf(this.lowUtilizationThreshold));
        sb.append(", resourceMetric=").append(String.valueOf((Object)this.resourceMetric));
        sb.append(", projectedUtilization=").append(String.valueOf((Object)this.projectedUtilization));
        sb.append(", currentUtilization=").append(String.valueOf((Object)this.currentUtilization));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeHostInsightResourceUtilizationInsightAggregation)) {
            return false;
        }
        SummarizeHostInsightResourceUtilizationInsightAggregation other = (SummarizeHostInsightResourceUtilizationInsightAggregation)((Object)o);
        return Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.highUtilizationThreshold, other.highUtilizationThreshold) && Objects.equals(this.lowUtilizationThreshold, other.lowUtilizationThreshold) && Objects.equals((Object)this.resourceMetric, (Object)other.resourceMetric) && Objects.equals((Object)this.projectedUtilization, (Object)other.projectedUtilization) && Objects.equals((Object)this.currentUtilization, (Object)other.currentUtilization) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.highUtilizationThreshold == null ? 43 : this.highUtilizationThreshold.hashCode());
        result = result * 59 + (this.lowUtilizationThreshold == null ? 43 : this.lowUtilizationThreshold.hashCode());
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.projectedUtilization == null ? 43 : this.projectedUtilization.hashCode());
        result = result * 59 + (this.currentUtilization == null ? 43 : this.currentUtilization.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceMetric implements BmcEnum
    {
        Cpu("CPU"),
        Memory("MEMORY"),
        LogicalMemory("LOGICAL_MEMORY"),
        Storage("STORAGE"),
        Network("NETWORK"),
        GpuUtilization("GPU_UTILIZATION"),
        GpuMemoryUsage("GPU_MEMORY_USAGE"),
        Io("IO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceMetric> map;

        private ResourceMetric(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceMetric create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceMetric', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceMetric.class);
            map = new HashMap<String, ResourceMetric>();
            for (ResourceMetric v : ResourceMetric.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeIntervalStart")
        private Date timeIntervalStart;
        @JsonProperty(value="timeIntervalEnd")
        private Date timeIntervalEnd;
        @JsonProperty(value="highUtilizationThreshold")
        private Integer highUtilizationThreshold;
        @JsonProperty(value="lowUtilizationThreshold")
        private Integer lowUtilizationThreshold;
        @JsonProperty(value="resourceMetric")
        private ResourceMetric resourceMetric;
        @JsonProperty(value="projectedUtilization")
        private ResourceInsightProjectedUtilization projectedUtilization;
        @JsonProperty(value="currentUtilization")
        private ResourceInsightCurrentUtilization currentUtilization;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }

        public Builder highUtilizationThreshold(Integer highUtilizationThreshold) {
            this.highUtilizationThreshold = highUtilizationThreshold;
            this.__explicitlySet__.add("highUtilizationThreshold");
            return this;
        }

        public Builder lowUtilizationThreshold(Integer lowUtilizationThreshold) {
            this.lowUtilizationThreshold = lowUtilizationThreshold;
            this.__explicitlySet__.add("lowUtilizationThreshold");
            return this;
        }

        public Builder resourceMetric(ResourceMetric resourceMetric) {
            this.resourceMetric = resourceMetric;
            this.__explicitlySet__.add("resourceMetric");
            return this;
        }

        public Builder projectedUtilization(ResourceInsightProjectedUtilization projectedUtilization) {
            this.projectedUtilization = projectedUtilization;
            this.__explicitlySet__.add("projectedUtilization");
            return this;
        }

        public Builder currentUtilization(ResourceInsightCurrentUtilization currentUtilization) {
            this.currentUtilization = currentUtilization;
            this.__explicitlySet__.add("currentUtilization");
            return this;
        }

        public SummarizeHostInsightResourceUtilizationInsightAggregation build() {
            SummarizeHostInsightResourceUtilizationInsightAggregation model = new SummarizeHostInsightResourceUtilizationInsightAggregation(this.timeIntervalStart, this.timeIntervalEnd, this.highUtilizationThreshold, this.lowUtilizationThreshold, this.resourceMetric, this.projectedUtilization, this.currentUtilization);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeHostInsightResourceUtilizationInsightAggregation model) {
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("highUtilizationThreshold")) {
                this.highUtilizationThreshold(model.getHighUtilizationThreshold());
            }
            if (model.wasPropertyExplicitlySet("lowUtilizationThreshold")) {
                this.lowUtilizationThreshold(model.getLowUtilizationThreshold());
            }
            if (model.wasPropertyExplicitlySet("resourceMetric")) {
                this.resourceMetric(model.getResourceMetric());
            }
            if (model.wasPropertyExplicitlySet("projectedUtilization")) {
                this.projectedUtilization(model.getProjectedUtilization());
            }
            if (model.wasPropertyExplicitlySet("currentUtilization")) {
                this.currentUtilization(model.getCurrentUtilization());
            }
            return this;
        }
    }
}

