/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.opsi.model.IngestHostConfigurationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class IngestHostConfigurationRequest
extends BmcRequest<IngestHostConfigurationDetails> {
    private String id;
    private IngestHostConfigurationDetails ingestHostConfigurationDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getId() {
        return this.id;
    }

    public IngestHostConfigurationDetails getIngestHostConfigurationDetails() {
        return this.ingestHostConfigurationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public IngestHostConfigurationDetails getBody$() {
        return this.ingestHostConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).ingestHostConfigurationDetails(this.ingestHostConfigurationDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",ingestHostConfigurationDetails=").append(String.valueOf((Object)this.ingestHostConfigurationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngestHostConfigurationRequest)) {
            return false;
        }
        IngestHostConfigurationRequest other = (IngestHostConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.ingestHostConfigurationDetails, (Object)other.ingestHostConfigurationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.ingestHostConfigurationDetails == null ? 43 : this.ingestHostConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<IngestHostConfigurationRequest, IngestHostConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private IngestHostConfigurationDetails ingestHostConfigurationDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder ingestHostConfigurationDetails(IngestHostConfigurationDetails ingestHostConfigurationDetails) {
            this.ingestHostConfigurationDetails = ingestHostConfigurationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(IngestHostConfigurationRequest o) {
            this.id(o.getId());
            this.ingestHostConfigurationDetails(o.getIngestHostConfigurationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public IngestHostConfigurationRequest build() {
            IngestHostConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(IngestHostConfigurationDetails body) {
            this.ingestHostConfigurationDetails(body);
            return this;
        }

        public IngestHostConfigurationRequest buildWithoutInvocationCallback() {
            IngestHostConfigurationRequest request = new IngestHostConfigurationRequest();
            request.id = this.id;
            request.ingestHostConfigurationDetails = this.ingestHostConfigurationDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

