/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeAddmDbFindingsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> databaseId;
    private List<String> id;
    private String instanceNumber;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private String categoryName;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;
    private Boolean compartmentIdInSubtree;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public List<String> getId() {
        return this.id;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).databaseId(this.databaseId).id(this.id).instanceNumber(this.instanceNumber).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).categoryName(this.categoryName).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists).compartmentIdInSubtree(this.compartmentIdInSubtree);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",categoryName=").append(String.valueOf(this.categoryName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeAddmDbFindingsRequest)) {
            return false;
        }
        SummarizeAddmDbFindingsRequest other = (SummarizeAddmDbFindingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.id, other.id) && Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.categoryName, other.categoryName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.categoryName == null ? 43 : this.categoryName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeAddmDbFindingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> databaseId = null;
        private List<String> id = null;
        private String instanceNumber = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private String categoryName = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;
        private Boolean compartmentIdInSubtree = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder databaseId(String singularValue) {
            return this.databaseId(Arrays.asList(singularValue));
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String singularValue) {
            return this.id(Arrays.asList(singularValue));
        }

        public Builder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeAddmDbFindingsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseId(o.getDatabaseId());
            this.id(o.getId());
            this.instanceNumber(o.getInstanceNumber());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.categoryName(o.getCategoryName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeAddmDbFindingsRequest build() {
            SummarizeAddmDbFindingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeAddmDbFindingsRequest buildWithoutInvocationCallback() {
            SummarizeAddmDbFindingsRequest request = new SummarizeAddmDbFindingsRequest();
            request.compartmentId = this.compartmentId;
            request.databaseId = this.databaseId;
            request.id = this.id;
            request.instanceNumber = this.instanceNumber;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.categoryName = this.categoryName;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        ImpactOverallPercent("impactOverallPercent"),
        ImpactMaxPercent("impactMaxPercent"),
        ImpactAvgActiveSessions("impactAvgActiveSessions"),
        FrequencyCount("frequencyCount");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

