/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.ResourceStatus;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeHostInsightIoUsageTrendRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String id;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private String hostId;
    private String page;
    private Integer limit;
    private Statistic statistic;
    private String opcRequestId;
    private List<ResourceStatus> status;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ResourceStatus> getStatus() {
        return this.status;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).id(this.id).analysisTimeInterval(this.analysisTimeInterval).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).hostId(this.hostId).page(this.page).limit(this.limit).statistic(this.statistic).opcRequestId(this.opcRequestId).status(this.status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",analysisTimeInterval=").append(String.valueOf(this.analysisTimeInterval));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",hostId=").append(String.valueOf(this.hostId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",statistic=").append(String.valueOf((Object)this.statistic));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeHostInsightIoUsageTrendRequest)) {
            return false;
        }
        SummarizeHostInsightIoUsageTrendRequest other = (SummarizeHostInsightIoUsageTrendRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.analysisTimeInterval, other.analysisTimeInterval) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.hostId, other.hostId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.statistic, (Object)other.statistic) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.status, other.status);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.analysisTimeInterval == null ? 43 : this.analysisTimeInterval.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.hostId == null ? 43 : this.hostId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.statistic == null ? 43 : this.statistic.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeHostInsightIoUsageTrendRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String id = null;
        private String analysisTimeInterval = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private String hostId = null;
        private String page = null;
        private Integer limit = null;
        private Statistic statistic = null;
        private String opcRequestId = null;
        private List<ResourceStatus> status = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder statistic(Statistic statistic) {
            this.statistic = statistic;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder status(List<ResourceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ResourceStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeHostInsightIoUsageTrendRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.id(o.getId());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.hostId(o.getHostId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.statistic(o.getStatistic());
            this.opcRequestId(o.getOpcRequestId());
            this.status(o.getStatus());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeHostInsightIoUsageTrendRequest build() {
            SummarizeHostInsightIoUsageTrendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeHostInsightIoUsageTrendRequest buildWithoutInvocationCallback() {
            SummarizeHostInsightIoUsageTrendRequest request = new SummarizeHostInsightIoUsageTrendRequest();
            request.compartmentId = this.compartmentId;
            request.id = this.id;
            request.analysisTimeInterval = this.analysisTimeInterval;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.hostId = this.hostId;
            request.page = this.page;
            request.limit = this.limit;
            request.statistic = this.statistic;
            request.opcRequestId = this.opcRequestId;
            request.status = this.status;
            return request;
        }
    }

    public static enum Statistic implements BmcEnum
    {
        Avg("AVG"),
        Max("MAX");

        private final String value;
        private static Map<String, Statistic> map;

        private Statistic(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Statistic create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Statistic: " + key);
        }

        static {
            map = new HashMap<String, Statistic>();
            for (Statistic v : Statistic.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

