/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.responses;

import com.oracle.bmc.opsi.model.HostConfigurationCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListHostConfigurationsResponse
extends BmcResponse {
    private String opcRequestId;
    private Integer opcTotalItems;
    private String opcNextPage;
    private HostConfigurationCollection hostConfigurationCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public HostConfigurationCollection getHostConfigurationCollection() {
        return this.hostConfigurationCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcTotalItems", "opcNextPage", "hostConfigurationCollection"})
    private ListHostConfigurationsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, Integer opcTotalItems, String opcNextPage, HostConfigurationCollection hostConfigurationCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcTotalItems = opcTotalItems;
        this.opcNextPage = opcNextPage;
        this.hostConfigurationCollection = hostConfigurationCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",hostConfigurationCollection=").append(String.valueOf((Object)this.hostConfigurationCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostConfigurationsResponse)) {
            return false;
        }
        ListHostConfigurationsResponse other = (ListHostConfigurationsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.hostConfigurationCollection, (Object)other.hostConfigurationCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.hostConfigurationCollection == null ? 43 : this.hostConfigurationCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListHostConfigurationsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private Integer opcTotalItems;
        private String opcNextPage;
        private HostConfigurationCollection hostConfigurationCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder hostConfigurationCollection(HostConfigurationCollection hostConfigurationCollection) {
            this.hostConfigurationCollection = hostConfigurationCollection;
            return this;
        }

        public Builder copy(ListHostConfigurationsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcNextPage(o.getOpcNextPage());
            this.hostConfigurationCollection(o.getHostConfigurationCollection());
            return this;
        }

        public ListHostConfigurationsResponse build() {
            return new ListHostConfigurationsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcTotalItems, this.opcNextPage, this.hostConfigurationCollection);
        }
    }
}

