/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.optimizer.model.EvaluatedMetric;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProfileLevelSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="recommendationName")
    private final String recommendationName;
    @JsonProperty(value="metrics")
    private final List<EvaluatedMetric> metrics;
    @JsonProperty(value="defaultInterval")
    private final Integer defaultInterval;
    @JsonProperty(value="validIntervals")
    private final List<Integer> validIntervals;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"name", "recommendationName", "metrics", "defaultInterval", "validIntervals", "timeCreated", "timeUpdated"})
    public ProfileLevelSummary(String name, String recommendationName, List<EvaluatedMetric> metrics, Integer defaultInterval, List<Integer> validIntervals, Date timeCreated, Date timeUpdated) {
        this.name = name;
        this.recommendationName = recommendationName;
        this.metrics = metrics;
        this.defaultInterval = defaultInterval;
        this.validIntervals = validIntervals;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getRecommendationName() {
        return this.recommendationName;
    }

    public List<EvaluatedMetric> getMetrics() {
        return this.metrics;
    }

    public Integer getDefaultInterval() {
        return this.defaultInterval;
    }

    public List<Integer> getValidIntervals() {
        return this.validIntervals;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfileLevelSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", recommendationName=").append(String.valueOf(this.recommendationName));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(", defaultInterval=").append(String.valueOf(this.defaultInterval));
        sb.append(", validIntervals=").append(String.valueOf(this.validIntervals));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileLevelSummary)) {
            return false;
        }
        ProfileLevelSummary other = (ProfileLevelSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.recommendationName, other.recommendationName) && Objects.equals(this.metrics, other.metrics) && Objects.equals(this.defaultInterval, other.defaultInterval) && Objects.equals(this.validIntervals, other.validIntervals) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.recommendationName == null ? 43 : this.recommendationName.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + (this.defaultInterval == null ? 43 : this.defaultInterval.hashCode());
        result = result * 59 + (this.validIntervals == null ? 43 : this.validIntervals.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="recommendationName")
        private String recommendationName;
        @JsonProperty(value="metrics")
        private List<EvaluatedMetric> metrics;
        @JsonProperty(value="defaultInterval")
        private Integer defaultInterval;
        @JsonProperty(value="validIntervals")
        private List<Integer> validIntervals;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder recommendationName(String recommendationName) {
            this.recommendationName = recommendationName;
            this.__explicitlySet__.add("recommendationName");
            return this;
        }

        public Builder metrics(List<EvaluatedMetric> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder defaultInterval(Integer defaultInterval) {
            this.defaultInterval = defaultInterval;
            this.__explicitlySet__.add("defaultInterval");
            return this;
        }

        public Builder validIntervals(List<Integer> validIntervals) {
            this.validIntervals = validIntervals;
            this.__explicitlySet__.add("validIntervals");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public ProfileLevelSummary build() {
            ProfileLevelSummary model = new ProfileLevelSummary(this.name, this.recommendationName, this.metrics, this.defaultInterval, this.validIntervals, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProfileLevelSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("recommendationName")) {
                this.recommendationName(model.getRecommendationName());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            if (model.wasPropertyExplicitlySet("defaultInterval")) {
                this.defaultInterval(model.getDefaultInterval());
            }
            if (model.wasPropertyExplicitlySet("validIntervals")) {
                this.validIntervals(model.getValidIntervals());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

