/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.optimizer.model.StrategyParameter;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Strategy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="strategyName")
    private final String strategyName;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="parametersDefinition")
    private final List<StrategyParameter> parametersDefinition;

    @Deprecated
    @ConstructorProperties(value={"strategyName", "isDefault", "parametersDefinition"})
    public Strategy(String strategyName, Boolean isDefault, List<StrategyParameter> parametersDefinition) {
        this.strategyName = strategyName;
        this.isDefault = isDefault;
        this.parametersDefinition = parametersDefinition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public List<StrategyParameter> getParametersDefinition() {
        return this.parametersDefinition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Strategy(");
        sb.append("super=").append(super.toString());
        sb.append("strategyName=").append(String.valueOf(this.strategyName));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", parametersDefinition=").append(String.valueOf(this.parametersDefinition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Strategy)) {
            return false;
        }
        Strategy other = (Strategy)((Object)o);
        return Objects.equals(this.strategyName, other.strategyName) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.parametersDefinition, other.parametersDefinition) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.strategyName == null ? 43 : this.strategyName.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.parametersDefinition == null ? 43 : this.parametersDefinition.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="strategyName")
        private String strategyName;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="parametersDefinition")
        private List<StrategyParameter> parametersDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder strategyName(String strategyName) {
            this.strategyName = strategyName;
            this.__explicitlySet__.add("strategyName");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder parametersDefinition(List<StrategyParameter> parametersDefinition) {
            this.parametersDefinition = parametersDefinition;
            this.__explicitlySet__.add("parametersDefinition");
            return this;
        }

        public Strategy build() {
            Strategy model = new Strategy(this.strategyName, this.isDefault, this.parametersDefinition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Strategy model) {
            if (model.wasPropertyExplicitlySet("strategyName")) {
                this.strategyName(model.getStrategyName());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("parametersDefinition")) {
                this.parametersDefinition(model.getParametersDefinition());
            }
            return this;
        }
    }
}

