/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.optimizer.model.QueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FilterResourceActionsRequest
extends BmcRequest<QueryDetails> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private QueryDetails queryDetails;
    private String recommendationId;
    private String recommendationName;
    private List<String> childTenancyIds;
    private Boolean includeOrganization;
    private Boolean includeResourceMetadata;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public QueryDetails getQueryDetails() {
        return this.queryDetails;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public String getRecommendationName() {
        return this.recommendationName;
    }

    public List<String> getChildTenancyIds() {
        return this.childTenancyIds;
    }

    public Boolean getIncludeOrganization() {
        return this.includeOrganization;
    }

    public Boolean getIncludeResourceMetadata() {
        return this.includeResourceMetadata;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public QueryDetails getBody$() {
        return this.queryDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).queryDetails(this.queryDetails).recommendationId(this.recommendationId).recommendationName(this.recommendationName).childTenancyIds(this.childTenancyIds).includeOrganization(this.includeOrganization).includeResourceMetadata(this.includeResourceMetadata).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",queryDetails=").append(String.valueOf((Object)this.queryDetails));
        sb.append(",recommendationId=").append(String.valueOf(this.recommendationId));
        sb.append(",recommendationName=").append(String.valueOf(this.recommendationName));
        sb.append(",childTenancyIds=").append(String.valueOf(this.childTenancyIds));
        sb.append(",includeOrganization=").append(String.valueOf(this.includeOrganization));
        sb.append(",includeResourceMetadata=").append(String.valueOf(this.includeResourceMetadata));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterResourceActionsRequest)) {
            return false;
        }
        FilterResourceActionsRequest other = (FilterResourceActionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.queryDetails, (Object)other.queryDetails) && Objects.equals(this.recommendationId, other.recommendationId) && Objects.equals(this.recommendationName, other.recommendationName) && Objects.equals(this.childTenancyIds, other.childTenancyIds) && Objects.equals(this.includeOrganization, other.includeOrganization) && Objects.equals(this.includeResourceMetadata, other.includeResourceMetadata) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.queryDetails == null ? 43 : this.queryDetails.hashCode());
        result = result * 59 + (this.recommendationId == null ? 43 : this.recommendationId.hashCode());
        result = result * 59 + (this.recommendationName == null ? 43 : this.recommendationName.hashCode());
        result = result * 59 + (this.childTenancyIds == null ? 43 : this.childTenancyIds.hashCode());
        result = result * 59 + (this.includeOrganization == null ? 43 : this.includeOrganization.hashCode());
        result = result * 59 + (this.includeResourceMetadata == null ? 43 : this.includeResourceMetadata.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<FilterResourceActionsRequest, QueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private QueryDetails queryDetails = null;
        private String recommendationId = null;
        private String recommendationName = null;
        private List<String> childTenancyIds = null;
        private Boolean includeOrganization = null;
        private Boolean includeResourceMetadata = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder queryDetails(QueryDetails queryDetails) {
            this.queryDetails = queryDetails;
            return this;
        }

        public Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public Builder recommendationName(String recommendationName) {
            this.recommendationName = recommendationName;
            return this;
        }

        public Builder childTenancyIds(List<String> childTenancyIds) {
            this.childTenancyIds = childTenancyIds;
            return this;
        }

        public Builder childTenancyIds(String singularValue) {
            return this.childTenancyIds(Arrays.asList(singularValue));
        }

        public Builder includeOrganization(Boolean includeOrganization) {
            this.includeOrganization = includeOrganization;
            return this;
        }

        public Builder includeResourceMetadata(Boolean includeResourceMetadata) {
            this.includeResourceMetadata = includeResourceMetadata;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(FilterResourceActionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.queryDetails(o.getQueryDetails());
            this.recommendationId(o.getRecommendationId());
            this.recommendationName(o.getRecommendationName());
            this.childTenancyIds(o.getChildTenancyIds());
            this.includeOrganization(o.getIncludeOrganization());
            this.includeResourceMetadata(o.getIncludeResourceMetadata());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public FilterResourceActionsRequest build() {
            FilterResourceActionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryDetails body) {
            this.queryDetails(body);
            return this;
        }

        public FilterResourceActionsRequest buildWithoutInvocationCallback() {
            FilterResourceActionsRequest request = new FilterResourceActionsRequest();
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.queryDetails = this.queryDetails;
            request.recommendationId = this.recommendationId;
            request.recommendationName = this.recommendationName;
            request.childTenancyIds = this.childTenancyIds;
            request.includeOrganization = this.includeOrganization;
            request.includeResourceMetadata = this.includeResourceMetadata;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

