/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.optimizer.model.UpdateResourceActionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateResourceActionRequest
extends BmcRequest<UpdateResourceActionDetails> {
    private String resourceActionId;
    private UpdateResourceActionDetails updateResourceActionDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getResourceActionId() {
        return this.resourceActionId;
    }

    public UpdateResourceActionDetails getUpdateResourceActionDetails() {
        return this.updateResourceActionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateResourceActionDetails getBody$() {
        return this.updateResourceActionDetails;
    }

    public Builder toBuilder() {
        return new Builder().resourceActionId(this.resourceActionId).updateResourceActionDetails(this.updateResourceActionDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resourceActionId=").append(String.valueOf(this.resourceActionId));
        sb.append(",updateResourceActionDetails=").append(String.valueOf((Object)this.updateResourceActionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateResourceActionRequest)) {
            return false;
        }
        UpdateResourceActionRequest other = (UpdateResourceActionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resourceActionId, other.resourceActionId) && Objects.equals((Object)this.updateResourceActionDetails, (Object)other.updateResourceActionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resourceActionId == null ? 43 : this.resourceActionId.hashCode());
        result = result * 59 + (this.updateResourceActionDetails == null ? 43 : this.updateResourceActionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateResourceActionRequest, UpdateResourceActionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resourceActionId = null;
        private UpdateResourceActionDetails updateResourceActionDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder resourceActionId(String resourceActionId) {
            this.resourceActionId = resourceActionId;
            return this;
        }

        public Builder updateResourceActionDetails(UpdateResourceActionDetails updateResourceActionDetails) {
            this.updateResourceActionDetails = updateResourceActionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateResourceActionRequest o) {
            this.resourceActionId(o.getResourceActionId());
            this.updateResourceActionDetails(o.getUpdateResourceActionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateResourceActionRequest build() {
            UpdateResourceActionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateResourceActionDetails body) {
            this.updateResourceActionDetails(body);
            return this;
        }

        public UpdateResourceActionRequest buildWithoutInvocationCallback() {
            UpdateResourceActionRequest request = new UpdateResourceActionRequest();
            request.resourceActionId = this.resourceActionId;
            request.updateResourceActionDetails = this.updateResourceActionDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

