/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer;

import com.oracle.bmc.optimizer.Optimizer;
import com.oracle.bmc.optimizer.model.LifecycleState;
import com.oracle.bmc.optimizer.requests.GetCategoryRequest;
import com.oracle.bmc.optimizer.requests.GetEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.GetProfileRequest;
import com.oracle.bmc.optimizer.requests.GetRecommendationRequest;
import com.oracle.bmc.optimizer.requests.GetResourceActionRequest;
import com.oracle.bmc.optimizer.requests.GetWorkRequestRequest;
import com.oracle.bmc.optimizer.responses.GetCategoryResponse;
import com.oracle.bmc.optimizer.responses.GetEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.GetProfileResponse;
import com.oracle.bmc.optimizer.responses.GetRecommendationResponse;
import com.oracle.bmc.optimizer.responses.GetResourceActionResponse;
import com.oracle.bmc.optimizer.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OptimizerWaiters {
    private final ExecutorService executorService;
    private final Optimizer client;

    public OptimizerWaiters(ExecutorService executorService, Optimizer client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetCategoryRequest, GetCategoryResponse> forCategory(GetCategoryRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCategory(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCategoryRequest, GetCategoryResponse> forCategory(GetCategoryRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCategory(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCategoryRequest, GetCategoryResponse> forCategory(GetCategoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCategory(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCategoryRequest, GetCategoryResponse> forCategory(BmcGenericWaiter waiter, GetCategoryRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCategoryRequest, GetCategoryResponse>(){

            @Override
            public GetCategoryResponse apply(GetCategoryRequest request) {
                return OptimizerWaiters.this.client.getCategory(request);
            }
        }, (Predicate)new Predicate<GetCategoryResponse>(){

            @Override
            public boolean test(GetCategoryResponse response) {
                return targetStatesSet.contains((Object)response.getCategory().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> forEnrollmentStatus(GetEnrollmentStatusRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnrollmentStatus(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> forEnrollmentStatus(GetEnrollmentStatusRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEnrollmentStatus(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> forEnrollmentStatus(GetEnrollmentStatusRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnrollmentStatus(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> forEnrollmentStatus(BmcGenericWaiter waiter, GetEnrollmentStatusRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse>(){

            @Override
            public GetEnrollmentStatusResponse apply(GetEnrollmentStatusRequest request) {
                return OptimizerWaiters.this.client.getEnrollmentStatus(request);
            }
        }, (Predicate)new Predicate<GetEnrollmentStatusResponse>(){

            @Override
            public boolean test(GetEnrollmentStatusResponse response) {
                return targetStatesSet.contains((Object)response.getEnrollmentStatus().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProfileRequest, GetProfileResponse> forProfile(GetProfileRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProfile(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProfileRequest, GetProfileResponse> forProfile(GetProfileRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProfile(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProfileRequest, GetProfileResponse> forProfile(GetProfileRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProfile(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProfileRequest, GetProfileResponse> forProfile(BmcGenericWaiter waiter, GetProfileRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProfileRequest, GetProfileResponse>(){

            @Override
            public GetProfileResponse apply(GetProfileRequest request) {
                return OptimizerWaiters.this.client.getProfile(request);
            }
        }, (Predicate)new Predicate<GetProfileResponse>(){

            @Override
            public boolean test(GetProfileResponse response) {
                return targetStatesSet.contains((Object)response.getProfile().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRecommendationRequest, GetRecommendationResponse> forRecommendation(GetRecommendationRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecommendation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRecommendationRequest, GetRecommendationResponse> forRecommendation(GetRecommendationRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRecommendation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRecommendationRequest, GetRecommendationResponse> forRecommendation(GetRecommendationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecommendation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRecommendationRequest, GetRecommendationResponse> forRecommendation(BmcGenericWaiter waiter, GetRecommendationRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRecommendationRequest, GetRecommendationResponse>(){

            @Override
            public GetRecommendationResponse apply(GetRecommendationRequest request) {
                return OptimizerWaiters.this.client.getRecommendation(request);
            }
        }, (Predicate)new Predicate<GetRecommendationResponse>(){

            @Override
            public boolean test(GetRecommendationResponse response) {
                return targetStatesSet.contains((Object)response.getRecommendation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResourceActionRequest, GetResourceActionResponse> forResourceAction(GetResourceActionRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResourceAction(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResourceActionRequest, GetResourceActionResponse> forResourceAction(GetResourceActionRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResourceAction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResourceActionRequest, GetResourceActionResponse> forResourceAction(GetResourceActionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResourceAction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResourceActionRequest, GetResourceActionResponse> forResourceAction(BmcGenericWaiter waiter, GetResourceActionRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResourceActionRequest, GetResourceActionResponse>(){

            @Override
            public GetResourceActionResponse apply(GetResourceActionRequest request) {
                return OptimizerWaiters.this.client.getResourceAction(request);
            }
        }, (Predicate)new Predicate<GetResourceActionResponse>(){

            @Override
            public boolean test(GetResourceActionResponse response) {
                return targetStatesSet.contains((Object)response.getResourceAction().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OptimizerWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

