/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.optimizer.model.Status;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkApplyResourceAction
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceActionId")
    private final String resourceActionId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeStatusEnd")
    private final Date timeStatusEnd;
    @JsonProperty(value="parameters")
    private final Map<String, Object> parameters;
    @JsonProperty(value="strategyName")
    private final String strategyName;

    @Deprecated
    @ConstructorProperties(value={"resourceActionId", "status", "timeStatusEnd", "parameters", "strategyName"})
    public BulkApplyResourceAction(String resourceActionId, Status status, Date timeStatusEnd, Map<String, Object> parameters, String strategyName) {
        this.resourceActionId = resourceActionId;
        this.status = status;
        this.timeStatusEnd = timeStatusEnd;
        this.parameters = parameters;
        this.strategyName = strategyName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceActionId() {
        return this.resourceActionId;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeStatusEnd() {
        return this.timeStatusEnd;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkApplyResourceAction(");
        sb.append("super=").append(super.toString());
        sb.append("resourceActionId=").append(String.valueOf(this.resourceActionId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeStatusEnd=").append(String.valueOf(this.timeStatusEnd));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", strategyName=").append(String.valueOf(this.strategyName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkApplyResourceAction)) {
            return false;
        }
        BulkApplyResourceAction other = (BulkApplyResourceAction)((Object)o);
        return Objects.equals(this.resourceActionId, other.resourceActionId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeStatusEnd, other.timeStatusEnd) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.strategyName, other.strategyName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceActionId == null ? 43 : this.resourceActionId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStatusEnd == null ? 43 : this.timeStatusEnd.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.strategyName == null ? 43 : this.strategyName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceActionId")
        private String resourceActionId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeStatusEnd")
        private Date timeStatusEnd;
        @JsonProperty(value="parameters")
        private Map<String, Object> parameters;
        @JsonProperty(value="strategyName")
        private String strategyName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceActionId(String resourceActionId) {
            this.resourceActionId = resourceActionId;
            this.__explicitlySet__.add("resourceActionId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeStatusEnd(Date timeStatusEnd) {
            this.timeStatusEnd = timeStatusEnd;
            this.__explicitlySet__.add("timeStatusEnd");
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder strategyName(String strategyName) {
            this.strategyName = strategyName;
            this.__explicitlySet__.add("strategyName");
            return this;
        }

        public BulkApplyResourceAction build() {
            BulkApplyResourceAction model = new BulkApplyResourceAction(this.resourceActionId, this.status, this.timeStatusEnd, this.parameters, this.strategyName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkApplyResourceAction model) {
            if (model.wasPropertyExplicitlySet("resourceActionId")) {
                this.resourceActionId(model.getResourceActionId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeStatusEnd")) {
                this.timeStatusEnd(model.getTimeStatusEnd());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("strategyName")) {
                this.strategyName(model.getStrategyName());
            }
            return this;
        }
    }
}

