/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagement.EventAsync;
import com.oracle.bmc.osmanagement.model.Event;
import com.oracle.bmc.osmanagement.model.EventCollection;
import com.oracle.bmc.osmanagement.model.EventReport;
import com.oracle.bmc.osmanagement.model.RelatedEventCollection;
import com.oracle.bmc.osmanagement.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.requests.GetEventRequest;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagement.requests.UploadEventContentRequest;
import com.oracle.bmc.osmanagement.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.osmanagement.responses.GetEventResponse;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.osmanagement.responses.UpdateEventResponse;
import com.oracle.bmc.osmanagement.responses.UploadEventContentResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAsyncClient
extends BaseAsyncClient
implements EventAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EventAsyncClient.class);

    EventAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    EventAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"EventAsyncClient", (String)"getEventContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<DeleteEventContentResponse> deleteEventContent(DeleteEventContentRequest request, AsyncHandler<DeleteEventContentRequest, DeleteEventContentResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, DeleteEventContentResponse::builder).logger(LOG, "deleteEventContent").serviceDetails("Event", "DeleteEventContent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/DeleteEventContent").method(Method.DELETE).requestBuilder(DeleteEventContentRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteEventContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEventResponse> getEvent(GetEventRequest request, AsyncHandler<GetEventRequest, GetEventResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetEventResponse::builder).logger(LOG, "getEvent").serviceDetails("Event", "GetEvent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/GetEvent").method(Method.GET).requestBuilder(GetEventRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Event.class, GetEventResponse.Builder::event).handleResponseHeaderString("etag", GetEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEventResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEventContentResponse> getEventContent(GetEventContentRequest request, AsyncHandler<GetEventContentRequest, GetEventContentResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetEventContentResponse::builder).logger(LOG, "getEventContent").serviceDetails("Event", "GetEventContent", "").method(Method.GET).requestBuilder(GetEventContentRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetEventContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetEventContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEventContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEventReportResponse> getEventReport(GetEventReportRequest request, AsyncHandler<GetEventReportRequest, GetEventReportResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetEventReportResponse::builder).logger(LOG, "getEventReport").serviceDetails("Event", "GetEventReport", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventReport/GetEventReport").method(Method.GET).requestBuilder(GetEventReportRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam("report").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("latestTimestampLessThan", (Object)request.getLatestTimestampLessThan()).appendQueryParam("latestTimestampGreaterThanOrEqualTo", (Object)request.getLatestTimestampGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EventReport.class, GetEventReportResponse.Builder::eventReport).handleResponseHeaderString("opc-request-id", GetEventReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListEventsResponse> listEvents(ListEventsRequest request, AsyncHandler<ListEventsRequest, ListEventsResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEventsResponse::builder).logger(LOG, "listEvents").serviceDetails("Event", "ListEvents", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventCollection/ListEvents").method(Method.GET).requestBuilder(ListEventsRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("eventId", (Object)request.getEventId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("eventType", (BmcEnum)request.getEventType()).appendQueryParam("latestTimestampLessThan", (Object)request.getLatestTimestampLessThan()).appendQueryParam("latestTimestampGreaterThanOrEqualTo", (Object)request.getLatestTimestampGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EventCollection.class, ListEventsResponse.Builder::eventCollection).handleResponseHeaderString("opc-request-id", ListEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEventsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRelatedEventsResponse> listRelatedEvents(ListRelatedEventsRequest request, AsyncHandler<ListRelatedEventsRequest, ListRelatedEventsResponse> handler) {
        Objects.requireNonNull(request.getEventFingerprint(), "eventFingerprint is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRelatedEventsResponse::builder).logger(LOG, "listRelatedEvents").serviceDetails("Event", "ListRelatedEvents", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/RelatedEventCollection/ListRelatedEvents").method(Method.GET).requestBuilder(ListRelatedEventsRequest::builder).basePath("/20190801").appendPathParam("relatedEvents").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("latestTimestampLessThan", (Object)request.getLatestTimestampLessThan()).appendQueryParam("latestTimestampGreaterThanOrEqualTo", (Object)request.getLatestTimestampGreaterThanOrEqualTo()).appendQueryParam("eventFingerprint", (Object)request.getEventFingerprint()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RelatedEventCollection.class, ListRelatedEventsResponse.Builder::relatedEventCollection).handleResponseHeaderString("opc-request-id", ListRelatedEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRelatedEventsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateEventResponse> updateEvent(UpdateEventRequest request, AsyncHandler<UpdateEventRequest, UpdateEventResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getUpdateEventDetails(), "updateEventDetails is required");
        return this.clientCall(request, UpdateEventResponse::builder).logger(LOG, "updateEvent").serviceDetails("Event", "UpdateEvent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/UpdateEvent").method(Method.PUT).requestBuilder(UpdateEventRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Event.class, UpdateEventResponse.Builder::event).handleResponseHeaderString("etag", UpdateEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEventResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UploadEventContentResponse> uploadEventContent(UploadEventContentRequest request, AsyncHandler<UploadEventContentRequest, UploadEventContentResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, UploadEventContentResponse::builder).logger(LOG, "uploadEventContent").serviceDetails("Event", "UploadEventContent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/UploadEventContent").method(Method.POST).requestBuilder(UploadEventContentRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").appendPathParam("actions").appendPathParam("upload").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", UploadEventContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public EventAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EventAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EventAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EventAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EventAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EventAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EventAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EventAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EventAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EventAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public EventAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EventAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

