/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Recurrence
extends ExplicitlySetBmcModel {
    @JsonProperty(value="intervalType")
    private final IntervalType intervalType;
    @JsonProperty(value="intervalValue")
    private final String intervalValue;

    @Deprecated
    @ConstructorProperties(value={"intervalType", "intervalValue"})
    public Recurrence(IntervalType intervalType, String intervalValue) {
        this.intervalType = intervalType;
        this.intervalValue = intervalValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public IntervalType getIntervalType() {
        return this.intervalType;
    }

    public String getIntervalValue() {
        return this.intervalValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Recurrence(");
        sb.append("super=").append(super.toString());
        sb.append("intervalType=").append(String.valueOf((Object)this.intervalType));
        sb.append(", intervalValue=").append(String.valueOf(this.intervalValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Recurrence)) {
            return false;
        }
        Recurrence other = (Recurrence)((Object)o);
        return Objects.equals((Object)this.intervalType, (Object)other.intervalType) && Objects.equals(this.intervalValue, other.intervalValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.intervalType == null ? 43 : this.intervalType.hashCode());
        result = result * 59 + (this.intervalValue == null ? 43 : this.intervalValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IntervalType implements BmcEnum
    {
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        Weeks("WEEKS");

        private final String value;
        private static Map<String, IntervalType> map;

        private IntervalType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IntervalType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IntervalType: " + key);
        }

        static {
            map = new HashMap<String, IntervalType>();
            for (IntervalType v : IntervalType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="intervalType")
        private IntervalType intervalType;
        @JsonProperty(value="intervalValue")
        private String intervalValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder intervalType(IntervalType intervalType) {
            this.intervalType = intervalType;
            this.__explicitlySet__.add("intervalType");
            return this;
        }

        public Builder intervalValue(String intervalValue) {
            this.intervalValue = intervalValue;
            this.__explicitlySet__.add("intervalValue");
            return this;
        }

        public Recurrence build() {
            Recurrence model = new Recurrence(this.intervalType, this.intervalValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Recurrence model) {
            if (model.wasPropertyExplicitlySet("intervalType")) {
                this.intervalType(model.getIntervalType());
            }
            if (model.wasPropertyExplicitlySet("intervalValue")) {
                this.intervalValue(model.getIntervalValue());
            }
            return this;
        }
    }
}

