/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetWindowsUpdateRequest
extends BmcRequest<Void> {
    private String windowsUpdate;
    private String opcRequestId;

    public String getWindowsUpdate() {
        return this.windowsUpdate;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().windowsUpdate(this.windowsUpdate).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",windowsUpdate=").append(String.valueOf(this.windowsUpdate));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWindowsUpdateRequest)) {
            return false;
        }
        GetWindowsUpdateRequest other = (GetWindowsUpdateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.windowsUpdate, other.windowsUpdate) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.windowsUpdate == null ? 43 : this.windowsUpdate.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWindowsUpdateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String windowsUpdate = null;
        private String opcRequestId = null;

        public Builder windowsUpdate(String windowsUpdate) {
            this.windowsUpdate = windowsUpdate;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWindowsUpdateRequest o) {
            this.windowsUpdate(o.getWindowsUpdate());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWindowsUpdateRequest build() {
            GetWindowsUpdateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetWindowsUpdateRequest buildWithoutInvocationCallback() {
            GetWindowsUpdateRequest request = new GetWindowsUpdateRequest();
            request.windowsUpdate = this.windowsUpdate;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

