/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.osmanagement.model.PackageUpdateTypes;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class InstallAllUpdatesOnManagedInstanceGroupRequest
extends BmcRequest<Void> {
    private String managedInstanceGroupId;
    private PackageUpdateTypes updateType;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public PackageUpdateTypes getUpdateType() {
        return this.updateType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceGroupId(this.managedInstanceGroupId).updateType(this.updateType).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceGroupId=").append(String.valueOf(this.managedInstanceGroupId));
        sb.append(",updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallAllUpdatesOnManagedInstanceGroupRequest)) {
            return false;
        }
        InstallAllUpdatesOnManagedInstanceGroupRequest other = (InstallAllUpdatesOnManagedInstanceGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceGroupId, other.managedInstanceGroupId) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceGroupId == null ? 43 : this.managedInstanceGroupId.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<InstallAllUpdatesOnManagedInstanceGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceGroupId = null;
        private PackageUpdateTypes updateType = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder updateType(PackageUpdateTypes updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InstallAllUpdatesOnManagedInstanceGroupRequest o) {
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.updateType(o.getUpdateType());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InstallAllUpdatesOnManagedInstanceGroupRequest build() {
            InstallAllUpdatesOnManagedInstanceGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public InstallAllUpdatesOnManagedInstanceGroupRequest buildWithoutInvocationCallback() {
            InstallAllUpdatesOnManagedInstanceGroupRequest request = new InstallAllUpdatesOnManagedInstanceGroupRequest();
            request.managedInstanceGroupId = this.managedInstanceGroupId;
            request.updateType = this.updateType;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

