/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class InstallModuleStreamProfileOnManagedInstanceRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String moduleName;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;
    private String streamName;
    private String profileName;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).moduleName(this.moduleName).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).streamName(this.streamName).profileName(this.profileName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",moduleName=").append(String.valueOf(this.moduleName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",streamName=").append(String.valueOf(this.streamName));
        sb.append(",profileName=").append(String.valueOf(this.profileName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallModuleStreamProfileOnManagedInstanceRequest)) {
            return false;
        }
        InstallModuleStreamProfileOnManagedInstanceRequest other = (InstallModuleStreamProfileOnManagedInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.streamName, other.streamName) && Objects.equals(this.profileName, other.profileName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.profileName == null ? 43 : this.profileName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<InstallModuleStreamProfileOnManagedInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private String moduleName = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String streamName = null;
        private String profileName = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InstallModuleStreamProfileOnManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.moduleName(o.getModuleName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.streamName(o.getStreamName());
            this.profileName(o.getProfileName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InstallModuleStreamProfileOnManagedInstanceRequest build() {
            InstallModuleStreamProfileOnManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public InstallModuleStreamProfileOnManagedInstanceRequest buildWithoutInvocationCallback() {
            InstallModuleStreamProfileOnManagedInstanceRequest request = new InstallModuleStreamProfileOnManagedInstanceRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.moduleName = this.moduleName;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.streamName = this.streamName;
            request.profileName = this.profileName;
            return request;
        }
    }
}

