/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemovePackageFromManagedInstanceRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String softwarePackageName;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getSoftwarePackageName() {
        return this.softwarePackageName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).softwarePackageName(this.softwarePackageName).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",softwarePackageName=").append(String.valueOf(this.softwarePackageName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemovePackageFromManagedInstanceRequest)) {
            return false;
        }
        RemovePackageFromManagedInstanceRequest other = (RemovePackageFromManagedInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.softwarePackageName, other.softwarePackageName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.softwarePackageName == null ? 43 : this.softwarePackageName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemovePackageFromManagedInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private String softwarePackageName = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder softwarePackageName(String softwarePackageName) {
            this.softwarePackageName = softwarePackageName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemovePackageFromManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.softwarePackageName(o.getSoftwarePackageName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemovePackageFromManagedInstanceRequest build() {
            RemovePackageFromManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RemovePackageFromManagedInstanceRequest buildWithoutInvocationCallback() {
            RemovePackageFromManagedInstanceRequest request = new RemovePackageFromManagedInstanceRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.softwarePackageName = this.softwarePackageName;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

