/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagement.OsManagementAsync;
import com.oracle.bmc.osmanagement.model.AvailableSoftwareSourceSummary;
import com.oracle.bmc.osmanagement.model.AvailableUpdateSummary;
import com.oracle.bmc.osmanagement.model.AvailableWindowsUpdateSummary;
import com.oracle.bmc.osmanagement.model.Erratum;
import com.oracle.bmc.osmanagement.model.ErratumSummary;
import com.oracle.bmc.osmanagement.model.InstallablePackageSummary;
import com.oracle.bmc.osmanagement.model.InstalledPackageSummary;
import com.oracle.bmc.osmanagement.model.InstalledWindowsUpdateSummary;
import com.oracle.bmc.osmanagement.model.ManagedInstance;
import com.oracle.bmc.osmanagement.model.ManagedInstanceGroup;
import com.oracle.bmc.osmanagement.model.ManagedInstanceGroupSummary;
import com.oracle.bmc.osmanagement.model.ManagedInstanceSummary;
import com.oracle.bmc.osmanagement.model.ModuleStream;
import com.oracle.bmc.osmanagement.model.ModuleStreamOnManagedInstanceSummary;
import com.oracle.bmc.osmanagement.model.ModuleStreamProfile;
import com.oracle.bmc.osmanagement.model.ModuleStreamProfileOnManagedInstanceSummary;
import com.oracle.bmc.osmanagement.model.ModuleStreamProfileSummary;
import com.oracle.bmc.osmanagement.model.ModuleStreamSummary;
import com.oracle.bmc.osmanagement.model.ScheduledJob;
import com.oracle.bmc.osmanagement.model.ScheduledJobSummary;
import com.oracle.bmc.osmanagement.model.SoftwarePackage;
import com.oracle.bmc.osmanagement.model.SoftwarePackageSearchSummary;
import com.oracle.bmc.osmanagement.model.SoftwarePackageSummary;
import com.oracle.bmc.osmanagement.model.SoftwareSource;
import com.oracle.bmc.osmanagement.model.SoftwareSourceSummary;
import com.oracle.bmc.osmanagement.model.WindowsUpdate;
import com.oracle.bmc.osmanagement.model.WindowsUpdateSummary;
import com.oracle.bmc.osmanagement.model.WorkRequest;
import com.oracle.bmc.osmanagement.model.WorkRequestError;
import com.oracle.bmc.osmanagement.model.WorkRequestLogEntry;
import com.oracle.bmc.osmanagement.model.WorkRequestSummary;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DisableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.EnableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.ManageModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemoveModuleStreamProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.SwitchModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DisableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.EnableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.ManageModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemoveModuleStreamProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.SwitchModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsManagementAsyncClient
extends BaseAsyncClient
implements OsManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OsManagementAsyncClient.class);

    OsManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddPackagesToSoftwareSourceResponse> addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request, AsyncHandler<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddPackagesToSoftwareSourceDetails(), "addPackagesToSoftwareSourceDetails is required");
        return this.clientCall(request, AddPackagesToSoftwareSourceResponse::builder).logger(LOG, "addPackagesToSoftwareSource").serviceDetails("OsManagement", "AddPackagesToSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/AddPackagesToSoftwareSource").method(Method.POST).requestBuilder(AddPackagesToSoftwareSourceRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("addPackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", AddPackagesToSoftwareSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachChildSoftwareSourceToManagedInstanceResponse> attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request, AsyncHandler<AttachChildSoftwareSourceToManagedInstanceRequest, AttachChildSoftwareSourceToManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachChildSoftwareSourceToManagedInstanceDetails(), "attachChildSoftwareSourceToManagedInstanceDetails is required");
        return this.clientCall(request, AttachChildSoftwareSourceToManagedInstanceResponse::builder).logger(LOG, "attachChildSoftwareSourceToManagedInstance").serviceDetails("OsManagement", "AttachChildSoftwareSourceToManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachChildSoftwareSourceToManagedInstance").method(Method.POST).requestBuilder(AttachChildSoftwareSourceToManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("attachChildSoftwareSource").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AttachChildSoftwareSourceToManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachManagedInstanceToManagedInstanceGroupResponse> attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request, AsyncHandler<AttachManagedInstanceToManagedInstanceGroupRequest, AttachManagedInstanceToManagedInstanceGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManagedInstanceId(), "managedInstanceId is required");
        return this.clientCall(request, AttachManagedInstanceToManagedInstanceGroupResponse::builder).logger(LOG, "attachManagedInstanceToManagedInstanceGroup").serviceDetails("OsManagement", "AttachManagedInstanceToManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/AttachManagedInstanceToManagedInstanceGroup").method(Method.POST).requestBuilder(AttachManagedInstanceToManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("attachManagedInstance").appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", AttachManagedInstanceToManagedInstanceGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachParentSoftwareSourceToManagedInstanceResponse> attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request, AsyncHandler<AttachParentSoftwareSourceToManagedInstanceRequest, AttachParentSoftwareSourceToManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachParentSoftwareSourceToManagedInstanceDetails(), "attachParentSoftwareSourceToManagedInstanceDetails is required");
        return this.clientCall(request, AttachParentSoftwareSourceToManagedInstanceResponse::builder).logger(LOG, "attachParentSoftwareSourceToManagedInstance").serviceDetails("OsManagement", "AttachParentSoftwareSourceToManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachParentSoftwareSourceToManagedInstance").method(Method.POST).requestBuilder(AttachParentSoftwareSourceToManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("attachParentSoftwareSource").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AttachParentSoftwareSourceToManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeManagedInstanceGroupCompartmentResponse> changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request, AsyncHandler<ChangeManagedInstanceGroupCompartmentRequest, ChangeManagedInstanceGroupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagedInstanceGroupCompartmentDetails(), "changeManagedInstanceGroupCompartmentDetails is required");
        return this.clientCall(request, ChangeManagedInstanceGroupCompartmentResponse::builder).logger(LOG, "changeManagedInstanceGroupCompartment").serviceDetails("OsManagement", "ChangeManagedInstanceGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/ChangeManagedInstanceGroupCompartment").method(Method.POST).requestBuilder(ChangeManagedInstanceGroupCompartmentRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeManagedInstanceGroupCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeScheduledJobCompartmentResponse> changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request, AsyncHandler<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeScheduledJobCompartmentDetails(), "changeScheduledJobCompartmentDetails is required");
        return this.clientCall(request, ChangeScheduledJobCompartmentResponse::builder).logger(LOG, "changeScheduledJobCompartment").serviceDetails("OsManagement", "ChangeScheduledJobCompartment", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ChangeScheduledJobCompartment").method(Method.POST).requestBuilder(ChangeScheduledJobCompartmentRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeScheduledJobCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSoftwareSourceCompartmentResponse> changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request, AsyncHandler<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSoftwareSourceCompartmentDetails(), "changeSoftwareSourceCompartmentDetails is required");
        return this.clientCall(request, ChangeSoftwareSourceCompartmentResponse::builder).logger(LOG, "changeSoftwareSourceCompartment").serviceDetails("OsManagement", "ChangeSoftwareSourceCompartment", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ChangeSoftwareSourceCompartment").method(Method.POST).requestBuilder(ChangeSoftwareSourceCompartmentRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSoftwareSourceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateManagedInstanceGroupResponse> createManagedInstanceGroup(CreateManagedInstanceGroupRequest request, AsyncHandler<CreateManagedInstanceGroupRequest, CreateManagedInstanceGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateManagedInstanceGroupDetails(), "createManagedInstanceGroupDetails is required");
        return this.clientCall(request, CreateManagedInstanceGroupResponse::builder).logger(LOG, "createManagedInstanceGroup").serviceDetails("OsManagement", "CreateManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/CreateManagedInstanceGroup").method(Method.POST).requestBuilder(CreateManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ManagedInstanceGroup.class, CreateManagedInstanceGroupResponse.Builder::managedInstanceGroup).handleResponseHeaderString("Location", CreateManagedInstanceGroupResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateManagedInstanceGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateManagedInstanceGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateScheduledJobResponse> createScheduledJob(CreateScheduledJobRequest request, AsyncHandler<CreateScheduledJobRequest, CreateScheduledJobResponse> handler) {
        Objects.requireNonNull(request.getCreateScheduledJobDetails(), "createScheduledJobDetails is required");
        return this.clientCall(request, CreateScheduledJobResponse::builder).logger(LOG, "createScheduledJob").serviceDetails("OsManagement", "CreateScheduledJob", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/CreateScheduledJob").method(Method.POST).requestBuilder(CreateScheduledJobRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ScheduledJob.class, CreateScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("Location", CreateScheduledJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateScheduledJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduledJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateSoftwareSourceResponse> createSoftwareSource(CreateSoftwareSourceRequest request, AsyncHandler<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse> handler) {
        Objects.requireNonNull(request.getCreateSoftwareSourceDetails(), "createSoftwareSourceDetails is required");
        return this.clientCall(request, CreateSoftwareSourceResponse::builder).logger(LOG, "createSoftwareSource").serviceDetails("OsManagement", "CreateSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/CreateSoftwareSource").method(Method.POST).requestBuilder(CreateSoftwareSourceRequest::builder).basePath("/20190801").appendPathParam("softwareSources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SoftwareSource.class, CreateSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("Location", CreateSoftwareSourceResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSoftwareSourceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteManagedInstanceGroupResponse> deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request, AsyncHandler<DeleteManagedInstanceGroupRequest, DeleteManagedInstanceGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteManagedInstanceGroupResponse::builder).logger(LOG, "deleteManagedInstanceGroup").serviceDetails("OsManagement", "DeleteManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DeleteManagedInstanceGroup").method(Method.DELETE).requestBuilder(DeleteManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteManagedInstanceGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteScheduledJobResponse> deleteScheduledJob(DeleteScheduledJobRequest request, AsyncHandler<DeleteScheduledJobRequest, DeleteScheduledJobResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteScheduledJobResponse::builder).logger(LOG, "deleteScheduledJob").serviceDetails("OsManagement", "DeleteScheduledJob", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/DeleteScheduledJob").method(Method.DELETE).requestBuilder(DeleteScheduledJobRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteScheduledJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSoftwareSourceResponse> deleteSoftwareSource(DeleteSoftwareSourceRequest request, AsyncHandler<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSoftwareSourceResponse::builder).logger(LOG, "deleteSoftwareSource").serviceDetails("OsManagement", "DeleteSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/DeleteSoftwareSource").method(Method.DELETE).requestBuilder(DeleteSoftwareSourceRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSoftwareSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachChildSoftwareSourceFromManagedInstanceResponse> detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request, AsyncHandler<DetachChildSoftwareSourceFromManagedInstanceRequest, DetachChildSoftwareSourceFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachChildSoftwareSourceFromManagedInstanceDetails(), "detachChildSoftwareSourceFromManagedInstanceDetails is required");
        return this.clientCall(request, DetachChildSoftwareSourceFromManagedInstanceResponse::builder).logger(LOG, "detachChildSoftwareSourceFromManagedInstance").serviceDetails("OsManagement", "DetachChildSoftwareSourceFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachChildSoftwareSourceFromManagedInstance").method(Method.POST).requestBuilder(DetachChildSoftwareSourceFromManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("detachChildSoftwareSource").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DetachChildSoftwareSourceFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachManagedInstanceFromManagedInstanceGroupResponse> detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request, AsyncHandler<DetachManagedInstanceFromManagedInstanceGroupRequest, DetachManagedInstanceFromManagedInstanceGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManagedInstanceId(), "managedInstanceId is required");
        return this.clientCall(request, DetachManagedInstanceFromManagedInstanceGroupResponse::builder).logger(LOG, "detachManagedInstanceFromManagedInstanceGroup").serviceDetails("OsManagement", "DetachManagedInstanceFromManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DetachManagedInstanceFromManagedInstanceGroup").method(Method.POST).requestBuilder(DetachManagedInstanceFromManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("detachManagedInstance").appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DetachManagedInstanceFromManagedInstanceGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachParentSoftwareSourceFromManagedInstanceResponse> detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request, AsyncHandler<DetachParentSoftwareSourceFromManagedInstanceRequest, DetachParentSoftwareSourceFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachParentSoftwareSourceFromManagedInstanceDetails(), "detachParentSoftwareSourceFromManagedInstanceDetails is required");
        return this.clientCall(request, DetachParentSoftwareSourceFromManagedInstanceResponse::builder).logger(LOG, "detachParentSoftwareSourceFromManagedInstance").serviceDetails("OsManagement", "DetachParentSoftwareSourceFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachParentSoftwareSourceFromManagedInstance").method(Method.POST).requestBuilder(DetachParentSoftwareSourceFromManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("detachParentSoftwareSource").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DetachParentSoftwareSourceFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableModuleStreamOnManagedInstanceResponse> disableModuleStreamOnManagedInstance(DisableModuleStreamOnManagedInstanceRequest request, AsyncHandler<DisableModuleStreamOnManagedInstanceRequest, DisableModuleStreamOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        return this.clientCall(request, DisableModuleStreamOnManagedInstanceResponse::builder).logger(LOG, "disableModuleStreamOnManagedInstance").serviceDetails("OsManagement", "DisableModuleStreamOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/DisableModuleStreamOnManagedInstance").method(Method.POST).requestBuilder(DisableModuleStreamOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("moduleStreams").appendPathParam("disable").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DisableModuleStreamOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableModuleStreamOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableModuleStreamOnManagedInstanceResponse> enableModuleStreamOnManagedInstance(EnableModuleStreamOnManagedInstanceRequest request, AsyncHandler<EnableModuleStreamOnManagedInstanceRequest, EnableModuleStreamOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        return this.clientCall(request, EnableModuleStreamOnManagedInstanceResponse::builder).logger(LOG, "enableModuleStreamOnManagedInstance").serviceDetails("OsManagement", "EnableModuleStreamOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/EnableModuleStreamOnManagedInstance").method(Method.POST).requestBuilder(EnableModuleStreamOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("moduleStreams").appendPathParam("enable").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", EnableModuleStreamOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableModuleStreamOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetErratumResponse> getErratum(GetErratumRequest request, AsyncHandler<GetErratumRequest, GetErratumResponse> handler) {
        Validate.notBlank((String)request.getErratumId(), (String)"erratumId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetErratumResponse::builder).logger(LOG, "getErratum").serviceDetails("OsManagement", "GetErratum", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Erratum/GetErratum").method(Method.GET).requestBuilder(GetErratumRequest::builder).basePath("/20190801").appendPathParam("errata").appendPathParam(request.getErratumId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Erratum.class, GetErratumResponse.Builder::erratum).handleResponseHeaderString("opc-request-id", GetErratumResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagedInstanceResponse> getManagedInstance(GetManagedInstanceRequest request, AsyncHandler<GetManagedInstanceRequest, GetManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagedInstanceResponse::builder).logger(LOG, "getManagedInstance").serviceDetails("OsManagement", "GetManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/GetManagedInstance").method(Method.GET).requestBuilder(GetManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstance.class, GetManagedInstanceResponse.Builder::managedInstance).handleResponseHeaderString("etag", GetManagedInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagedInstanceGroupResponse> getManagedInstanceGroup(GetManagedInstanceGroupRequest request, AsyncHandler<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagedInstanceGroupResponse::builder).logger(LOG, "getManagedInstanceGroup").serviceDetails("OsManagement", "GetManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/GetManagedInstanceGroup").method(Method.GET).requestBuilder(GetManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstanceGroup.class, GetManagedInstanceGroupResponse.Builder::managedInstanceGroup).handleResponseHeaderString("etag", GetManagedInstanceGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceGroupResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetManagedInstanceGroupResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetModuleStreamResponse> getModuleStream(GetModuleStreamRequest request, AsyncHandler<GetModuleStreamRequest, GetModuleStreamResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getModuleName(), (String)"moduleName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStreamName(), (String)"streamName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetModuleStreamResponse::builder).logger(LOG, "getModuleStream").serviceDetails("OsManagement", "GetModuleStream", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStream/GetModuleStream").method(Method.GET).requestBuilder(GetModuleStreamRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("modules").appendPathParam(request.getModuleName()).appendPathParam("streams").appendPathParam(request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModuleStream.class, GetModuleStreamResponse.Builder::moduleStream).handleResponseHeaderString("opc-work-request-id", GetModuleStreamResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GetModuleStreamResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModuleStreamProfileResponse> getModuleStreamProfile(GetModuleStreamProfileRequest request, AsyncHandler<GetModuleStreamProfileRequest, GetModuleStreamProfileResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getModuleName(), (String)"moduleName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStreamName(), (String)"streamName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProfileName(), (String)"profileName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetModuleStreamProfileResponse::builder).logger(LOG, "getModuleStreamProfile").serviceDetails("OsManagement", "GetModuleStreamProfile", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfile/GetModuleStreamProfile").method(Method.GET).requestBuilder(GetModuleStreamProfileRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("modules").appendPathParam(request.getModuleName()).appendPathParam("streams").appendPathParam(request.getStreamName()).appendPathParam("profiles").appendPathParam(request.getProfileName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModuleStreamProfile.class, GetModuleStreamProfileResponse.Builder::moduleStreamProfile).handleResponseHeaderString("opc-work-request-id", GetModuleStreamProfileResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GetModuleStreamProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetScheduledJobResponse> getScheduledJob(GetScheduledJobRequest request, AsyncHandler<GetScheduledJobRequest, GetScheduledJobResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScheduledJobResponse::builder).logger(LOG, "getScheduledJob").serviceDetails("OsManagement", "GetScheduledJob", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/GetScheduledJob").method(Method.GET).requestBuilder(GetScheduledJobRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledJob.class, GetScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("etag", GetScheduledJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScheduledJobResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetScheduledJobResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetSoftwarePackageResponse> getSoftwarePackage(GetSoftwarePackageRequest request, AsyncHandler<GetSoftwarePackageRequest, GetSoftwarePackageResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSoftwarePackageResponse::builder).logger(LOG, "getSoftwarePackage").serviceDetails("OsManagement", "GetSoftwarePackage", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwarePackage").method(Method.GET).requestBuilder(GetSoftwarePackageRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwarePackage.class, GetSoftwarePackageResponse.Builder::softwarePackage).handleResponseHeaderString("opc-request-id", GetSoftwarePackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSoftwareSourceResponse> getSoftwareSource(GetSoftwareSourceRequest request, AsyncHandler<GetSoftwareSourceRequest, GetSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSoftwareSourceResponse::builder).logger(LOG, "getSoftwareSource").serviceDetails("OsManagement", "GetSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwareSource").method(Method.GET).requestBuilder(GetSoftwareSourceRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwareSource.class, GetSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", GetSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetSoftwareSourceResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetWindowsUpdateResponse> getWindowsUpdate(GetWindowsUpdateRequest request, AsyncHandler<GetWindowsUpdateRequest, GetWindowsUpdateResponse> handler) {
        Validate.notBlank((String)request.getWindowsUpdate(), (String)"windowsUpdate must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWindowsUpdateResponse::builder).logger(LOG, "getWindowsUpdate").serviceDetails("OsManagement", "GetWindowsUpdate", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdate/GetWindowsUpdate").method(Method.GET).requestBuilder(GetWindowsUpdateRequest::builder).basePath("/20190801").appendPathParam("updates").appendPathParam(request.getWindowsUpdate()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WindowsUpdate.class, GetWindowsUpdateResponse.Builder::windowsUpdate).handleResponseHeaderString("opc-request-id", GetWindowsUpdateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OsManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190801").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<InstallAllPackageUpdatesOnManagedInstanceResponse> installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallAllPackageUpdatesOnManagedInstanceRequest, InstallAllPackageUpdatesOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, InstallAllPackageUpdatesOnManagedInstanceResponse::builder).logger(LOG, "installAllPackageUpdatesOnManagedInstance").serviceDetails("OsManagement", "InstallAllPackageUpdatesOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllPackageUpdatesOnManagedInstance").method(Method.POST).requestBuilder(InstallAllPackageUpdatesOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("packages").appendPathParam("updateAll").appendEnumQueryParam("updateType", (BmcEnum)request.getUpdateType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", InstallAllPackageUpdatesOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallAllPackageUpdatesOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallAllUpdatesOnManagedInstanceGroupResponse> installAllUpdatesOnManagedInstanceGroup(InstallAllUpdatesOnManagedInstanceGroupRequest request, AsyncHandler<InstallAllUpdatesOnManagedInstanceGroupRequest, InstallAllUpdatesOnManagedInstanceGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, InstallAllUpdatesOnManagedInstanceGroupResponse::builder).logger(LOG, "installAllUpdatesOnManagedInstanceGroup").serviceDetails("OsManagement", "InstallAllUpdatesOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/InstallAllUpdatesOnManagedInstanceGroup").method(Method.POST).requestBuilder(InstallAllUpdatesOnManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("updates").appendPathParam("installAll").appendEnumQueryParam("updateType", (BmcEnum)request.getUpdateType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", InstallAllUpdatesOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallAllUpdatesOnManagedInstanceGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallAllWindowsUpdatesOnManagedInstanceResponse> installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallAllWindowsUpdatesOnManagedInstanceRequest, InstallAllWindowsUpdatesOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, InstallAllWindowsUpdatesOnManagedInstanceResponse::builder).logger(LOG, "installAllWindowsUpdatesOnManagedInstance").serviceDetails("OsManagement", "InstallAllWindowsUpdatesOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllWindowsUpdatesOnManagedInstance").method(Method.POST).requestBuilder(InstallAllWindowsUpdatesOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("updates").appendPathParam("installAll").appendEnumQueryParam("updateType", (BmcEnum)request.getUpdateType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", InstallAllWindowsUpdatesOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallAllWindowsUpdatesOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallModuleStreamProfileOnManagedInstanceResponse> installModuleStreamProfileOnManagedInstance(InstallModuleStreamProfileOnManagedInstanceRequest request, AsyncHandler<InstallModuleStreamProfileOnManagedInstanceRequest, InstallModuleStreamProfileOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        return this.clientCall(request, InstallModuleStreamProfileOnManagedInstanceResponse::builder).logger(LOG, "installModuleStreamProfileOnManagedInstance").serviceDetails("OsManagement", "InstallModuleStreamProfileOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/InstallModuleStreamProfileOnManagedInstance").method(Method.POST).requestBuilder(InstallModuleStreamProfileOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("streamProfiles").appendPathParam("install").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("profileName", (Object)request.getProfileName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", InstallModuleStreamProfileOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallModuleStreamProfileOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallPackageOnManagedInstanceResponse> installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request, AsyncHandler<InstallPackageOnManagedInstanceRequest, InstallPackageOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSoftwarePackageName(), "softwarePackageName is required");
        return this.clientCall(request, InstallPackageOnManagedInstanceResponse::builder).logger(LOG, "installPackageOnManagedInstance").serviceDetails("OsManagement", "InstallPackageOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageOnManagedInstance").method(Method.POST).requestBuilder(InstallPackageOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("packages").appendPathParam("install").appendQueryParam("softwarePackageName", (Object)request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", InstallPackageOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallPackageOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallPackageUpdateOnManagedInstanceResponse> installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request, AsyncHandler<InstallPackageUpdateOnManagedInstanceRequest, InstallPackageUpdateOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSoftwarePackageName(), "softwarePackageName is required");
        return this.clientCall(request, InstallPackageUpdateOnManagedInstanceResponse::builder).logger(LOG, "installPackageUpdateOnManagedInstance").serviceDetails("OsManagement", "InstallPackageUpdateOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageUpdateOnManagedInstance").method(Method.POST).requestBuilder(InstallPackageUpdateOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("packages").appendPathParam("update").appendQueryParam("softwarePackageName", (Object)request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", InstallPackageUpdateOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallPackageUpdateOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallWindowsUpdateOnManagedInstanceResponse> installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request, AsyncHandler<InstallWindowsUpdateOnManagedInstanceRequest, InstallWindowsUpdateOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getWindowsUpdateName(), "windowsUpdateName is required");
        return this.clientCall(request, InstallWindowsUpdateOnManagedInstanceResponse::builder).logger(LOG, "installWindowsUpdateOnManagedInstance").serviceDetails("OsManagement", "InstallWindowsUpdateOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallWindowsUpdateOnManagedInstance").method(Method.POST).requestBuilder(InstallWindowsUpdateOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("updates").appendPathParam("install").appendQueryParam("windowsUpdateName", (Object)request.getWindowsUpdateName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", InstallWindowsUpdateOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallWindowsUpdateOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAvailablePackagesForManagedInstanceResponse> listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request, AsyncHandler<ListAvailablePackagesForManagedInstanceRequest, ListAvailablePackagesForManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAvailablePackagesForManagedInstanceResponse::builder).logger(LOG, "listAvailablePackagesForManagedInstance").serviceDetails("OsManagement", "ListAvailablePackagesForManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailablePackagesForManagedInstance").method(Method.GET).requestBuilder(ListAvailablePackagesForManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("packages").appendPathParam("available").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstallablePackageSummary.class, ListAvailablePackagesForManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAvailablePackagesForManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAvailablePackagesForManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAvailableSoftwareSourcesForManagedInstanceResponse> listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request, AsyncHandler<ListAvailableSoftwareSourcesForManagedInstanceRequest, ListAvailableSoftwareSourcesForManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAvailableSoftwareSourcesForManagedInstanceResponse::builder).logger(LOG, "listAvailableSoftwareSourcesForManagedInstance").serviceDetails("OsManagement", "ListAvailableSoftwareSourcesForManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableSoftwareSourcesForManagedInstance").method(Method.GET).requestBuilder(ListAvailableSoftwareSourcesForManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("availableSoftwareSources").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AvailableSoftwareSourceSummary.class, ListAvailableSoftwareSourcesForManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAvailableSoftwareSourcesForManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAvailableSoftwareSourcesForManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAvailableUpdatesForManagedInstanceResponse> listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request, AsyncHandler<ListAvailableUpdatesForManagedInstanceRequest, ListAvailableUpdatesForManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAvailableUpdatesForManagedInstanceResponse::builder).logger(LOG, "listAvailableUpdatesForManagedInstance").serviceDetails("OsManagement", "ListAvailableUpdatesForManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableUpdatesForManagedInstance").method(Method.GET).requestBuilder(ListAvailableUpdatesForManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("packages").appendPathParam("updates").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AvailableUpdateSummary.class, ListAvailableUpdatesForManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAvailableUpdatesForManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAvailableUpdatesForManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAvailableWindowsUpdatesForManagedInstanceResponse> listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request, AsyncHandler<ListAvailableWindowsUpdatesForManagedInstanceRequest, ListAvailableWindowsUpdatesForManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAvailableWindowsUpdatesForManagedInstanceResponse::builder).logger(LOG, "listAvailableWindowsUpdatesForManagedInstance").serviceDetails("OsManagement", "ListAvailableWindowsUpdatesForManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableWindowsUpdatesForManagedInstance").method(Method.GET).requestBuilder(ListAvailableWindowsUpdatesForManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("updates").appendPathParam("available").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("isEligibleForInstallation", (BmcEnum)request.getIsEligibleForInstallation()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AvailableWindowsUpdateSummary.class, ListAvailableWindowsUpdatesForManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAvailableWindowsUpdatesForManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAvailableWindowsUpdatesForManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListErrataResponse> listErrata(ListErrataRequest request, AsyncHandler<ListErrataRequest, ListErrataResponse> handler) {
        return this.clientCall(request, ListErrataResponse::builder).logger(LOG, "listErrata").serviceDetails("OsManagement", "ListErrata", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ErratumSummary/ListErrata").method(Method.GET).requestBuilder(ListErrataRequest::builder).basePath("/20190801").appendPathParam("errata").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("erratumId", (Object)request.getErratumId()).appendQueryParam("advisoryName", (Object)request.getAdvisoryName()).appendQueryParam("timeIssueDateStart", (Object)request.getTimeIssueDateStart()).appendQueryParam("timeIssueDateEnd", (Object)request.getTimeIssueDateEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ErratumSummary.class, ListErrataResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListErrataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListErrataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceErrataResponse> listManagedInstanceErrata(ListManagedInstanceErrataRequest request, AsyncHandler<ListManagedInstanceErrataRequest, ListManagedInstanceErrataResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceErrataResponse::builder).logger(LOG, "listManagedInstanceErrata").serviceDetails("OsManagement", "ListManagedInstanceErrata", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListManagedInstanceErrata").method(Method.GET).requestBuilder(ListManagedInstanceErrataRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("errata").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ErratumSummary.class, ListManagedInstanceErrataResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListManagedInstanceErrataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceErrataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceGroupsResponse> listManagedInstanceGroups(ListManagedInstanceGroupsRequest request, AsyncHandler<ListManagedInstanceGroupsRequest, ListManagedInstanceGroupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagedInstanceGroupsResponse::builder).logger(LOG, "listManagedInstanceGroups").serviceDetails("OsManagement", "ListManagedInstanceGroups", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroupSummary/ListManagedInstanceGroups").method(Method.GET).requestBuilder(ListManagedInstanceGroupsRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ManagedInstanceGroupSummary.class, ListManagedInstanceGroupsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstancesResponse> listManagedInstances(ListManagedInstancesRequest request, AsyncHandler<ListManagedInstancesRequest, ListManagedInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagedInstancesResponse::builder).logger(LOG, "listManagedInstances").serviceDetails("OsManagement", "ListManagedInstances", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceSummary/ListManagedInstances").method(Method.GET).requestBuilder(ListManagedInstancesRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ManagedInstanceSummary.class, ListManagedInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListManagedInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModuleStreamProfilesResponse> listModuleStreamProfiles(ListModuleStreamProfilesRequest request, AsyncHandler<ListModuleStreamProfilesRequest, ListModuleStreamProfilesResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListModuleStreamProfilesResponse::builder).logger(LOG, "listModuleStreamProfiles").serviceDetails("OsManagement", "ListModuleStreamProfiles", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileSummary/ListModuleStreamProfiles").method(Method.GET).requestBuilder(ListModuleStreamProfilesRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("streamProfiles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("profileName", (Object)request.getProfileName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModuleStreamProfileSummary.class, ListModuleStreamProfilesResponse.Builder::items).handleResponseHeaderString("opc-work-request-id", ListModuleStreamProfilesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ListModuleStreamProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamProfilesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModuleStreamProfilesOnManagedInstanceResponse> listModuleStreamProfilesOnManagedInstance(ListModuleStreamProfilesOnManagedInstanceRequest request, AsyncHandler<ListModuleStreamProfilesOnManagedInstanceRequest, ListModuleStreamProfilesOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListModuleStreamProfilesOnManagedInstanceResponse::builder).logger(LOG, "listModuleStreamProfilesOnManagedInstance").serviceDetails("OsManagement", "ListModuleStreamProfilesOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamProfilesOnManagedInstance").method(Method.GET).requestBuilder(ListModuleStreamProfilesOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("streamProfiles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("profileName", (Object)request.getProfileName()).appendEnumQueryParam("profileStatus", (BmcEnum)request.getProfileStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModuleStreamProfileOnManagedInstanceSummary.class, ListModuleStreamProfilesOnManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-work-request-id", ListModuleStreamProfilesOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ListModuleStreamProfilesOnManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamProfilesOnManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModuleStreamsResponse> listModuleStreams(ListModuleStreamsRequest request, AsyncHandler<ListModuleStreamsRequest, ListModuleStreamsResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListModuleStreamsResponse::builder).logger(LOG, "listModuleStreams").serviceDetails("OsManagement", "ListModuleStreams", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamSummary/ListModuleStreams").method(Method.GET).requestBuilder(ListModuleStreamsRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreams").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModuleStreamSummary.class, ListModuleStreamsResponse.Builder::items).handleResponseHeaderString("opc-work-request-id", ListModuleStreamsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ListModuleStreamsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModuleStreamsOnManagedInstanceResponse> listModuleStreamsOnManagedInstance(ListModuleStreamsOnManagedInstanceRequest request, AsyncHandler<ListModuleStreamsOnManagedInstanceRequest, ListModuleStreamsOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListModuleStreamsOnManagedInstanceResponse::builder).logger(LOG, "listModuleStreamsOnManagedInstance").serviceDetails("OsManagement", "ListModuleStreamsOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamsOnManagedInstance").method(Method.GET).requestBuilder(ListModuleStreamsOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("moduleStreams").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendEnumQueryParam("streamStatus", (BmcEnum)request.getStreamStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModuleStreamOnManagedInstanceSummary.class, ListModuleStreamsOnManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-work-request-id", ListModuleStreamsOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ListModuleStreamsOnManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamsOnManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPackagesInstalledOnManagedInstanceResponse> listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request, AsyncHandler<ListPackagesInstalledOnManagedInstanceRequest, ListPackagesInstalledOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPackagesInstalledOnManagedInstanceResponse::builder).logger(LOG, "listPackagesInstalledOnManagedInstance").serviceDetails("OsManagement", "ListPackagesInstalledOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListPackagesInstalledOnManagedInstance").method(Method.GET).requestBuilder(ListPackagesInstalledOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("packages").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstalledPackageSummary.class, ListPackagesInstalledOnManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPackagesInstalledOnManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPackagesInstalledOnManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListScheduledJobsResponse> listScheduledJobs(ListScheduledJobsRequest request, AsyncHandler<ListScheduledJobsRequest, ListScheduledJobsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListScheduledJobsResponse::builder).logger(LOG, "listScheduledJobs").serviceDetails("OsManagement", "ListScheduledJobs", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListScheduledJobs").method(Method.GET).requestBuilder(ListScheduledJobsRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendQueryParam("isRestricted", (Object)request.getIsRestricted()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ScheduledJobSummary.class, ListScheduledJobsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListScheduledJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSoftwareSourcePackagesResponse> listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request, AsyncHandler<ListSoftwareSourcePackagesRequest, ListSoftwareSourcePackagesResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSoftwareSourcePackagesResponse::builder).logger(LOG, "listSoftwareSourcePackages").serviceDetails("OsManagement", "ListSoftwareSourcePackages", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ListSoftwareSourcePackages").method(Method.GET).requestBuilder(ListSoftwareSourcePackagesRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("softwarePackages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SoftwarePackageSummary.class, ListSoftwareSourcePackagesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSoftwareSourcePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwareSourcePackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSoftwareSourcesResponse> listSoftwareSources(ListSoftwareSourcesRequest request, AsyncHandler<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSoftwareSourcesResponse::builder).logger(LOG, "listSoftwareSources").serviceDetails("OsManagement", "ListSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSourceSummary/ListSoftwareSources").method(Method.GET).requestBuilder(ListSoftwareSourcesRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SoftwareSourceSummary.class, ListSoftwareSourcesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwareSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListUpcomingScheduledJobsResponse> listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request, AsyncHandler<ListUpcomingScheduledJobsRequest, ListUpcomingScheduledJobsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getTimeEnd(), "timeEnd is required");
        return this.clientCall(request, ListUpcomingScheduledJobsResponse::builder).logger(LOG, "listUpcomingScheduledJobs").serviceDetails("OsManagement", "ListUpcomingScheduledJobs", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListUpcomingScheduledJobs").method(Method.GET).requestBuilder(ListUpcomingScheduledJobsRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam("upcomingSchedules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("tagName", (Object)request.getTagName()).appendQueryParam("tagValue", (Object)request.getTagValue()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ScheduledJobSummary.class, ListUpcomingScheduledJobsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListUpcomingScheduledJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUpcomingScheduledJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWindowsUpdatesResponse> listWindowsUpdates(ListWindowsUpdatesRequest request, AsyncHandler<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse> handler) {
        return this.clientCall(request, ListWindowsUpdatesResponse::builder).logger(LOG, "listWindowsUpdates").serviceDetails("OsManagement", "ListWindowsUpdates", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdateSummary/ListWindowsUpdates").method(Method.GET).requestBuilder(ListWindowsUpdatesRequest::builder).basePath("/20190801").appendPathParam("updates").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WindowsUpdateSummary.class, ListWindowsUpdatesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWindowsUpdatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWindowsUpdatesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWindowsUpdatesInstalledOnManagedInstanceResponse> listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request, AsyncHandler<ListWindowsUpdatesInstalledOnManagedInstanceRequest, ListWindowsUpdatesInstalledOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWindowsUpdatesInstalledOnManagedInstanceResponse::builder).logger(LOG, "listWindowsUpdatesInstalledOnManagedInstance").serviceDetails("OsManagement", "ListWindowsUpdatesInstalledOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListWindowsUpdatesInstalledOnManagedInstance").method(Method.GET).requestBuilder(ListWindowsUpdatesInstalledOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("updates").appendPathParam("installed").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstalledWindowsUpdateSummary.class, ListWindowsUpdatesInstalledOnManagedInstanceResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWindowsUpdatesInstalledOnManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWindowsUpdatesInstalledOnManagedInstanceResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OsManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190801").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderFloat("retry-after", ListWorkRequestErrorsResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OsManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190801").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderFloat("retry-after", ListWorkRequestLogsResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OsManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190801").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ManageModuleStreamsOnManagedInstanceResponse> manageModuleStreamsOnManagedInstance(ManageModuleStreamsOnManagedInstanceRequest request, AsyncHandler<ManageModuleStreamsOnManagedInstanceRequest, ManageModuleStreamsOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManageModuleStreamsOnManagedInstanceDetails(), "manageModuleStreamsOnManagedInstanceDetails is required");
        return this.clientCall(request, ManageModuleStreamsOnManagedInstanceResponse::builder).logger(LOG, "manageModuleStreamsOnManagedInstance").serviceDetails("OsManagement", "ManageModuleStreamsOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ManageModuleStreamsOnManagedInstance").method(Method.POST).requestBuilder(ManageModuleStreamsOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("moduleStreams").appendPathParam("manage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", ManageModuleStreamsOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ManageModuleStreamsOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveModuleStreamProfileFromManagedInstanceResponse> removeModuleStreamProfileFromManagedInstance(RemoveModuleStreamProfileFromManagedInstanceRequest request, AsyncHandler<RemoveModuleStreamProfileFromManagedInstanceRequest, RemoveModuleStreamProfileFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        return this.clientCall(request, RemoveModuleStreamProfileFromManagedInstanceResponse::builder).logger(LOG, "removeModuleStreamProfileFromManagedInstance").serviceDetails("OsManagement", "RemoveModuleStreamProfileFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/RemoveModuleStreamProfileFromManagedInstance").method(Method.POST).requestBuilder(RemoveModuleStreamProfileFromManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("streamProfiles").appendPathParam("remove").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("profileName", (Object)request.getProfileName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", RemoveModuleStreamProfileFromManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveModuleStreamProfileFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemovePackageFromManagedInstanceResponse> removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request, AsyncHandler<RemovePackageFromManagedInstanceRequest, RemovePackageFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSoftwarePackageName(), "softwarePackageName is required");
        return this.clientCall(request, RemovePackageFromManagedInstanceResponse::builder).logger(LOG, "removePackageFromManagedInstance").serviceDetails("OsManagement", "RemovePackageFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/RemovePackageFromManagedInstance").method(Method.POST).requestBuilder(RemovePackageFromManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("packages").appendPathParam("remove").appendQueryParam("softwarePackageName", (Object)request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", RemovePackageFromManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemovePackageFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemovePackagesFromSoftwareSourceResponse> removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request, AsyncHandler<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemovePackagesFromSoftwareSourceDetails(), "removePackagesFromSoftwareSourceDetails is required");
        return this.clientCall(request, RemovePackagesFromSoftwareSourceResponse::builder).logger(LOG, "removePackagesFromSoftwareSource").serviceDetails("OsManagement", "RemovePackagesFromSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/RemovePackagesFromSoftwareSource").method(Method.POST).requestBuilder(RemovePackagesFromSoftwareSourceRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("removePackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", RemovePackagesFromSoftwareSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RunScheduledJobNowResponse> runScheduledJobNow(RunScheduledJobNowRequest request, AsyncHandler<RunScheduledJobNowRequest, RunScheduledJobNowResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RunScheduledJobNowResponse::builder).logger(LOG, "runScheduledJobNow").serviceDetails("OsManagement", "RunScheduledJobNow", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/RunScheduledJobNow").method(Method.POST).requestBuilder(RunScheduledJobNowRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("runNow").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("etag", RunScheduledJobNowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RunScheduledJobNowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SearchSoftwarePackagesResponse> searchSoftwarePackages(SearchSoftwarePackagesRequest request, AsyncHandler<SearchSoftwarePackagesRequest, SearchSoftwarePackagesResponse> handler) {
        return this.clientCall(request, SearchSoftwarePackagesResponse::builder).logger(LOG, "searchSoftwarePackages").serviceDetails("OsManagement", "SearchSoftwarePackages", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/SearchSoftwarePackages").method(Method.GET).requestBuilder(SearchSoftwarePackagesRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam("softwarePackages").appendQueryParam("softwarePackageName", (Object)request.getSoftwarePackageName()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("cveName", (Object)request.getCveName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SoftwarePackageSearchSummary.class, SearchSoftwarePackagesResponse.Builder::items).handleResponseHeaderString("opc-request-id", SearchSoftwarePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwarePackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SkipNextScheduledJobExecutionResponse> skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request, AsyncHandler<SkipNextScheduledJobExecutionRequest, SkipNextScheduledJobExecutionResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SkipNextScheduledJobExecutionResponse::builder).logger(LOG, "skipNextScheduledJobExecution").serviceDetails("OsManagement", "SkipNextScheduledJobExecution", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/SkipNextScheduledJobExecution").method(Method.POST).requestBuilder(SkipNextScheduledJobExecutionRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("skipNextExecution").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("etag", SkipNextScheduledJobExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SkipNextScheduledJobExecutionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SwitchModuleStreamOnManagedInstanceResponse> switchModuleStreamOnManagedInstance(SwitchModuleStreamOnManagedInstanceRequest request, AsyncHandler<SwitchModuleStreamOnManagedInstanceRequest, SwitchModuleStreamOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        return this.clientCall(request, SwitchModuleStreamOnManagedInstanceResponse::builder).logger(LOG, "switchModuleStreamOnManagedInstance").serviceDetails("OsManagement", "SwitchModuleStreamOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/SwitchModuleStreamOnManagedInstance").method(Method.POST).requestBuilder(SwitchModuleStreamOnManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("moduleStreams").appendPathParam("switch").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", SwitchModuleStreamOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SwitchModuleStreamOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateManagedInstanceResponse> updateManagedInstance(UpdateManagedInstanceRequest request, AsyncHandler<UpdateManagedInstanceRequest, UpdateManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedInstanceDetails(), "updateManagedInstanceDetails is required");
        return this.clientCall(request, UpdateManagedInstanceResponse::builder).logger(LOG, "updateManagedInstance").serviceDetails("OsManagement", "UpdateManagedInstance", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/UpdateManagedInstanceDetails/UpdateManagedInstance").method(Method.PUT).requestBuilder(UpdateManagedInstanceRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ManagedInstance.class, UpdateManagedInstanceResponse.Builder::managedInstance).handleResponseHeaderString("etag", UpdateManagedInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateManagedInstanceGroupResponse> updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request, AsyncHandler<UpdateManagedInstanceGroupRequest, UpdateManagedInstanceGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedInstanceGroupDetails(), "updateManagedInstanceGroupDetails is required");
        return this.clientCall(request, UpdateManagedInstanceGroupResponse::builder).logger(LOG, "updateManagedInstanceGroup").serviceDetails("OsManagement", "UpdateManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/UpdateManagedInstanceGroup").method(Method.PUT).requestBuilder(UpdateManagedInstanceGroupRequest::builder).basePath("/20190801").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ManagedInstanceGroup.class, UpdateManagedInstanceGroupResponse.Builder::managedInstanceGroup).handleResponseHeaderString("etag", UpdateManagedInstanceGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateManagedInstanceGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateScheduledJobResponse> updateScheduledJob(UpdateScheduledJobRequest request, AsyncHandler<UpdateScheduledJobRequest, UpdateScheduledJobResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScheduledJobDetails(), "updateScheduledJobDetails is required");
        return this.clientCall(request, UpdateScheduledJobResponse::builder).logger(LOG, "updateScheduledJob").serviceDetails("OsManagement", "UpdateScheduledJob", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/UpdateScheduledJob").method(Method.PUT).requestBuilder(UpdateScheduledJobRequest::builder).basePath("/20190801").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ScheduledJob.class, UpdateScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("etag", UpdateScheduledJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateScheduledJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSoftwareSourceResponse> updateSoftwareSource(UpdateSoftwareSourceRequest request, AsyncHandler<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSoftwareSourceDetails(), "updateSoftwareSourceDetails is required");
        return this.clientCall(request, UpdateSoftwareSourceResponse::builder).logger(LOG, "updateSoftwareSource").serviceDetails("OsManagement", "UpdateSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/UpdateSoftwareSource").method(Method.PUT).requestBuilder(UpdateSoftwareSourceRequest::builder).basePath("/20190801").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(SoftwareSource.class, UpdateSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", UpdateSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSoftwareSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OsManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OsManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OsManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "osmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OsManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OsManagementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

