/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.EventPaginators;
import com.oracle.bmc.osmanagementhub.EventWaiters;
import com.oracle.bmc.osmanagementhub.model.Event;
import com.oracle.bmc.osmanagementhub.model.EventCollection;
import com.oracle.bmc.osmanagementhub.requests.ChangeEventCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteEventRequest;
import com.oracle.bmc.osmanagementhub.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetEventRequest;
import com.oracle.bmc.osmanagementhub.requests.ImportEventContentRequest;
import com.oracle.bmc.osmanagementhub.requests.ListEventsRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeEventCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteEventResponse;
import com.oracle.bmc.osmanagementhub.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetEventResponse;
import com.oracle.bmc.osmanagementhub.responses.ImportEventContentResponse;
import com.oracle.bmc.osmanagementhub.responses.ListEventsResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateEventResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventClient
extends BaseSyncClient
implements com.oracle.bmc.osmanagementhub.Event {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EventClient.class);
    private final EventWaiters waiters;
    private final EventPaginators paginators;

    EventClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    EventClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Event-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new EventWaiters(executorService, this);
        this.paginators = new EventPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"EventClient", (String)"getEventContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeEventCompartmentResponse changeEventCompartment(ChangeEventCompartmentRequest request) {
        Objects.requireNonNull(request.getChangeEventCompartmentDetails(), "changeEventCompartmentDetails is required");
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        return (ChangeEventCompartmentResponse)this.clientCall(request, ChangeEventCompartmentResponse::builder).logger(LOG, "changeEventCompartment").serviceDetails("Event", "ChangeEventCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/ChangeEventCompartment").method(Method.POST).requestBuilder(ChangeEventCompartmentRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeEventCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteEventResponse deleteEvent(DeleteEventRequest request) {
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        return (DeleteEventResponse)this.clientCall(request, DeleteEventResponse::builder).logger(LOG, "deleteEvent").serviceDetails("Event", "DeleteEvent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/DeleteEvent").method(Method.DELETE).requestBuilder(DeleteEventRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteEventResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEventResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteEventContentResponse deleteEventContent(DeleteEventContentRequest request) {
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        return (DeleteEventContentResponse)this.clientCall(request, DeleteEventContentResponse::builder).logger(LOG, "deleteEventContent").serviceDetails("Event", "DeleteEventContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/DeleteEventContent").method(Method.DELETE).requestBuilder(DeleteEventContentRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteEventContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEventResponse getEvent(GetEventRequest request) {
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        return (GetEventResponse)this.clientCall(request, GetEventResponse::builder).logger(LOG, "getEvent").serviceDetails("Event", "GetEvent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/GetEvent").method(Method.GET).requestBuilder(GetEventRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Event.class, GetEventResponse.Builder::event).handleResponseHeaderString("etag", GetEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEventResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEventContentResponse getEventContent(GetEventContentRequest request) {
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        return (GetEventContentResponse)this.clientCall(request, GetEventContentResponse::builder).logger(LOG, "getEventContent").serviceDetails("Event", "GetEventContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/GetEventContent").method(Method.GET).requestBuilder(GetEventContentRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetEventContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetEventContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEventContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportEventContentResponse importEventContent(ImportEventContentRequest request) {
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        return (ImportEventContentResponse)this.clientCall(request, ImportEventContentResponse::builder).logger(LOG, "importEventContent").serviceDetails("Event", "ImportEventContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/ImportEventContent").method(Method.POST).requestBuilder(ImportEventContentRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("actions").appendPathParam("importContent").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", ImportEventContentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportEventContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListEventsResponse listEvents(ListEventsRequest request) {
        return (ListEventsResponse)this.clientCall(request, ListEventsResponse::builder).logger(LOG, "listEvents").serviceDetails("Event", "ListEvents", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/EventCollection/ListEvents").method(Method.GET).requestBuilder(ListEventsRequest::builder).basePath("/20220901").appendPathParam("events").appendQueryParam("eventSummary", (Object)request.getEventSummary()).appendQueryParam("eventSummaryContains", (Object)request.getEventSummaryContains()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("eventFingerprint", (Object)request.getEventFingerprint()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(EventCollection.class, ListEventsResponse.Builder::eventCollection).handleResponseHeaderString("opc-request-id", ListEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEventsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateEventResponse updateEvent(UpdateEventRequest request) {
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEventDetails(), "updateEventDetails is required");
        return (UpdateEventResponse)this.clientCall(request, UpdateEventResponse::builder).logger(LOG, "updateEvent").serviceDetails("Event", "UpdateEvent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Event/UpdateEvent").method(Method.PUT).requestBuilder(UpdateEventRequest::builder).basePath("/20220901").appendPathParam("events").appendPathParam(request.getEventId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Event.class, UpdateEventResponse.Builder::event).handleResponseHeaderString("etag", UpdateEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEventResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EventWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public EventPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EventClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EventClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public EventClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EventClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

