/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.Event;
import com.oracle.bmc.osmanagementhub.model.EventSummary;
import com.oracle.bmc.osmanagementhub.requests.ListEventsRequest;
import com.oracle.bmc.osmanagementhub.responses.ListEventsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class EventPaginators {
    private final Event client;

    public EventPaginators(Event client) {
        this.client = client;
    }

    public Iterable<ListEventsResponse> listEventsResponseIterator(final ListEventsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEventsRequest.Builder>(){

            @Override
            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEventsResponse, String>(){

            @Override
            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            @Override
            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEventsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEventsRequest, ListEventsResponse>(){

            @Override
            public ListEventsResponse apply(ListEventsRequest request) {
                return EventPaginators.this.client.listEvents(request);
            }
        });
    }

    public Iterable<EventSummary> listEventsRecordIterator(final ListEventsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEventsRequest.Builder>(){

            @Override
            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEventsResponse, String>(){

            @Override
            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            @Override
            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEventsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEventsRequest, ListEventsResponse>(){

            @Override
            public ListEventsResponse apply(ListEventsRequest request) {
                return EventPaginators.this.client.listEvents(request);
            }
        }, (Function)new Function<ListEventsResponse, List<EventSummary>>(){

            @Override
            public List<EventSummary> apply(ListEventsResponse response) {
                return response.getEventCollection().getItems();
            }
        });
    }
}

