/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.Event;
import com.oracle.bmc.osmanagementhub.model.Event;
import com.oracle.bmc.osmanagementhub.requests.GetEventRequest;
import com.oracle.bmc.osmanagementhub.responses.GetEventResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class EventWaiters {
    private final ExecutorService executorService;
    private final Event client;

    public EventWaiters(ExecutorService executorService, Event client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEventRequest, GetEventResponse> forEvent(GetEventRequest request, Event.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEvent(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEventRequest, GetEventResponse> forEvent(GetEventRequest request, Event.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEvent(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEventRequest, GetEventResponse> forEvent(GetEventRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Event.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEvent(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEventRequest, GetEventResponse> forEvent(BmcGenericWaiter waiter, GetEventRequest request, Event.LifecycleState ... targetStates) {
        final HashSet<Event.LifecycleState> targetStatesSet = new HashSet<Event.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEventRequest, GetEventResponse>(){

            @Override
            public GetEventResponse apply(GetEventRequest request) {
                return EventWaiters.this.client.getEvent(request);
            }
        }, (Predicate)new Predicate<GetEventResponse>(){

            @Override
            public boolean test(GetEventResponse response) {
                return targetStatesSet.contains((Object)response.getEvent().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Event.LifecycleState.Deleted)), (Object)request);
    }
}

