/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.LifecycleEnvironment;
import com.oracle.bmc.osmanagementhub.LifecycleEnvironmentPaginators;
import com.oracle.bmc.osmanagementhub.LifecycleEnvironmentWaiters;
import com.oracle.bmc.osmanagementhub.model.InstalledPackageCollection;
import com.oracle.bmc.osmanagementhub.model.LifecycleEnvironmentCollection;
import com.oracle.bmc.osmanagementhub.model.LifecycleStage;
import com.oracle.bmc.osmanagementhub.model.LifecycleStageCollection;
import com.oracle.bmc.osmanagementhub.requests.AttachManagedInstancesToLifecycleStageRequest;
import com.oracle.bmc.osmanagementhub.requests.ChangeLifecycleEnvironmentCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateLifecycleEnvironmentRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteLifecycleEnvironmentRequest;
import com.oracle.bmc.osmanagementhub.requests.DetachManagedInstancesFromLifecycleStageRequest;
import com.oracle.bmc.osmanagementhub.requests.GetLifecycleEnvironmentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetLifecycleStageRequest;
import com.oracle.bmc.osmanagementhub.requests.ListLifecycleEnvironmentsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListLifecycleStageInstalledPackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListLifecycleStagesRequest;
import com.oracle.bmc.osmanagementhub.requests.PromoteSoftwareSourceToLifecycleStageRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateLifecycleEnvironmentRequest;
import com.oracle.bmc.osmanagementhub.responses.AttachManagedInstancesToLifecycleStageResponse;
import com.oracle.bmc.osmanagementhub.responses.ChangeLifecycleEnvironmentCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateLifecycleEnvironmentResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteLifecycleEnvironmentResponse;
import com.oracle.bmc.osmanagementhub.responses.DetachManagedInstancesFromLifecycleStageResponse;
import com.oracle.bmc.osmanagementhub.responses.GetLifecycleEnvironmentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetLifecycleStageResponse;
import com.oracle.bmc.osmanagementhub.responses.ListLifecycleEnvironmentsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListLifecycleStageInstalledPackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListLifecycleStagesResponse;
import com.oracle.bmc.osmanagementhub.responses.PromoteSoftwareSourceToLifecycleStageResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateLifecycleEnvironmentResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleEnvironmentClient
extends BaseSyncClient
implements LifecycleEnvironment {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LIFECYCLEENVIRONMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleEnvironmentClient.class);
    private final LifecycleEnvironmentWaiters waiters;
    private final LifecycleEnvironmentPaginators paginators;

    LifecycleEnvironmentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("LifecycleEnvironment-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LifecycleEnvironmentWaiters(executorService, this);
        this.paginators = new LifecycleEnvironmentPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AttachManagedInstancesToLifecycleStageResponse attachManagedInstancesToLifecycleStage(AttachManagedInstancesToLifecycleStageRequest request) {
        Validate.notBlank((String)request.getLifecycleStageId(), (String)"lifecycleStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachManagedInstancesToLifecycleStageDetails(), "attachManagedInstancesToLifecycleStageDetails is required");
        return (AttachManagedInstancesToLifecycleStageResponse)this.clientCall(request, AttachManagedInstancesToLifecycleStageResponse::builder).logger(LOG, "attachManagedInstancesToLifecycleStage").serviceDetails("LifecycleEnvironment", "AttachManagedInstancesToLifecycleStage", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleStage/AttachManagedInstancesToLifecycleStage").method(Method.POST).requestBuilder(AttachManagedInstancesToLifecycleStageRequest::builder).basePath("/20220901").appendPathParam("lifecycleStages").appendPathParam(request.getLifecycleStageId()).appendPathParam("actions").appendPathParam("attachManagedInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", AttachManagedInstancesToLifecycleStageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AttachManagedInstancesToLifecycleStageResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeLifecycleEnvironmentCompartmentResponse changeLifecycleEnvironmentCompartment(ChangeLifecycleEnvironmentCompartmentRequest request) {
        Validate.notBlank((String)request.getLifecycleEnvironmentId(), (String)"lifecycleEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLifecycleEnvironmentCompartmentDetails(), "changeLifecycleEnvironmentCompartmentDetails is required");
        return (ChangeLifecycleEnvironmentCompartmentResponse)this.clientCall(request, ChangeLifecycleEnvironmentCompartmentResponse::builder).logger(LOG, "changeLifecycleEnvironmentCompartment").serviceDetails("LifecycleEnvironment", "ChangeLifecycleEnvironmentCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleEnvironment/ChangeLifecycleEnvironmentCompartment").method(Method.POST).requestBuilder(ChangeLifecycleEnvironmentCompartmentRequest::builder).basePath("/20220901").appendPathParam("lifecycleEnvironments").appendPathParam(request.getLifecycleEnvironmentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeLifecycleEnvironmentCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateLifecycleEnvironmentResponse createLifecycleEnvironment(CreateLifecycleEnvironmentRequest request) {
        Objects.requireNonNull(request.getCreateLifecycleEnvironmentDetails(), "createLifecycleEnvironmentDetails is required");
        return (CreateLifecycleEnvironmentResponse)this.clientCall(request, CreateLifecycleEnvironmentResponse::builder).logger(LOG, "createLifecycleEnvironment").serviceDetails("LifecycleEnvironment", "CreateLifecycleEnvironment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleEnvironment/CreateLifecycleEnvironment").method(Method.POST).requestBuilder(CreateLifecycleEnvironmentRequest::builder).basePath("/20220901").appendPathParam("lifecycleEnvironments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.LifecycleEnvironment.class, CreateLifecycleEnvironmentResponse.Builder::lifecycleEnvironment).handleResponseHeaderString("etag", CreateLifecycleEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateLifecycleEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLifecycleEnvironmentResponse deleteLifecycleEnvironment(DeleteLifecycleEnvironmentRequest request) {
        Validate.notBlank((String)request.getLifecycleEnvironmentId(), (String)"lifecycleEnvironmentId must not be blank", (Object[])new Object[0]);
        return (DeleteLifecycleEnvironmentResponse)this.clientCall(request, DeleteLifecycleEnvironmentResponse::builder).logger(LOG, "deleteLifecycleEnvironment").serviceDetails("LifecycleEnvironment", "DeleteLifecycleEnvironment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleEnvironment/DeleteLifecycleEnvironment").method(Method.DELETE).requestBuilder(DeleteLifecycleEnvironmentRequest::builder).basePath("/20220901").appendPathParam("lifecycleEnvironments").appendPathParam(request.getLifecycleEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteLifecycleEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachManagedInstancesFromLifecycleStageResponse detachManagedInstancesFromLifecycleStage(DetachManagedInstancesFromLifecycleStageRequest request) {
        Validate.notBlank((String)request.getLifecycleStageId(), (String)"lifecycleStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachManagedInstancesFromLifecycleStageDetails(), "detachManagedInstancesFromLifecycleStageDetails is required");
        return (DetachManagedInstancesFromLifecycleStageResponse)this.clientCall(request, DetachManagedInstancesFromLifecycleStageResponse::builder).logger(LOG, "detachManagedInstancesFromLifecycleStage").serviceDetails("LifecycleEnvironment", "DetachManagedInstancesFromLifecycleStage", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleStage/DetachManagedInstancesFromLifecycleStage").method(Method.POST).requestBuilder(DetachManagedInstancesFromLifecycleStageRequest::builder).basePath("/20220901").appendPathParam("lifecycleStages").appendPathParam(request.getLifecycleStageId()).appendPathParam("actions").appendPathParam("detachManagedInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", DetachManagedInstancesFromLifecycleStageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DetachManagedInstancesFromLifecycleStageResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetLifecycleEnvironmentResponse getLifecycleEnvironment(GetLifecycleEnvironmentRequest request) {
        Validate.notBlank((String)request.getLifecycleEnvironmentId(), (String)"lifecycleEnvironmentId must not be blank", (Object[])new Object[0]);
        return (GetLifecycleEnvironmentResponse)this.clientCall(request, GetLifecycleEnvironmentResponse::builder).logger(LOG, "getLifecycleEnvironment").serviceDetails("LifecycleEnvironment", "GetLifecycleEnvironment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleEnvironment/GetLifecycleEnvironment").method(Method.GET).requestBuilder(GetLifecycleEnvironmentRequest::builder).basePath("/20220901").appendPathParam("lifecycleEnvironments").appendPathParam(request.getLifecycleEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.osmanagementhub.model.LifecycleEnvironment.class, GetLifecycleEnvironmentResponse.Builder::lifecycleEnvironment).handleResponseHeaderString("etag", GetLifecycleEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLifecycleEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLifecycleStageResponse getLifecycleStage(GetLifecycleStageRequest request) {
        Validate.notBlank((String)request.getLifecycleStageId(), (String)"lifecycleStageId must not be blank", (Object[])new Object[0]);
        return (GetLifecycleStageResponse)this.clientCall(request, GetLifecycleStageResponse::builder).logger(LOG, "getLifecycleStage").serviceDetails("LifecycleEnvironment", "GetLifecycleStage", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleStage/GetLifecycleStage").method(Method.GET).requestBuilder(GetLifecycleStageRequest::builder).basePath("/20220901").appendPathParam("lifecycleStages").appendPathParam(request.getLifecycleStageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(LifecycleStage.class, GetLifecycleStageResponse.Builder::lifecycleStage).handleResponseHeaderString("etag", GetLifecycleStageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetLifecycleStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLifecycleEnvironmentsResponse listLifecycleEnvironments(ListLifecycleEnvironmentsRequest request) {
        return (ListLifecycleEnvironmentsResponse)this.clientCall(request, ListLifecycleEnvironmentsResponse::builder).logger(LOG, "listLifecycleEnvironments").serviceDetails("LifecycleEnvironment", "ListLifecycleEnvironments", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleEnvironment/ListLifecycleEnvironments").method(Method.GET).requestBuilder(ListLifecycleEnvironmentsRequest::builder).basePath("/20220901").appendPathParam("lifecycleEnvironments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("lifecycleEnvironmentId", (Object)request.getLifecycleEnvironmentId()).appendEnumQueryParam("archType", (BmcEnum)request.getArchType()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(LifecycleEnvironmentCollection.class, ListLifecycleEnvironmentsResponse.Builder::lifecycleEnvironmentCollection).handleResponseHeaderString("opc-request-id", ListLifecycleEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLifecycleEnvironmentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLifecycleStageInstalledPackagesResponse listLifecycleStageInstalledPackages(ListLifecycleStageInstalledPackagesRequest request) {
        Validate.notBlank((String)request.getLifecycleStageId(), (String)"lifecycleStageId must not be blank", (Object[])new Object[0]);
        return (ListLifecycleStageInstalledPackagesResponse)this.clientCall(request, ListLifecycleStageInstalledPackagesResponse::builder).logger(LOG, "listLifecycleStageInstalledPackages").serviceDetails("LifecycleEnvironment", "ListLifecycleStageInstalledPackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleStage/ListLifecycleStageInstalledPackages").method(Method.GET).requestBuilder(ListLifecycleStageInstalledPackagesRequest::builder).basePath("/20220901").appendPathParam("lifecycleStages").appendPathParam(request.getLifecycleStageId()).appendPathParam("installedPackages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InstalledPackageCollection.class, ListLifecycleStageInstalledPackagesResponse.Builder::installedPackageCollection).handleResponseHeaderString("opc-request-id", ListLifecycleStageInstalledPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLifecycleStageInstalledPackagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListLifecycleStagesResponse listLifecycleStages(ListLifecycleStagesRequest request) {
        return (ListLifecycleStagesResponse)this.clientCall(request, ListLifecycleStagesResponse::builder).logger(LOG, "listLifecycleStages").serviceDetails("LifecycleEnvironment", "ListLifecycleStages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleStage/ListLifecycleStages").method(Method.GET).requestBuilder(ListLifecycleStagesRequest::builder).basePath("/20220901").appendPathParam("lifecycleStages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendQueryParam("softwareSourceId", (Object)request.getSoftwareSourceId()).appendEnumQueryParam("archType", (BmcEnum)request.getArchType()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(LifecycleStageCollection.class, ListLifecycleStagesResponse.Builder::lifecycleStageCollection).handleResponseHeaderString("opc-request-id", ListLifecycleStagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListLifecycleStagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PromoteSoftwareSourceToLifecycleStageResponse promoteSoftwareSourceToLifecycleStage(PromoteSoftwareSourceToLifecycleStageRequest request) {
        Validate.notBlank((String)request.getLifecycleStageId(), (String)"lifecycleStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPromoteSoftwareSourceToLifecycleStageDetails(), "promoteSoftwareSourceToLifecycleStageDetails is required");
        return (PromoteSoftwareSourceToLifecycleStageResponse)this.clientCall(request, PromoteSoftwareSourceToLifecycleStageResponse::builder).logger(LOG, "promoteSoftwareSourceToLifecycleStage").serviceDetails("LifecycleEnvironment", "PromoteSoftwareSourceToLifecycleStage", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleStage/PromoteSoftwareSourceToLifecycleStage").method(Method.POST).requestBuilder(PromoteSoftwareSourceToLifecycleStageRequest::builder).basePath("/20220901").appendPathParam("lifecycleStages").appendPathParam(request.getLifecycleStageId()).appendPathParam("actions").appendPathParam("promoteSoftwareSource").appendQueryParam("softwareSourceId", (Object)request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", PromoteSoftwareSourceToLifecycleStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PromoteSoftwareSourceToLifecycleStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLifecycleEnvironmentResponse updateLifecycleEnvironment(UpdateLifecycleEnvironmentRequest request) {
        Validate.notBlank((String)request.getLifecycleEnvironmentId(), (String)"lifecycleEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLifecycleEnvironmentDetails(), "updateLifecycleEnvironmentDetails is required");
        return (UpdateLifecycleEnvironmentResponse)this.clientCall(request, UpdateLifecycleEnvironmentResponse::builder).logger(LOG, "updateLifecycleEnvironment").serviceDetails("LifecycleEnvironment", "UpdateLifecycleEnvironment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/LifecycleEnvironment/UpdateLifecycleEnvironment").method(Method.PUT).requestBuilder(UpdateLifecycleEnvironmentRequest::builder).basePath("/20220901").appendPathParam("lifecycleEnvironments").appendPathParam(request.getLifecycleEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.LifecycleEnvironment.class, UpdateLifecycleEnvironmentResponse.Builder::lifecycleEnvironment).handleResponseHeaderString("etag", UpdateLifecycleEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateLifecycleEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public LifecycleEnvironmentWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LifecycleEnvironmentPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LifecycleEnvironmentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LifecycleEnvironmentClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LifecycleEnvironmentClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LifecycleEnvironmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LifecycleEnvironmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LifecycleEnvironmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LifecycleEnvironmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LifecycleEnvironmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LifecycleEnvironmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LifecycleEnvironmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LifecycleEnvironmentClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LifecycleEnvironmentClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LifecycleEnvironmentClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

