/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.LifecycleEnvironment;
import com.oracle.bmc.osmanagementhub.model.InstalledPackageSummary;
import com.oracle.bmc.osmanagementhub.model.LifecycleEnvironmentSummary;
import com.oracle.bmc.osmanagementhub.model.LifecycleStageSummary;
import com.oracle.bmc.osmanagementhub.requests.ListLifecycleEnvironmentsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListLifecycleStageInstalledPackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListLifecycleStagesRequest;
import com.oracle.bmc.osmanagementhub.responses.ListLifecycleEnvironmentsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListLifecycleStageInstalledPackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListLifecycleStagesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class LifecycleEnvironmentPaginators {
    private final LifecycleEnvironment client;

    public LifecycleEnvironmentPaginators(LifecycleEnvironment client) {
        this.client = client;
    }

    public Iterable<ListLifecycleEnvironmentsResponse> listLifecycleEnvironmentsResponseIterator(final ListLifecycleEnvironmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLifecycleEnvironmentsRequest.Builder>(){

            @Override
            public ListLifecycleEnvironmentsRequest.Builder get() {
                return ListLifecycleEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLifecycleEnvironmentsResponse, String>(){

            @Override
            public String apply(ListLifecycleEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLifecycleEnvironmentsRequest.Builder>, ListLifecycleEnvironmentsRequest>(){

            @Override
            public ListLifecycleEnvironmentsRequest apply(RequestBuilderAndToken<ListLifecycleEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLifecycleEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLifecycleEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLifecycleEnvironmentsRequest, ListLifecycleEnvironmentsResponse>(){

            @Override
            public ListLifecycleEnvironmentsResponse apply(ListLifecycleEnvironmentsRequest request) {
                return LifecycleEnvironmentPaginators.this.client.listLifecycleEnvironments(request);
            }
        });
    }

    public Iterable<LifecycleEnvironmentSummary> listLifecycleEnvironmentsRecordIterator(final ListLifecycleEnvironmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLifecycleEnvironmentsRequest.Builder>(){

            @Override
            public ListLifecycleEnvironmentsRequest.Builder get() {
                return ListLifecycleEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLifecycleEnvironmentsResponse, String>(){

            @Override
            public String apply(ListLifecycleEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLifecycleEnvironmentsRequest.Builder>, ListLifecycleEnvironmentsRequest>(){

            @Override
            public ListLifecycleEnvironmentsRequest apply(RequestBuilderAndToken<ListLifecycleEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLifecycleEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLifecycleEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLifecycleEnvironmentsRequest, ListLifecycleEnvironmentsResponse>(){

            @Override
            public ListLifecycleEnvironmentsResponse apply(ListLifecycleEnvironmentsRequest request) {
                return LifecycleEnvironmentPaginators.this.client.listLifecycleEnvironments(request);
            }
        }, (Function)new Function<ListLifecycleEnvironmentsResponse, List<LifecycleEnvironmentSummary>>(){

            @Override
            public List<LifecycleEnvironmentSummary> apply(ListLifecycleEnvironmentsResponse response) {
                return response.getLifecycleEnvironmentCollection().getItems();
            }
        });
    }

    public Iterable<ListLifecycleStageInstalledPackagesResponse> listLifecycleStageInstalledPackagesResponseIterator(final ListLifecycleStageInstalledPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLifecycleStageInstalledPackagesRequest.Builder>(){

            @Override
            public ListLifecycleStageInstalledPackagesRequest.Builder get() {
                return ListLifecycleStageInstalledPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLifecycleStageInstalledPackagesResponse, String>(){

            @Override
            public String apply(ListLifecycleStageInstalledPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLifecycleStageInstalledPackagesRequest.Builder>, ListLifecycleStageInstalledPackagesRequest>(){

            @Override
            public ListLifecycleStageInstalledPackagesRequest apply(RequestBuilderAndToken<ListLifecycleStageInstalledPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLifecycleStageInstalledPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLifecycleStageInstalledPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLifecycleStageInstalledPackagesRequest, ListLifecycleStageInstalledPackagesResponse>(){

            @Override
            public ListLifecycleStageInstalledPackagesResponse apply(ListLifecycleStageInstalledPackagesRequest request) {
                return LifecycleEnvironmentPaginators.this.client.listLifecycleStageInstalledPackages(request);
            }
        });
    }

    public Iterable<InstalledPackageSummary> listLifecycleStageInstalledPackagesRecordIterator(final ListLifecycleStageInstalledPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLifecycleStageInstalledPackagesRequest.Builder>(){

            @Override
            public ListLifecycleStageInstalledPackagesRequest.Builder get() {
                return ListLifecycleStageInstalledPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLifecycleStageInstalledPackagesResponse, String>(){

            @Override
            public String apply(ListLifecycleStageInstalledPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLifecycleStageInstalledPackagesRequest.Builder>, ListLifecycleStageInstalledPackagesRequest>(){

            @Override
            public ListLifecycleStageInstalledPackagesRequest apply(RequestBuilderAndToken<ListLifecycleStageInstalledPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLifecycleStageInstalledPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLifecycleStageInstalledPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLifecycleStageInstalledPackagesRequest, ListLifecycleStageInstalledPackagesResponse>(){

            @Override
            public ListLifecycleStageInstalledPackagesResponse apply(ListLifecycleStageInstalledPackagesRequest request) {
                return LifecycleEnvironmentPaginators.this.client.listLifecycleStageInstalledPackages(request);
            }
        }, (Function)new Function<ListLifecycleStageInstalledPackagesResponse, List<InstalledPackageSummary>>(){

            @Override
            public List<InstalledPackageSummary> apply(ListLifecycleStageInstalledPackagesResponse response) {
                return response.getInstalledPackageCollection().getItems();
            }
        });
    }

    public Iterable<ListLifecycleStagesResponse> listLifecycleStagesResponseIterator(final ListLifecycleStagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLifecycleStagesRequest.Builder>(){

            @Override
            public ListLifecycleStagesRequest.Builder get() {
                return ListLifecycleStagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLifecycleStagesResponse, String>(){

            @Override
            public String apply(ListLifecycleStagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLifecycleStagesRequest.Builder>, ListLifecycleStagesRequest>(){

            @Override
            public ListLifecycleStagesRequest apply(RequestBuilderAndToken<ListLifecycleStagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLifecycleStagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLifecycleStagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLifecycleStagesRequest, ListLifecycleStagesResponse>(){

            @Override
            public ListLifecycleStagesResponse apply(ListLifecycleStagesRequest request) {
                return LifecycleEnvironmentPaginators.this.client.listLifecycleStages(request);
            }
        });
    }

    public Iterable<LifecycleStageSummary> listLifecycleStagesRecordIterator(final ListLifecycleStagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLifecycleStagesRequest.Builder>(){

            @Override
            public ListLifecycleStagesRequest.Builder get() {
                return ListLifecycleStagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLifecycleStagesResponse, String>(){

            @Override
            public String apply(ListLifecycleStagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLifecycleStagesRequest.Builder>, ListLifecycleStagesRequest>(){

            @Override
            public ListLifecycleStagesRequest apply(RequestBuilderAndToken<ListLifecycleStagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLifecycleStagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLifecycleStagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLifecycleStagesRequest, ListLifecycleStagesResponse>(){

            @Override
            public ListLifecycleStagesResponse apply(ListLifecycleStagesRequest request) {
                return LifecycleEnvironmentPaginators.this.client.listLifecycleStages(request);
            }
        }, (Function)new Function<ListLifecycleStagesResponse, List<LifecycleStageSummary>>(){

            @Override
            public List<LifecycleStageSummary> apply(ListLifecycleStagesResponse response) {
                return response.getLifecycleStageCollection().getItems();
            }
        });
    }
}

