/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.LifecycleEnvironment;
import com.oracle.bmc.osmanagementhub.model.LifecycleEnvironment;
import com.oracle.bmc.osmanagementhub.model.LifecycleStage;
import com.oracle.bmc.osmanagementhub.requests.GetLifecycleEnvironmentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetLifecycleStageRequest;
import com.oracle.bmc.osmanagementhub.responses.GetLifecycleEnvironmentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetLifecycleStageResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class LifecycleEnvironmentWaiters {
    private final ExecutorService executorService;
    private final LifecycleEnvironment client;

    public LifecycleEnvironmentWaiters(ExecutorService executorService, LifecycleEnvironment client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetLifecycleEnvironmentRequest, GetLifecycleEnvironmentResponse> forLifecycleEnvironment(GetLifecycleEnvironmentRequest request, LifecycleEnvironment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLifecycleEnvironment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLifecycleEnvironmentRequest, GetLifecycleEnvironmentResponse> forLifecycleEnvironment(GetLifecycleEnvironmentRequest request, LifecycleEnvironment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLifecycleEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLifecycleEnvironmentRequest, GetLifecycleEnvironmentResponse> forLifecycleEnvironment(GetLifecycleEnvironmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleEnvironment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLifecycleEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLifecycleEnvironmentRequest, GetLifecycleEnvironmentResponse> forLifecycleEnvironment(BmcGenericWaiter waiter, GetLifecycleEnvironmentRequest request, LifecycleEnvironment.LifecycleState ... targetStates) {
        final HashSet<LifecycleEnvironment.LifecycleState> targetStatesSet = new HashSet<LifecycleEnvironment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLifecycleEnvironmentRequest, GetLifecycleEnvironmentResponse>(){

            @Override
            public GetLifecycleEnvironmentResponse apply(GetLifecycleEnvironmentRequest request) {
                return LifecycleEnvironmentWaiters.this.client.getLifecycleEnvironment(request);
            }
        }, (Predicate)new Predicate<GetLifecycleEnvironmentResponse>(){

            @Override
            public boolean test(GetLifecycleEnvironmentResponse response) {
                return targetStatesSet.contains((Object)response.getLifecycleEnvironment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleEnvironment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetLifecycleStageRequest, GetLifecycleStageResponse> forLifecycleStage(GetLifecycleStageRequest request, LifecycleStage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLifecycleStage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLifecycleStageRequest, GetLifecycleStageResponse> forLifecycleStage(GetLifecycleStageRequest request, LifecycleStage.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLifecycleStage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLifecycleStageRequest, GetLifecycleStageResponse> forLifecycleStage(GetLifecycleStageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLifecycleStage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLifecycleStageRequest, GetLifecycleStageResponse> forLifecycleStage(BmcGenericWaiter waiter, GetLifecycleStageRequest request, LifecycleStage.LifecycleState ... targetStates) {
        final HashSet<LifecycleStage.LifecycleState> targetStatesSet = new HashSet<LifecycleStage.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLifecycleStageRequest, GetLifecycleStageResponse>(){

            @Override
            public GetLifecycleStageResponse apply(GetLifecycleStageRequest request) {
                return LifecycleEnvironmentWaiters.this.client.getLifecycleStage(request);
            }
        }, (Predicate)new Predicate<GetLifecycleStageResponse>(){

            @Override
            public boolean test(GetLifecycleStageResponse response) {
                return targetStatesSet.contains((Object)response.getLifecycleStage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStage.LifecycleState.Deleted)), (Object)request);
    }
}

