/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagementhub.ManagedInstanceAsync;
import com.oracle.bmc.osmanagementhub.model.AvailablePackageCollection;
import com.oracle.bmc.osmanagementhub.model.AvailableSoftwareSourceCollection;
import com.oracle.bmc.osmanagementhub.model.AvailableWindowsUpdateCollection;
import com.oracle.bmc.osmanagementhub.model.InstalledPackageCollection;
import com.oracle.bmc.osmanagementhub.model.InstalledWindowsUpdateCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstance;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceErratumSummaryCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceModuleCollection;
import com.oracle.bmc.osmanagementhub.model.UpdatablePackageCollection;
import com.oracle.bmc.osmanagementhub.model.WindowsUpdate;
import com.oracle.bmc.osmanagementhub.model.WindowsUpdateCollection;
import com.oracle.bmc.osmanagementhub.requests.AttachProfileToManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.AttachSoftwareSourcesToManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.DetachProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.DetachSoftwareSourcesFromManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.DisableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.EnableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallAllWindowsUpdatesOnManagedInstancesInCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallPackagesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceAvailablePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceAvailableSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceAvailableWindowsUpdatesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceInstalledPackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceInstalledWindowsUpdatesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceModulesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceUpdatablePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagementhub.requests.ManageModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.RefreshSoftwareOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.RemoveModuleStreamProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.RemovePackagesFromManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.SwitchModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateAllPackagesOnManagedInstancesInCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdatePackagesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagementhub.responses.AttachProfileToManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.AttachSoftwareSourcesToManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.DetachProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.DetachSoftwareSourcesFromManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.DisableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.EnableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallAllWindowsUpdatesOnManagedInstancesInCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallPackagesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceAvailablePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceAvailableSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceAvailableWindowsUpdatesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceInstalledPackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceInstalledWindowsUpdatesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceModulesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceUpdatablePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagementhub.responses.ManageModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.RefreshSoftwareOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.RemoveModuleStreamProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.RemovePackagesFromManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.SwitchModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateAllPackagesOnManagedInstancesInCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdatePackagesOnManagedInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedInstanceAsyncClient
extends BaseAsyncClient
implements ManagedInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MANAGEDINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ManagedInstanceAsyncClient.class);

    ManagedInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AttachProfileToManagedInstanceResponse> attachProfileToManagedInstance(AttachProfileToManagedInstanceRequest request, AsyncHandler<AttachProfileToManagedInstanceRequest, AttachProfileToManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachProfileToManagedInstanceDetails(), "attachProfileToManagedInstanceDetails is required");
        return this.clientCall(request, AttachProfileToManagedInstanceResponse::builder).logger(LOG, "attachProfileToManagedInstance").serviceDetails("ManagedInstance", "AttachProfileToManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/AttachProfileToManagedInstance").method(Method.POST).requestBuilder(AttachProfileToManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("attachProfile").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AttachProfileToManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachSoftwareSourcesToManagedInstanceResponse> attachSoftwareSourcesToManagedInstance(AttachSoftwareSourcesToManagedInstanceRequest request, AsyncHandler<AttachSoftwareSourcesToManagedInstanceRequest, AttachSoftwareSourcesToManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachSoftwareSourcesToManagedInstanceDetails(), "attachSoftwareSourcesToManagedInstanceDetails is required");
        return this.clientCall(request, AttachSoftwareSourcesToManagedInstanceResponse::builder).logger(LOG, "attachSoftwareSourcesToManagedInstance").serviceDetails("ManagedInstance", "AttachSoftwareSourcesToManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/AttachSoftwareSourcesToManagedInstance").method(Method.POST).requestBuilder(AttachSoftwareSourcesToManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("attachSoftwareSources").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", AttachSoftwareSourcesToManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AttachSoftwareSourcesToManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteManagedInstanceResponse> deleteManagedInstance(DeleteManagedInstanceRequest request, AsyncHandler<DeleteManagedInstanceRequest, DeleteManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteManagedInstanceResponse::builder).logger(LOG, "deleteManagedInstance").serviceDetails("ManagedInstance", "DeleteManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/DeleteManagedInstance").method(Method.DELETE).requestBuilder(DeleteManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachProfileFromManagedInstanceResponse> detachProfileFromManagedInstance(DetachProfileFromManagedInstanceRequest request, AsyncHandler<DetachProfileFromManagedInstanceRequest, DetachProfileFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DetachProfileFromManagedInstanceResponse::builder).logger(LOG, "detachProfileFromManagedInstance").serviceDetails("ManagedInstance", "DetachProfileFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/DetachProfileFromManagedInstance").method(Method.POST).requestBuilder(DetachProfileFromManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("detachProfile").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DetachProfileFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachSoftwareSourcesFromManagedInstanceResponse> detachSoftwareSourcesFromManagedInstance(DetachSoftwareSourcesFromManagedInstanceRequest request, AsyncHandler<DetachSoftwareSourcesFromManagedInstanceRequest, DetachSoftwareSourcesFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachSoftwareSourcesFromManagedInstanceDetails(), "detachSoftwareSourcesFromManagedInstanceDetails is required");
        return this.clientCall(request, DetachSoftwareSourcesFromManagedInstanceResponse::builder).logger(LOG, "detachSoftwareSourcesFromManagedInstance").serviceDetails("ManagedInstance", "DetachSoftwareSourcesFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/DetachSoftwareSourcesFromManagedInstance").method(Method.POST).requestBuilder(DetachSoftwareSourcesFromManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("detachSoftwareSources").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", DetachSoftwareSourcesFromManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DetachSoftwareSourcesFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableModuleStreamOnManagedInstanceResponse> disableModuleStreamOnManagedInstance(DisableModuleStreamOnManagedInstanceRequest request, AsyncHandler<DisableModuleStreamOnManagedInstanceRequest, DisableModuleStreamOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableModuleStreamOnManagedInstanceDetails(), "disableModuleStreamOnManagedInstanceDetails is required");
        return this.clientCall(request, DisableModuleStreamOnManagedInstanceResponse::builder).logger(LOG, "disableModuleStreamOnManagedInstance").serviceDetails("ManagedInstance", "DisableModuleStreamOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/DisableModuleStreamOnManagedInstance").method(Method.POST).requestBuilder(DisableModuleStreamOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("disableModuleStreams").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", DisableModuleStreamOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableModuleStreamOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableModuleStreamOnManagedInstanceResponse> enableModuleStreamOnManagedInstance(EnableModuleStreamOnManagedInstanceRequest request, AsyncHandler<EnableModuleStreamOnManagedInstanceRequest, EnableModuleStreamOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableModuleStreamOnManagedInstanceDetails(), "enableModuleStreamOnManagedInstanceDetails is required");
        return this.clientCall(request, EnableModuleStreamOnManagedInstanceResponse::builder).logger(LOG, "enableModuleStreamOnManagedInstance").serviceDetails("ManagedInstance", "EnableModuleStreamOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/EnableModuleStreamOnManagedInstance").method(Method.POST).requestBuilder(EnableModuleStreamOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("enableModuleStreams").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", EnableModuleStreamOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableModuleStreamOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagedInstanceResponse> getManagedInstance(GetManagedInstanceRequest request, AsyncHandler<GetManagedInstanceRequest, GetManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagedInstanceResponse::builder).logger(LOG, "getManagedInstance").serviceDetails("ManagedInstance", "GetManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/GetManagedInstance").method(Method.GET).requestBuilder(GetManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstance.class, GetManagedInstanceResponse.Builder::managedInstance).handleResponseHeaderString("etag", GetManagedInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetManagedInstanceResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetWindowsUpdateResponse> getWindowsUpdate(GetWindowsUpdateRequest request, AsyncHandler<GetWindowsUpdateRequest, GetWindowsUpdateResponse> handler) {
        Validate.notBlank((String)request.getWindowsUpdateId(), (String)"windowsUpdateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWindowsUpdateResponse::builder).logger(LOG, "getWindowsUpdate").serviceDetails("ManagedInstance", "GetWindowsUpdate", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/WindowsUpdate/GetWindowsUpdate").method(Method.GET).requestBuilder(GetWindowsUpdateRequest::builder).basePath("/20220901").appendPathParam("windowsUpdates").appendPathParam(request.getWindowsUpdateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WindowsUpdate.class, GetWindowsUpdateResponse.Builder::windowsUpdate).handleResponseHeaderString("opc-request-id", GetWindowsUpdateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallAllWindowsUpdatesOnManagedInstancesInCompartmentResponse> installAllWindowsUpdatesOnManagedInstancesInCompartment(InstallAllWindowsUpdatesOnManagedInstancesInCompartmentRequest request, AsyncHandler<InstallAllWindowsUpdatesOnManagedInstancesInCompartmentRequest, InstallAllWindowsUpdatesOnManagedInstancesInCompartmentResponse> handler) {
        Objects.requireNonNull(request.getInstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails(), "installAllWindowsUpdatesOnManagedInstancesInCompartmentDetails is required");
        return this.clientCall(request, InstallAllWindowsUpdatesOnManagedInstancesInCompartmentResponse::builder).logger(LOG, "installAllWindowsUpdatesOnManagedInstancesInCompartment").serviceDetails("ManagedInstance", "InstallAllWindowsUpdatesOnManagedInstancesInCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/InstallAllWindowsUpdatesOnManagedInstancesInCompartment").method(Method.POST).requestBuilder(InstallAllWindowsUpdatesOnManagedInstancesInCompartmentRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam("actions").appendPathParam("installWindowsUpdates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", InstallAllWindowsUpdatesOnManagedInstancesInCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallAllWindowsUpdatesOnManagedInstancesInCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallModuleStreamProfileOnManagedInstanceResponse> installModuleStreamProfileOnManagedInstance(InstallModuleStreamProfileOnManagedInstanceRequest request, AsyncHandler<InstallModuleStreamProfileOnManagedInstanceRequest, InstallModuleStreamProfileOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallModuleStreamProfileOnManagedInstanceDetails(), "installModuleStreamProfileOnManagedInstanceDetails is required");
        return this.clientCall(request, InstallModuleStreamProfileOnManagedInstanceResponse::builder).logger(LOG, "installModuleStreamProfileOnManagedInstance").serviceDetails("ManagedInstance", "InstallModuleStreamProfileOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/InstallModuleStreamProfileOnManagedInstance").method(Method.POST).requestBuilder(InstallModuleStreamProfileOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("installStreamProfiles").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", InstallModuleStreamProfileOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallModuleStreamProfileOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallPackagesOnManagedInstanceResponse> installPackagesOnManagedInstance(InstallPackagesOnManagedInstanceRequest request, AsyncHandler<InstallPackagesOnManagedInstanceRequest, InstallPackagesOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallPackagesOnManagedInstanceDetails(), "installPackagesOnManagedInstanceDetails is required");
        return this.clientCall(request, InstallPackagesOnManagedInstanceResponse::builder).logger(LOG, "installPackagesOnManagedInstance").serviceDetails("ManagedInstance", "InstallPackagesOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/InstallPackagesOnManagedInstance").method(Method.POST).requestBuilder(InstallPackagesOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("installPackages").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", InstallPackagesOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallPackagesOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallWindowsUpdatesOnManagedInstanceResponse> installWindowsUpdatesOnManagedInstance(InstallWindowsUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallWindowsUpdatesOnManagedInstanceRequest, InstallWindowsUpdatesOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallWindowsUpdatesOnManagedInstanceDetails(), "installWindowsUpdatesOnManagedInstanceDetails is required");
        return this.clientCall(request, InstallWindowsUpdatesOnManagedInstanceResponse::builder).logger(LOG, "installWindowsUpdatesOnManagedInstance").serviceDetails("ManagedInstance", "InstallWindowsUpdatesOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/InstallWindowsUpdatesOnManagedInstance").method(Method.POST).requestBuilder(InstallWindowsUpdatesOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("installWindowsUpdates").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", InstallWindowsUpdatesOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallWindowsUpdatesOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceAvailablePackagesResponse> listManagedInstanceAvailablePackages(ListManagedInstanceAvailablePackagesRequest request, AsyncHandler<ListManagedInstanceAvailablePackagesRequest, ListManagedInstanceAvailablePackagesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceAvailablePackagesResponse::builder).logger(LOG, "listManagedInstanceAvailablePackages").serviceDetails("ManagedInstance", "ListManagedInstanceAvailablePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceAvailablePackages").method(Method.GET).requestBuilder(ListManagedInstanceAvailablePackagesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("availablePackages").appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AvailablePackageCollection.class, ListManagedInstanceAvailablePackagesResponse.Builder::availablePackageCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceAvailablePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceAvailablePackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceAvailableSoftwareSourcesResponse> listManagedInstanceAvailableSoftwareSources(ListManagedInstanceAvailableSoftwareSourcesRequest request, AsyncHandler<ListManagedInstanceAvailableSoftwareSourcesRequest, ListManagedInstanceAvailableSoftwareSourcesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceAvailableSoftwareSourcesResponse::builder).logger(LOG, "listManagedInstanceAvailableSoftwareSources").serviceDetails("ManagedInstance", "ListManagedInstanceAvailableSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceAvailableSoftwareSources").method(Method.GET).requestBuilder(ListManagedInstanceAvailableSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("availableSoftwareSources").appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AvailableSoftwareSourceCollection.class, ListManagedInstanceAvailableSoftwareSourcesResponse.Builder::availableSoftwareSourceCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceAvailableSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceAvailableSoftwareSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceAvailableWindowsUpdatesResponse> listManagedInstanceAvailableWindowsUpdates(ListManagedInstanceAvailableWindowsUpdatesRequest request, AsyncHandler<ListManagedInstanceAvailableWindowsUpdatesRequest, ListManagedInstanceAvailableWindowsUpdatesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceAvailableWindowsUpdatesResponse::builder).logger(LOG, "listManagedInstanceAvailableWindowsUpdates").serviceDetails("ManagedInstance", "ListManagedInstanceAvailableWindowsUpdates", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceAvailableWindowsUpdates").method(Method.GET).requestBuilder(ListManagedInstanceAvailableWindowsUpdatesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("availableWindowsUpdates").appendListQueryParam("classificationType", request.getClassificationType(), CollectionFormatType.Multi).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("isInstallable", (BmcEnum)request.getIsInstallable()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AvailableWindowsUpdateCollection.class, ListManagedInstanceAvailableWindowsUpdatesResponse.Builder::availableWindowsUpdateCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceAvailableWindowsUpdatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceAvailableWindowsUpdatesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceErrataResponse> listManagedInstanceErrata(ListManagedInstanceErrataRequest request, AsyncHandler<ListManagedInstanceErrataRequest, ListManagedInstanceErrataResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceErrataResponse::builder).logger(LOG, "listManagedInstanceErrata").serviceDetails("ManagedInstance", "ListManagedInstanceErrata", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceErrata").method(Method.GET).requestBuilder(ListManagedInstanceErrataRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("errata").appendListQueryParam("classificationType", request.getClassificationType(), CollectionFormatType.Multi).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("nameContains", (Object)request.getNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstanceErratumSummaryCollection.class, ListManagedInstanceErrataResponse.Builder::managedInstanceErratumSummaryCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceErrataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceErrataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceInstalledPackagesResponse> listManagedInstanceInstalledPackages(ListManagedInstanceInstalledPackagesRequest request, AsyncHandler<ListManagedInstanceInstalledPackagesRequest, ListManagedInstanceInstalledPackagesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceInstalledPackagesResponse::builder).logger(LOG, "listManagedInstanceInstalledPackages").serviceDetails("ManagedInstance", "ListManagedInstanceInstalledPackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceInstalledPackages").method(Method.GET).requestBuilder(ListManagedInstanceInstalledPackagesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("installedPackages").appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("timeInstallDateStart", (Object)request.getTimeInstallDateStart()).appendQueryParam("timeInstallDateEnd", (Object)request.getTimeInstallDateEnd()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstalledPackageCollection.class, ListManagedInstanceInstalledPackagesResponse.Builder::installedPackageCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceInstalledPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceInstalledPackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceInstalledWindowsUpdatesResponse> listManagedInstanceInstalledWindowsUpdates(ListManagedInstanceInstalledWindowsUpdatesRequest request, AsyncHandler<ListManagedInstanceInstalledWindowsUpdatesRequest, ListManagedInstanceInstalledWindowsUpdatesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceInstalledWindowsUpdatesResponse::builder).logger(LOG, "listManagedInstanceInstalledWindowsUpdates").serviceDetails("ManagedInstance", "ListManagedInstanceInstalledWindowsUpdates", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceInstalledWindowsUpdates").method(Method.GET).requestBuilder(ListManagedInstanceInstalledWindowsUpdatesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("installedWindowsUpdates").appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstalledWindowsUpdateCollection.class, ListManagedInstanceInstalledWindowsUpdatesResponse.Builder::installedWindowsUpdateCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceInstalledWindowsUpdatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceInstalledWindowsUpdatesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceModulesResponse> listManagedInstanceModules(ListManagedInstanceModulesRequest request, AsyncHandler<ListManagedInstanceModulesRequest, ListManagedInstanceModulesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceModulesResponse::builder).logger(LOG, "listManagedInstanceModules").serviceDetails("ManagedInstance", "ListManagedInstanceModules", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceModules").method(Method.GET).requestBuilder(ListManagedInstanceModulesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("modules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstanceModuleCollection.class, ListManagedInstanceModulesResponse.Builder::managedInstanceModuleCollection).handleResponseHeaderString("opc-work-request-id", ListManagedInstanceModulesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ListManagedInstanceModulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceModulesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstanceUpdatablePackagesResponse> listManagedInstanceUpdatablePackages(ListManagedInstanceUpdatablePackagesRequest request, AsyncHandler<ListManagedInstanceUpdatablePackagesRequest, ListManagedInstanceUpdatablePackagesResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedInstanceUpdatablePackagesResponse::builder).logger(LOG, "listManagedInstanceUpdatablePackages").serviceDetails("ManagedInstance", "ListManagedInstanceUpdatablePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstanceUpdatablePackages").method(Method.GET).requestBuilder(ListManagedInstanceUpdatablePackagesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("updatablePackages").appendListQueryParam("classificationType", request.getClassificationType(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendListQueryParam("advisoryName", request.getAdvisoryName(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UpdatablePackageCollection.class, ListManagedInstanceUpdatablePackagesResponse.Builder::updatablePackageCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceUpdatablePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceUpdatablePackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedInstancesResponse> listManagedInstances(ListManagedInstancesRequest request, AsyncHandler<ListManagedInstancesRequest, ListManagedInstancesResponse> handler) {
        return this.clientCall(request, ListManagedInstancesResponse::builder).logger(LOG, "listManagedInstances").serviceDetails("ManagedInstance", "ListManagedInstances", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ListManagedInstances").method(Method.GET).requestBuilder(ListManagedInstancesRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendListQueryParam("archType", request.getArchType(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("isManagementStation", (Object)request.getIsManagementStation()).appendQueryParam("group", (Object)request.getGroup()).appendQueryParam("groupNotEqualTo", (Object)request.getGroupNotEqualTo()).appendQueryParam("lifecycleStage", (Object)request.getLifecycleStage()).appendQueryParam("lifecycleStageNotEqualTo", (Object)request.getLifecycleStageNotEqualTo()).appendQueryParam("isAttachedToGroupOrLifecycleStage", (Object)request.getIsAttachedToGroupOrLifecycleStage()).appendQueryParam("softwareSourceId", (Object)request.getSoftwareSourceId()).appendListQueryParam("advisoryName", request.getAdvisoryName(), CollectionFormatType.Multi).appendQueryParam("lifecycleEnvironment", (Object)request.getLifecycleEnvironment()).appendQueryParam("lifecycleEnvironmentNotEqualTo", (Object)request.getLifecycleEnvironmentNotEqualTo()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendListQueryParam("profile", request.getProfile(), CollectionFormatType.Multi).appendListQueryParam("profileNotEqualTo", request.getProfileNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("isProfileAttached", (Object)request.getIsProfileAttached()).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstanceCollection.class, ListManagedInstancesResponse.Builder::managedInstanceCollection).handleResponseHeaderString("opc-request-id", ListManagedInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWindowsUpdatesResponse> listWindowsUpdates(ListWindowsUpdatesRequest request, AsyncHandler<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWindowsUpdatesResponse::builder).logger(LOG, "listWindowsUpdates").serviceDetails("ManagedInstance", "ListWindowsUpdates", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/WindowsUpdateCollection/ListWindowsUpdates").method(Method.GET).requestBuilder(ListWindowsUpdatesRequest::builder).basePath("/20220901").appendPathParam("windowsUpdates").appendListQueryParam("classificationType", request.getClassificationType(), CollectionFormatType.Multi).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WindowsUpdateCollection.class, ListWindowsUpdatesResponse.Builder::windowsUpdateCollection).handleResponseHeaderString("opc-request-id", ListWindowsUpdatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWindowsUpdatesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ManageModuleStreamsOnManagedInstanceResponse> manageModuleStreamsOnManagedInstance(ManageModuleStreamsOnManagedInstanceRequest request, AsyncHandler<ManageModuleStreamsOnManagedInstanceRequest, ManageModuleStreamsOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManageModuleStreamsOnManagedInstanceDetails(), "manageModuleStreamsOnManagedInstanceDetails is required");
        return this.clientCall(request, ManageModuleStreamsOnManagedInstanceResponse::builder).logger(LOG, "manageModuleStreamsOnManagedInstance").serviceDetails("ManagedInstance", "ManageModuleStreamsOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/ManageModuleStreamsOnManagedInstance").method(Method.POST).requestBuilder(ManageModuleStreamsOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("manageModuleStreams").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ManageModuleStreamsOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ManageModuleStreamsOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RefreshSoftwareOnManagedInstanceResponse> refreshSoftwareOnManagedInstance(RefreshSoftwareOnManagedInstanceRequest request, AsyncHandler<RefreshSoftwareOnManagedInstanceRequest, RefreshSoftwareOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RefreshSoftwareOnManagedInstanceResponse::builder).logger(LOG, "refreshSoftwareOnManagedInstance").serviceDetails("ManagedInstance", "RefreshSoftwareOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/RefreshSoftwareOnManagedInstance").method(Method.POST).requestBuilder(RefreshSoftwareOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("refreshSoftware").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", RefreshSoftwareOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshSoftwareOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveModuleStreamProfileFromManagedInstanceResponse> removeModuleStreamProfileFromManagedInstance(RemoveModuleStreamProfileFromManagedInstanceRequest request, AsyncHandler<RemoveModuleStreamProfileFromManagedInstanceRequest, RemoveModuleStreamProfileFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveModuleStreamProfileFromManagedInstanceDetails(), "removeModuleStreamProfileFromManagedInstanceDetails is required");
        return this.clientCall(request, RemoveModuleStreamProfileFromManagedInstanceResponse::builder).logger(LOG, "removeModuleStreamProfileFromManagedInstance").serviceDetails("ManagedInstance", "RemoveModuleStreamProfileFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/RemoveModuleStreamProfileFromManagedInstance").method(Method.POST).requestBuilder(RemoveModuleStreamProfileFromManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("removeStreamProfiles").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RemoveModuleStreamProfileFromManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveModuleStreamProfileFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemovePackagesFromManagedInstanceResponse> removePackagesFromManagedInstance(RemovePackagesFromManagedInstanceRequest request, AsyncHandler<RemovePackagesFromManagedInstanceRequest, RemovePackagesFromManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemovePackagesFromManagedInstanceDetails(), "removePackagesFromManagedInstanceDetails is required");
        return this.clientCall(request, RemovePackagesFromManagedInstanceResponse::builder).logger(LOG, "removePackagesFromManagedInstance").serviceDetails("ManagedInstance", "RemovePackagesFromManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/RemovePackagesFromManagedInstance").method(Method.POST).requestBuilder(RemovePackagesFromManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("removePackages").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", RemovePackagesFromManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemovePackagesFromManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SwitchModuleStreamOnManagedInstanceResponse> switchModuleStreamOnManagedInstance(SwitchModuleStreamOnManagedInstanceRequest request, AsyncHandler<SwitchModuleStreamOnManagedInstanceRequest, SwitchModuleStreamOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSwitchModuleStreamOnManagedInstanceDetails(), "switchModuleStreamOnManagedInstanceDetails is required");
        return this.clientCall(request, SwitchModuleStreamOnManagedInstanceResponse::builder).logger(LOG, "switchModuleStreamOnManagedInstance").serviceDetails("ManagedInstance", "SwitchModuleStreamOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/SwitchModuleStreamOnManagedInstance").method(Method.POST).requestBuilder(SwitchModuleStreamOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("switchModuleStreams").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", SwitchModuleStreamOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SwitchModuleStreamOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAllPackagesOnManagedInstancesInCompartmentResponse> updateAllPackagesOnManagedInstancesInCompartment(UpdateAllPackagesOnManagedInstancesInCompartmentRequest request, AsyncHandler<UpdateAllPackagesOnManagedInstancesInCompartmentRequest, UpdateAllPackagesOnManagedInstancesInCompartmentResponse> handler) {
        Objects.requireNonNull(request.getUpdateAllPackagesOnManagedInstancesInCompartmentDetails(), "updateAllPackagesOnManagedInstancesInCompartmentDetails is required");
        return this.clientCall(request, UpdateAllPackagesOnManagedInstancesInCompartmentResponse::builder).logger(LOG, "updateAllPackagesOnManagedInstancesInCompartment").serviceDetails("ManagedInstance", "UpdateAllPackagesOnManagedInstancesInCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/UpdateAllPackagesOnManagedInstancesInCompartment").method(Method.POST).requestBuilder(UpdateAllPackagesOnManagedInstancesInCompartmentRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam("actions").appendPathParam("updatePackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAllPackagesOnManagedInstancesInCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAllPackagesOnManagedInstancesInCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateManagedInstanceResponse> updateManagedInstance(UpdateManagedInstanceRequest request, AsyncHandler<UpdateManagedInstanceRequest, UpdateManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedInstanceDetails(), "updateManagedInstanceDetails is required");
        return this.clientCall(request, UpdateManagedInstanceResponse::builder).logger(LOG, "updateManagedInstance").serviceDetails("ManagedInstance", "UpdateManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/UpdateManagedInstance").method(Method.PUT).requestBuilder(UpdateManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagedInstance.class, UpdateManagedInstanceResponse.Builder::managedInstance).handleResponseHeaderString("etag", UpdateManagedInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePackagesOnManagedInstanceResponse> updatePackagesOnManagedInstance(UpdatePackagesOnManagedInstanceRequest request, AsyncHandler<UpdatePackagesOnManagedInstanceRequest, UpdatePackagesOnManagedInstanceResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePackagesOnManagedInstanceDetails(), "updatePackagesOnManagedInstanceDetails is required");
        return this.clientCall(request, UpdatePackagesOnManagedInstanceResponse::builder).logger(LOG, "updatePackagesOnManagedInstance").serviceDetails("ManagedInstance", "UpdatePackagesOnManagedInstance", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/UpdatePackagesOnManagedInstance").method(Method.POST).requestBuilder(UpdatePackagesOnManagedInstanceRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("actions").appendPathParam("updatePackages").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdatePackagesOnManagedInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdatePackagesOnManagedInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ManagedInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ManagedInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ManagedInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ManagedInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ManagedInstanceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

