/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.ManagedInstanceGroupPaginators;
import com.oracle.bmc.osmanagementhub.ManagedInstanceGroupWaiters;
import com.oracle.bmc.osmanagementhub.model.AvailableSoftwareSourceCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroup;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroupAvailableModuleCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroupAvailablePackageCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroupCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroupInstalledPackageCollection;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroupModuleCollection;
import com.oracle.bmc.osmanagementhub.requests.AttachManagedInstancesToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.AttachSoftwareSourcesToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.DetachManagedInstancesFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.DetachSoftwareSourcesFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.DisableModuleStreamOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.EnableModuleStreamOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallModuleStreamProfileOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallPackagesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.InstallWindowsUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceGroupAvailableModulesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceGroupAvailablePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceGroupAvailableSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceGroupInstalledPackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceGroupModulesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.ManageModuleStreamsOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.RemoveModuleStreamProfileFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.RemovePackagesFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.SwitchModuleStreamOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateAllPackagesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.responses.AttachManagedInstancesToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.AttachSoftwareSourcesToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.DetachManagedInstancesFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.DetachSoftwareSourcesFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.DisableModuleStreamOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.EnableModuleStreamOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallModuleStreamProfileOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallPackagesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.InstallWindowsUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceGroupAvailableModulesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceGroupAvailablePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceGroupAvailableSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceGroupInstalledPackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceGroupModulesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.ManageModuleStreamsOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.RemoveModuleStreamProfileFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.RemovePackagesFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.SwitchModuleStreamOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateAllPackagesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedInstanceGroupClient
extends BaseSyncClient
implements com.oracle.bmc.osmanagementhub.ManagedInstanceGroup {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MANAGEDINSTANCEGROUP").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ManagedInstanceGroupClient.class);
    private final ManagedInstanceGroupWaiters waiters;
    private final ManagedInstanceGroupPaginators paginators;

    ManagedInstanceGroupClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ManagedInstanceGroup-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ManagedInstanceGroupWaiters(executorService, this);
        this.paginators = new ManagedInstanceGroupPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AttachManagedInstancesToManagedInstanceGroupResponse attachManagedInstancesToManagedInstanceGroup(AttachManagedInstancesToManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachManagedInstancesToManagedInstanceGroupDetails(), "attachManagedInstancesToManagedInstanceGroupDetails is required");
        return (AttachManagedInstancesToManagedInstanceGroupResponse)this.clientCall(request, AttachManagedInstancesToManagedInstanceGroupResponse::builder).logger(LOG, "attachManagedInstancesToManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "AttachManagedInstancesToManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/AttachManagedInstancesToManagedInstanceGroup").method(Method.POST).requestBuilder(AttachManagedInstancesToManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("attachManagedInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", AttachManagedInstancesToManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AttachManagedInstancesToManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AttachSoftwareSourcesToManagedInstanceGroupResponse attachSoftwareSourcesToManagedInstanceGroup(AttachSoftwareSourcesToManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachSoftwareSourcesToManagedInstanceGroupDetails(), "attachSoftwareSourcesToManagedInstanceGroupDetails is required");
        return (AttachSoftwareSourcesToManagedInstanceGroupResponse)this.clientCall(request, AttachSoftwareSourcesToManagedInstanceGroupResponse::builder).logger(LOG, "attachSoftwareSourcesToManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "AttachSoftwareSourcesToManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/AttachSoftwareSourcesToManagedInstanceGroup").method(Method.POST).requestBuilder(AttachSoftwareSourcesToManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("attachSoftwareSources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", AttachSoftwareSourcesToManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AttachSoftwareSourcesToManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeManagedInstanceGroupCompartmentResponse changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagedInstanceGroupCompartmentDetails(), "changeManagedInstanceGroupCompartmentDetails is required");
        return (ChangeManagedInstanceGroupCompartmentResponse)this.clientCall(request, ChangeManagedInstanceGroupCompartmentResponse::builder).logger(LOG, "changeManagedInstanceGroupCompartment").serviceDetails("ManagedInstanceGroup", "ChangeManagedInstanceGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ChangeManagedInstanceGroupCompartment").method(Method.POST).requestBuilder(ChangeManagedInstanceGroupCompartmentRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeManagedInstanceGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateManagedInstanceGroupResponse createManagedInstanceGroup(CreateManagedInstanceGroupRequest request) {
        Objects.requireNonNull(request.getCreateManagedInstanceGroupDetails(), "createManagedInstanceGroupDetails is required");
        return (CreateManagedInstanceGroupResponse)this.clientCall(request, CreateManagedInstanceGroupResponse::builder).logger(LOG, "createManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "CreateManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/CreateManagedInstanceGroup").method(Method.POST).requestBuilder(CreateManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ManagedInstanceGroup.class, CreateManagedInstanceGroupResponse.Builder::managedInstanceGroup).handleResponseHeaderString("etag", CreateManagedInstanceGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteManagedInstanceGroupResponse deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteManagedInstanceGroupResponse)this.clientCall(request, DeleteManagedInstanceGroupResponse::builder).logger(LOG, "deleteManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "DeleteManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/DeleteManagedInstanceGroup").method(Method.DELETE).requestBuilder(DeleteManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachManagedInstancesFromManagedInstanceGroupResponse detachManagedInstancesFromManagedInstanceGroup(DetachManagedInstancesFromManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachManagedInstancesFromManagedInstanceGroupDetails(), "detachManagedInstancesFromManagedInstanceGroupDetails is required");
        return (DetachManagedInstancesFromManagedInstanceGroupResponse)this.clientCall(request, DetachManagedInstancesFromManagedInstanceGroupResponse::builder).logger(LOG, "detachManagedInstancesFromManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "DetachManagedInstancesFromManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/DetachManagedInstancesFromManagedInstanceGroup").method(Method.POST).requestBuilder(DetachManagedInstancesFromManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("detachManagedInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", DetachManagedInstancesFromManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachSoftwareSourcesFromManagedInstanceGroupResponse detachSoftwareSourcesFromManagedInstanceGroup(DetachSoftwareSourcesFromManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachSoftwareSourcesFromManagedInstanceGroupDetails(), "detachSoftwareSourcesFromManagedInstanceGroupDetails is required");
        return (DetachSoftwareSourcesFromManagedInstanceGroupResponse)this.clientCall(request, DetachSoftwareSourcesFromManagedInstanceGroupResponse::builder).logger(LOG, "detachSoftwareSourcesFromManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "DetachSoftwareSourcesFromManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/DetachSoftwareSourcesFromManagedInstanceGroup").method(Method.POST).requestBuilder(DetachSoftwareSourcesFromManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("detachSoftwareSources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", DetachSoftwareSourcesFromManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisableModuleStreamOnManagedInstanceGroupResponse disableModuleStreamOnManagedInstanceGroup(DisableModuleStreamOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableModuleStreamOnManagedInstanceGroupDetails(), "disableModuleStreamOnManagedInstanceGroupDetails is required");
        return (DisableModuleStreamOnManagedInstanceGroupResponse)this.clientCall(request, DisableModuleStreamOnManagedInstanceGroupResponse::builder).logger(LOG, "disableModuleStreamOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "DisableModuleStreamOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/DisableModuleStreamOnManagedInstanceGroup").method(Method.POST).requestBuilder(DisableModuleStreamOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("disableModuleStream").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", DisableModuleStreamOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableModuleStreamOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EnableModuleStreamOnManagedInstanceGroupResponse enableModuleStreamOnManagedInstanceGroup(EnableModuleStreamOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableModuleStreamOnManagedInstanceGroupDetails(), "enableModuleStreamOnManagedInstanceGroupDetails is required");
        return (EnableModuleStreamOnManagedInstanceGroupResponse)this.clientCall(request, EnableModuleStreamOnManagedInstanceGroupResponse::builder).logger(LOG, "enableModuleStreamOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "EnableModuleStreamOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/EnableModuleStreamOnManagedInstanceGroup").method(Method.POST).requestBuilder(EnableModuleStreamOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("enableModuleStream").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", EnableModuleStreamOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableModuleStreamOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagedInstanceGroupResponse getManagedInstanceGroup(GetManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (GetManagedInstanceGroupResponse)this.clientCall(request, GetManagedInstanceGroupResponse::builder).logger(LOG, "getManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "GetManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/GetManagedInstanceGroup").method(Method.GET).requestBuilder(GetManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceGroup.class, GetManagedInstanceGroupResponse.Builder::managedInstanceGroup).handleResponseHeaderString("etag", GetManagedInstanceGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public InstallModuleStreamProfileOnManagedInstanceGroupResponse installModuleStreamProfileOnManagedInstanceGroup(InstallModuleStreamProfileOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallModuleStreamProfileOnManagedInstanceGroupDetails(), "installModuleStreamProfileOnManagedInstanceGroupDetails is required");
        return (InstallModuleStreamProfileOnManagedInstanceGroupResponse)this.clientCall(request, InstallModuleStreamProfileOnManagedInstanceGroupResponse::builder).logger(LOG, "installModuleStreamProfileOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "InstallModuleStreamProfileOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/InstallModuleStreamProfileOnManagedInstanceGroup").method(Method.POST).requestBuilder(InstallModuleStreamProfileOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("installStreamProfile").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", InstallModuleStreamProfileOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallModuleStreamProfileOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public InstallPackagesOnManagedInstanceGroupResponse installPackagesOnManagedInstanceGroup(InstallPackagesOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallPackagesOnManagedInstanceGroupDetails(), "installPackagesOnManagedInstanceGroupDetails is required");
        return (InstallPackagesOnManagedInstanceGroupResponse)this.clientCall(request, InstallPackagesOnManagedInstanceGroupResponse::builder).logger(LOG, "installPackagesOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "InstallPackagesOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/InstallPackagesOnManagedInstanceGroup").method(Method.POST).requestBuilder(InstallPackagesOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("installPackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", InstallPackagesOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallPackagesOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public InstallWindowsUpdatesOnManagedInstanceGroupResponse installWindowsUpdatesOnManagedInstanceGroup(InstallWindowsUpdatesOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallWindowsUpdatesOnManagedInstanceGroupDetails(), "installWindowsUpdatesOnManagedInstanceGroupDetails is required");
        return (InstallWindowsUpdatesOnManagedInstanceGroupResponse)this.clientCall(request, InstallWindowsUpdatesOnManagedInstanceGroupResponse::builder).logger(LOG, "installWindowsUpdatesOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "InstallWindowsUpdatesOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/InstallWindowsUpdatesOnManagedInstanceGroup").method(Method.POST).requestBuilder(InstallWindowsUpdatesOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("installWindowsUpdates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", InstallWindowsUpdatesOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallWindowsUpdatesOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListManagedInstanceGroupAvailableModulesResponse listManagedInstanceGroupAvailableModules(ListManagedInstanceGroupAvailableModulesRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (ListManagedInstanceGroupAvailableModulesResponse)this.clientCall(request, ListManagedInstanceGroupAvailableModulesResponse::builder).logger(LOG, "listManagedInstanceGroupAvailableModules").serviceDetails("ManagedInstanceGroup", "ListManagedInstanceGroupAvailableModules", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ListManagedInstanceGroupAvailableModules").method(Method.GET).requestBuilder(ListManagedInstanceGroupAvailableModulesRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("availableModules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceGroupAvailableModuleCollection.class, ListManagedInstanceGroupAvailableModulesResponse.Builder::managedInstanceGroupAvailableModuleCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupAvailableModulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupAvailableModulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedInstanceGroupAvailablePackagesResponse listManagedInstanceGroupAvailablePackages(ListManagedInstanceGroupAvailablePackagesRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (ListManagedInstanceGroupAvailablePackagesResponse)this.clientCall(request, ListManagedInstanceGroupAvailablePackagesResponse::builder).logger(LOG, "listManagedInstanceGroupAvailablePackages").serviceDetails("ManagedInstanceGroup", "ListManagedInstanceGroupAvailablePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ListManagedInstanceGroupAvailablePackages").method(Method.GET).requestBuilder(ListManagedInstanceGroupAvailablePackagesRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("availablePackages").appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("isLatest", (Object)request.getIsLatest()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceGroupAvailablePackageCollection.class, ListManagedInstanceGroupAvailablePackagesResponse.Builder::managedInstanceGroupAvailablePackageCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupAvailablePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupAvailablePackagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedInstanceGroupAvailableSoftwareSourcesResponse listManagedInstanceGroupAvailableSoftwareSources(ListManagedInstanceGroupAvailableSoftwareSourcesRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (ListManagedInstanceGroupAvailableSoftwareSourcesResponse)this.clientCall(request, ListManagedInstanceGroupAvailableSoftwareSourcesResponse::builder).logger(LOG, "listManagedInstanceGroupAvailableSoftwareSources").serviceDetails("ManagedInstanceGroup", "ListManagedInstanceGroupAvailableSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ListManagedInstanceGroupAvailableSoftwareSources").method(Method.GET).requestBuilder(ListManagedInstanceGroupAvailableSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("availableSoftwareSources").appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AvailableSoftwareSourceCollection.class, ListManagedInstanceGroupAvailableSoftwareSourcesResponse.Builder::availableSoftwareSourceCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupAvailableSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupAvailableSoftwareSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedInstanceGroupInstalledPackagesResponse listManagedInstanceGroupInstalledPackages(ListManagedInstanceGroupInstalledPackagesRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (ListManagedInstanceGroupInstalledPackagesResponse)this.clientCall(request, ListManagedInstanceGroupInstalledPackagesResponse::builder).logger(LOG, "listManagedInstanceGroupInstalledPackages").serviceDetails("ManagedInstanceGroup", "ListManagedInstanceGroupInstalledPackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ListManagedInstanceGroupInstalledPackages").method(Method.GET).requestBuilder(ListManagedInstanceGroupInstalledPackagesRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("installedPackages").appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("timeInstallDateStart", (Object)request.getTimeInstallDateStart()).appendQueryParam("timeInstallDateEnd", (Object)request.getTimeInstallDateEnd()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceGroupInstalledPackageCollection.class, ListManagedInstanceGroupInstalledPackagesResponse.Builder::managedInstanceGroupInstalledPackageCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupInstalledPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupInstalledPackagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedInstanceGroupModulesResponse listManagedInstanceGroupModules(ListManagedInstanceGroupModulesRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        return (ListManagedInstanceGroupModulesResponse)this.clientCall(request, ListManagedInstanceGroupModulesResponse::builder).logger(LOG, "listManagedInstanceGroupModules").serviceDetails("ManagedInstanceGroup", "ListManagedInstanceGroupModules", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ListManagedInstanceGroupModules").method(Method.GET).requestBuilder(ListManagedInstanceGroupModulesRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("modules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceGroupModuleCollection.class, ListManagedInstanceGroupModulesResponse.Builder::managedInstanceGroupModuleCollection).handleResponseHeaderString("opc-work-request-id", ListManagedInstanceGroupModulesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupModulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupModulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedInstanceGroupsResponse listManagedInstanceGroups(ListManagedInstanceGroupsRequest request) {
        return (ListManagedInstanceGroupsResponse)this.clientCall(request, ListManagedInstanceGroupsResponse::builder).logger(LOG, "listManagedInstanceGroups").serviceDetails("ManagedInstanceGroup", "ListManagedInstanceGroups", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ListManagedInstanceGroups").method(Method.GET).requestBuilder(ListManagedInstanceGroupsRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("softwareSourceId", (Object)request.getSoftwareSourceId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("archType", (BmcEnum)request.getArchType()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceGroupCollection.class, ListManagedInstanceGroupsResponse.Builder::managedInstanceGroupCollection).handleResponseHeaderString("opc-request-id", ListManagedInstanceGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedInstanceGroupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ManageModuleStreamsOnManagedInstanceGroupResponse manageModuleStreamsOnManagedInstanceGroup(ManageModuleStreamsOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManageModuleStreamsOnManagedInstanceGroupDetails(), "manageModuleStreamsOnManagedInstanceGroupDetails is required");
        return (ManageModuleStreamsOnManagedInstanceGroupResponse)this.clientCall(request, ManageModuleStreamsOnManagedInstanceGroupResponse::builder).logger(LOG, "manageModuleStreamsOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "ManageModuleStreamsOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/ManageModuleStreamsOnManagedInstanceGroup").method(Method.POST).requestBuilder(ManageModuleStreamsOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("manageModuleStreams").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ManageModuleStreamsOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ManageModuleStreamsOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveModuleStreamProfileFromManagedInstanceGroupResponse removeModuleStreamProfileFromManagedInstanceGroup(RemoveModuleStreamProfileFromManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveModuleStreamProfileFromManagedInstanceGroupDetails(), "removeModuleStreamProfileFromManagedInstanceGroupDetails is required");
        return (RemoveModuleStreamProfileFromManagedInstanceGroupResponse)this.clientCall(request, RemoveModuleStreamProfileFromManagedInstanceGroupResponse::builder).logger(LOG, "removeModuleStreamProfileFromManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "RemoveModuleStreamProfileFromManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/RemoveModuleStreamProfileFromManagedInstanceGroup").method(Method.POST).requestBuilder(RemoveModuleStreamProfileFromManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("removeStreamProfile").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RemoveModuleStreamProfileFromManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveModuleStreamProfileFromManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemovePackagesFromManagedInstanceGroupResponse removePackagesFromManagedInstanceGroup(RemovePackagesFromManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemovePackagesFromManagedInstanceGroupDetails(), "removePackagesFromManagedInstanceGroupDetails is required");
        return (RemovePackagesFromManagedInstanceGroupResponse)this.clientCall(request, RemovePackagesFromManagedInstanceGroupResponse::builder).logger(LOG, "removePackagesFromManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "RemovePackagesFromManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/RemovePackagesFromManagedInstanceGroup").method(Method.POST).requestBuilder(RemovePackagesFromManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("removePackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RemovePackagesFromManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemovePackagesFromManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SwitchModuleStreamOnManagedInstanceGroupResponse switchModuleStreamOnManagedInstanceGroup(SwitchModuleStreamOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSwitchModuleStreamOnManagedInstanceGroupDetails(), "switchModuleStreamOnManagedInstanceGroupDetails is required");
        return (SwitchModuleStreamOnManagedInstanceGroupResponse)this.clientCall(request, SwitchModuleStreamOnManagedInstanceGroupResponse::builder).logger(LOG, "switchModuleStreamOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "SwitchModuleStreamOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/SwitchModuleStreamOnManagedInstanceGroup").method(Method.POST).requestBuilder(SwitchModuleStreamOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("moduleStreams").appendPathParam("switchModuleStream").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", SwitchModuleStreamOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SwitchModuleStreamOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAllPackagesOnManagedInstanceGroupResponse updateAllPackagesOnManagedInstanceGroup(UpdateAllPackagesOnManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAllPackagesOnManagedInstanceGroupDetails(), "updateAllPackagesOnManagedInstanceGroupDetails is required");
        return (UpdateAllPackagesOnManagedInstanceGroupResponse)this.clientCall(request, UpdateAllPackagesOnManagedInstanceGroupResponse::builder).logger(LOG, "updateAllPackagesOnManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "UpdateAllPackagesOnManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/UpdateAllPackagesOnManagedInstanceGroup").method(Method.POST).requestBuilder(UpdateAllPackagesOnManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).appendPathParam("actions").appendPathParam("updateAllPackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAllPackagesOnManagedInstanceGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAllPackagesOnManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateManagedInstanceGroupResponse updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request) {
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedInstanceGroupDetails(), "updateManagedInstanceGroupDetails is required");
        return (UpdateManagedInstanceGroupResponse)this.clientCall(request, UpdateManagedInstanceGroupResponse::builder).logger(LOG, "updateManagedInstanceGroup").serviceDetails("ManagedInstanceGroup", "UpdateManagedInstanceGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceGroup/UpdateManagedInstanceGroup").method(Method.PUT).requestBuilder(UpdateManagedInstanceGroupRequest::builder).basePath("/20220901").appendPathParam("managedInstanceGroups").appendPathParam(request.getManagedInstanceGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ManagedInstanceGroup.class, UpdateManagedInstanceGroupResponse.Builder::managedInstanceGroup).handleResponseHeaderString("etag", UpdateManagedInstanceGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateManagedInstanceGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ManagedInstanceGroupWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ManagedInstanceGroupPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ManagedInstanceGroupClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ManagedInstanceGroupClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ManagedInstanceGroupClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ManagedInstanceGroupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ManagedInstanceGroupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ManagedInstanceGroupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ManagedInstanceGroupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagedInstanceGroupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagedInstanceGroupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagedInstanceGroupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ManagedInstanceGroupClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ManagedInstanceGroupClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ManagedInstanceGroupClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

