/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.ManagedInstanceGroup;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceGroup;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ManagedInstanceGroupWaiters {
    private final ExecutorService executorService;
    private final ManagedInstanceGroup client;

    public ManagedInstanceGroupWaiters(ExecutorService executorService, ManagedInstanceGroup client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(GetManagedInstanceGroupRequest request, ManagedInstanceGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedInstanceGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(GetManagedInstanceGroupRequest request, ManagedInstanceGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagedInstanceGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(GetManagedInstanceGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ManagedInstanceGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forManagedInstanceGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(BmcGenericWaiter waiter, GetManagedInstanceGroupRequest request, ManagedInstanceGroup.LifecycleState ... targetStates) {
        final HashSet<ManagedInstanceGroup.LifecycleState> targetStatesSet = new HashSet<ManagedInstanceGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse>(){

            @Override
            public GetManagedInstanceGroupResponse apply(GetManagedInstanceGroupRequest request) {
                return ManagedInstanceGroupWaiters.this.client.getManagedInstanceGroup(request);
            }
        }, (Predicate)new Predicate<GetManagedInstanceGroupResponse>(){

            @Override
            public boolean test(GetManagedInstanceGroupResponse response) {
                return targetStatesSet.contains((Object)response.getManagedInstanceGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ManagedInstanceGroup.LifecycleState.Deleted)), (Object)request);
    }
}

