/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.ManagementStation;
import com.oracle.bmc.osmanagementhub.ManagementStationPaginators;
import com.oracle.bmc.osmanagementhub.ManagementStationWaiters;
import com.oracle.bmc.osmanagementhub.model.ManagementStationCollection;
import com.oracle.bmc.osmanagementhub.model.MirrorsCollection;
import com.oracle.bmc.osmanagementhub.requests.ChangeManagementStationCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateManagementStationRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteManagementStationRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagementStationRequest;
import com.oracle.bmc.osmanagementhub.requests.ListManagementStationsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListMirrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.RefreshManagementStationConfigRequest;
import com.oracle.bmc.osmanagementhub.requests.SynchronizeMirrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.SynchronizeSingleMirrorsRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateManagementStationRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeManagementStationCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateManagementStationResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteManagementStationResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagementStationResponse;
import com.oracle.bmc.osmanagementhub.responses.ListManagementStationsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListMirrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.RefreshManagementStationConfigResponse;
import com.oracle.bmc.osmanagementhub.responses.SynchronizeMirrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.SynchronizeSingleMirrorsResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateManagementStationResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementStationClient
extends BaseSyncClient
implements ManagementStation {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MANAGEMENTSTATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ManagementStationClient.class);
    private final ManagementStationWaiters waiters;
    private final ManagementStationPaginators paginators;

    ManagementStationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ManagementStation-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ManagementStationWaiters(executorService, this);
        this.paginators = new ManagementStationPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeManagementStationCompartmentResponse changeManagementStationCompartment(ChangeManagementStationCompartmentRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagementStationCompartmentDetails(), "changeManagementStationCompartmentDetails is required");
        return (ChangeManagementStationCompartmentResponse)this.clientCall(request, ChangeManagementStationCompartmentResponse::builder).logger(LOG, "changeManagementStationCompartment").serviceDetails("ManagementStation", "ChangeManagementStationCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/ChangeManagementStationCompartment").method(Method.POST).requestBuilder(ChangeManagementStationCompartmentRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeManagementStationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateManagementStationResponse createManagementStation(CreateManagementStationRequest request) {
        Objects.requireNonNull(request.getCreateManagementStationDetails(), "createManagementStationDetails is required");
        return (CreateManagementStationResponse)this.clientCall(request, CreateManagementStationResponse::builder).logger(LOG, "createManagementStation").serviceDetails("ManagementStation", "CreateManagementStation", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/CreateManagementStation").method(Method.POST).requestBuilder(CreateManagementStationRequest::builder).basePath("/20220901").appendPathParam("managementStations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.ManagementStation.class, CreateManagementStationResponse.Builder::managementStation).handleResponseHeaderString("opc-request-id", CreateManagementStationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateManagementStationResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteManagementStationResponse deleteManagementStation(DeleteManagementStationRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        return (DeleteManagementStationResponse)this.clientCall(request, DeleteManagementStationResponse::builder).logger(LOG, "deleteManagementStation").serviceDetails("ManagementStation", "DeleteManagementStation", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/DeleteManagementStation").method(Method.DELETE).requestBuilder(DeleteManagementStationRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteManagementStationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagementStationResponse getManagementStation(GetManagementStationRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        return (GetManagementStationResponse)this.clientCall(request, GetManagementStationResponse::builder).logger(LOG, "getManagementStation").serviceDetails("ManagementStation", "GetManagementStation", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/GetManagementStation").method(Method.GET).requestBuilder(GetManagementStationRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.osmanagementhub.model.ManagementStation.class, GetManagementStationResponse.Builder::managementStation).handleResponseHeaderString("etag", GetManagementStationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagementStationResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetManagementStationResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListManagementStationsResponse listManagementStations(ListManagementStationsRequest request) {
        return (ListManagementStationsResponse)this.clientCall(request, ListManagementStationsResponse::builder).logger(LOG, "listManagementStations").serviceDetails("ManagementStation", "ListManagementStations", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/ListManagementStations").method(Method.GET).requestBuilder(ListManagementStationsRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("id", (Object)request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagementStationCollection.class, ListManagementStationsResponse.Builder::managementStationCollection).handleResponseHeaderString("opc-request-id", ListManagementStationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagementStationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListMirrorsResponse listMirrors(ListMirrorsRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        return (ListMirrorsResponse)this.clientCall(request, ListMirrorsResponse::builder).logger(LOG, "listMirrors").serviceDetails("ManagementStation", "ListMirrors", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/MirrorsCollection/ListMirrors").method(Method.GET).requestBuilder(ListMirrorsRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).appendPathParam("mirrors").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("mirrorStates", request.getMirrorStates(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MirrorsCollection.class, ListMirrorsResponse.Builder::mirrorsCollection).handleResponseHeaderString("opc-request-id", ListMirrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMirrorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RefreshManagementStationConfigResponse refreshManagementStationConfig(RefreshManagementStationConfigRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        return (RefreshManagementStationConfigResponse)this.clientCall(request, RefreshManagementStationConfigResponse::builder).logger(LOG, "refreshManagementStationConfig").serviceDetails("ManagementStation", "RefreshManagementStationConfig", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/RefreshManagementStationConfig").method(Method.POST).requestBuilder(RefreshManagementStationConfigRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).appendPathParam("actions").appendPathParam("refresh").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", RefreshManagementStationConfigResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshManagementStationConfigResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SynchronizeMirrorsResponse synchronizeMirrors(SynchronizeMirrorsRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSynchronizeMirrorsDetails(), "synchronizeMirrorsDetails is required");
        return (SynchronizeMirrorsResponse)this.clientCall(request, SynchronizeMirrorsResponse::builder).logger(LOG, "synchronizeMirrors").serviceDetails("ManagementStation", "SynchronizeMirrors", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/SynchronizeMirrors").method(Method.POST).requestBuilder(SynchronizeMirrorsRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).appendPathParam("actions").appendPathParam("synchronizeMirrors").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", SynchronizeMirrorsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SynchronizeMirrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SynchronizeSingleMirrorsResponse synchronizeSingleMirrors(SynchronizeSingleMirrorsRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMirrorId(), (String)"mirrorId must not be blank", (Object[])new Object[0]);
        return (SynchronizeSingleMirrorsResponse)this.clientCall(request, SynchronizeSingleMirrorsResponse::builder).logger(LOG, "synchronizeSingleMirrors").serviceDetails("ManagementStation", "SynchronizeSingleMirrors", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/SynchronizeSingleMirrors").method(Method.POST).requestBuilder(SynchronizeSingleMirrorsRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).appendPathParam("mirrors").appendPathParam(request.getMirrorId()).appendPathParam("actions").appendPathParam("synchronize").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", SynchronizeSingleMirrorsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SynchronizeSingleMirrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateManagementStationResponse updateManagementStation(UpdateManagementStationRequest request) {
        Validate.notBlank((String)request.getManagementStationId(), (String)"managementStationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagementStationDetails(), "updateManagementStationDetails is required");
        return (UpdateManagementStationResponse)this.clientCall(request, UpdateManagementStationResponse::builder).logger(LOG, "updateManagementStation").serviceDetails("ManagementStation", "UpdateManagementStation", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagementStation/UpdateManagementStation").method(Method.PUT).requestBuilder(UpdateManagementStationRequest::builder).basePath("/20220901").appendPathParam("managementStations").appendPathParam(request.getManagementStationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.ManagementStation.class, UpdateManagementStationResponse.Builder::managementStation).handleResponseHeaderString("etag", UpdateManagementStationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateManagementStationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ManagementStationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ManagementStationPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ManagementStationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ManagementStationClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ManagementStationClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ManagementStationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ManagementStationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ManagementStationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ManagementStationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagementStationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementStationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagementStationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ManagementStationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ManagementStationClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ManagementStationClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

