/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.ManagementStation;
import com.oracle.bmc.osmanagementhub.model.ManagementStationSummary;
import com.oracle.bmc.osmanagementhub.model.MirrorSummary;
import com.oracle.bmc.osmanagementhub.requests.ListManagementStationsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListMirrorsRequest;
import com.oracle.bmc.osmanagementhub.responses.ListManagementStationsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListMirrorsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ManagementStationPaginators {
    private final ManagementStation client;

    public ManagementStationPaginators(ManagementStation client) {
        this.client = client;
    }

    public Iterable<ListManagementStationsResponse> listManagementStationsResponseIterator(final ListManagementStationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListManagementStationsRequest.Builder>(){

            @Override
            public ListManagementStationsRequest.Builder get() {
                return ListManagementStationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagementStationsResponse, String>(){

            @Override
            public String apply(ListManagementStationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagementStationsRequest.Builder>, ListManagementStationsRequest>(){

            @Override
            public ListManagementStationsRequest apply(RequestBuilderAndToken<ListManagementStationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagementStationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagementStationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagementStationsRequest, ListManagementStationsResponse>(){

            @Override
            public ListManagementStationsResponse apply(ListManagementStationsRequest request) {
                return ManagementStationPaginators.this.client.listManagementStations(request);
            }
        });
    }

    public Iterable<ManagementStationSummary> listManagementStationsRecordIterator(final ListManagementStationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListManagementStationsRequest.Builder>(){

            @Override
            public ListManagementStationsRequest.Builder get() {
                return ListManagementStationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagementStationsResponse, String>(){

            @Override
            public String apply(ListManagementStationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagementStationsRequest.Builder>, ListManagementStationsRequest>(){

            @Override
            public ListManagementStationsRequest apply(RequestBuilderAndToken<ListManagementStationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagementStationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagementStationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagementStationsRequest, ListManagementStationsResponse>(){

            @Override
            public ListManagementStationsResponse apply(ListManagementStationsRequest request) {
                return ManagementStationPaginators.this.client.listManagementStations(request);
            }
        }, (Function)new Function<ListManagementStationsResponse, List<ManagementStationSummary>>(){

            @Override
            public List<ManagementStationSummary> apply(ListManagementStationsResponse response) {
                return response.getManagementStationCollection().getItems();
            }
        });
    }

    public Iterable<ListMirrorsResponse> listMirrorsResponseIterator(final ListMirrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMirrorsRequest.Builder>(){

            @Override
            public ListMirrorsRequest.Builder get() {
                return ListMirrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMirrorsResponse, String>(){

            @Override
            public String apply(ListMirrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMirrorsRequest.Builder>, ListMirrorsRequest>(){

            @Override
            public ListMirrorsRequest apply(RequestBuilderAndToken<ListMirrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMirrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMirrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMirrorsRequest, ListMirrorsResponse>(){

            @Override
            public ListMirrorsResponse apply(ListMirrorsRequest request) {
                return ManagementStationPaginators.this.client.listMirrors(request);
            }
        });
    }

    public Iterable<MirrorSummary> listMirrorsRecordIterator(final ListMirrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMirrorsRequest.Builder>(){

            @Override
            public ListMirrorsRequest.Builder get() {
                return ListMirrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMirrorsResponse, String>(){

            @Override
            public String apply(ListMirrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMirrorsRequest.Builder>, ListMirrorsRequest>(){

            @Override
            public ListMirrorsRequest apply(RequestBuilderAndToken<ListMirrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMirrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMirrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMirrorsRequest, ListMirrorsResponse>(){

            @Override
            public ListMirrorsResponse apply(ListMirrorsRequest request) {
                return ManagementStationPaginators.this.client.listMirrors(request);
            }
        }, (Function)new Function<ListMirrorsResponse, List<MirrorSummary>>(){

            @Override
            public List<MirrorSummary> apply(ListMirrorsResponse response) {
                return response.getMirrorsCollection().getItems();
            }
        });
    }
}

