/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.ManagementStation;
import com.oracle.bmc.osmanagementhub.model.ManagementStation;
import com.oracle.bmc.osmanagementhub.requests.GetManagementStationRequest;
import com.oracle.bmc.osmanagementhub.responses.GetManagementStationResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ManagementStationWaiters {
    private final ExecutorService executorService;
    private final ManagementStation client;

    public ManagementStationWaiters(ExecutorService executorService, ManagementStation client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetManagementStationRequest, GetManagementStationResponse> forManagementStation(GetManagementStationRequest request, ManagementStation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagementStation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagementStationRequest, GetManagementStationResponse> forManagementStation(GetManagementStationRequest request, ManagementStation.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagementStation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagementStationRequest, GetManagementStationResponse> forManagementStation(GetManagementStationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ManagementStation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forManagementStation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagementStationRequest, GetManagementStationResponse> forManagementStation(BmcGenericWaiter waiter, GetManagementStationRequest request, ManagementStation.LifecycleState ... targetStates) {
        final HashSet<ManagementStation.LifecycleState> targetStatesSet = new HashSet<ManagementStation.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetManagementStationRequest, GetManagementStationResponse>(){

            @Override
            public GetManagementStationResponse apply(GetManagementStationRequest request) {
                return ManagementStationWaiters.this.client.getManagementStation(request);
            }
        }, (Predicate)new Predicate<GetManagementStationResponse>(){

            @Override
            public boolean test(GetManagementStationResponse response) {
                return targetStatesSet.contains((Object)response.getManagementStation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ManagementStation.LifecycleState.Deleted)), (Object)request);
    }
}

