/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagementhub.OnboardingAsync;
import com.oracle.bmc.osmanagementhub.model.Profile;
import com.oracle.bmc.osmanagementhub.model.ProfileCollection;
import com.oracle.bmc.osmanagementhub.requests.ChangeProfileCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.ListProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateProfileRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeProfileCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.ListProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateProfileResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardingAsyncClient
extends BaseAsyncClient
implements OnboardingAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ONBOARDING").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OnboardingAsyncClient.class);

    OnboardingAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeProfileCompartmentResponse> changeProfileCompartment(ChangeProfileCompartmentRequest request, AsyncHandler<ChangeProfileCompartmentRequest, ChangeProfileCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProfileCompartmentDetails(), "changeProfileCompartmentDetails is required");
        return this.clientCall(request, ChangeProfileCompartmentResponse::builder).logger(LOG, "changeProfileCompartment").serviceDetails("Onboarding", "ChangeProfileCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/ChangeProfileCompartment").method(Method.POST).requestBuilder(ChangeProfileCompartmentRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProfileCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProfileResponse> createProfile(CreateProfileRequest request, AsyncHandler<CreateProfileRequest, CreateProfileResponse> handler) {
        Objects.requireNonNull(request.getCreateProfileDetails(), "createProfileDetails is required");
        return this.clientCall(request, CreateProfileResponse::builder).logger(LOG, "createProfile").serviceDetails("Onboarding", "CreateProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/CreateProfile").method(Method.POST).requestBuilder(CreateProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Profile.class, CreateProfileResponse.Builder::profile).handleResponseHeaderString("etag", CreateProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProfileResponse> deleteProfile(DeleteProfileRequest request, AsyncHandler<DeleteProfileRequest, DeleteProfileResponse> handler) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProfileResponse::builder).logger(LOG, "deleteProfile").serviceDetails("Onboarding", "DeleteProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/DeleteProfile").method(Method.DELETE).requestBuilder(DeleteProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProfileResponse> getProfile(GetProfileRequest request, AsyncHandler<GetProfileRequest, GetProfileResponse> handler) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProfileResponse::builder).logger(LOG, "getProfile").serviceDetails("Onboarding", "GetProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/GetProfile").method(Method.GET).requestBuilder(GetProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Profile.class, GetProfileResponse.Builder::profile).handleResponseHeaderString("etag", GetProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListProfilesResponse> listProfiles(ListProfilesRequest request, AsyncHandler<ListProfilesRequest, ListProfilesResponse> handler) {
        return this.clientCall(request, ListProfilesResponse::builder).logger(LOG, "listProfiles").serviceDetails("Onboarding", "ListProfiles", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/ListProfiles").method(Method.GET).requestBuilder(ListProfilesRequest::builder).basePath("/20220901").appendPathParam("profiles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendListQueryParam("profileType", request.getProfileType(), CollectionFormatType.Multi).appendQueryParam("profileId", (Object)request.getProfileId()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendEnumQueryParam("archType", (BmcEnum)request.getArchType()).appendListQueryParam("registrationType", request.getRegistrationType(), CollectionFormatType.Multi).appendQueryParam("isDefaultProfile", (Object)request.getIsDefaultProfile()).appendQueryParam("isServiceProvidedProfile", (Object)request.getIsServiceProvidedProfile()).appendEnumQueryParam("vendorName", (BmcEnum)request.getVendorName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProfileCollection.class, ListProfilesResponse.Builder::profileCollection).handleResponseHeaderString("opc-request-id", ListProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProfilesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateProfileResponse> updateProfile(UpdateProfileRequest request, AsyncHandler<UpdateProfileRequest, UpdateProfileResponse> handler) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProfileDetails(), "updateProfileDetails is required");
        return this.clientCall(request, UpdateProfileResponse::builder).logger(LOG, "updateProfile").serviceDetails("Onboarding", "UpdateProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/UpdateProfile").method(Method.PUT).requestBuilder(UpdateProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Profile.class, UpdateProfileResponse.Builder::profile).handleResponseHeaderString("etag", UpdateProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OnboardingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OnboardingAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OnboardingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OnboardingAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OnboardingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OnboardingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OnboardingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OnboardingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OnboardingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OnboardingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OnboardingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OnboardingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OnboardingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OnboardingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OnboardingAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OnboardingAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OnboardingAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

