/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.Onboarding;
import com.oracle.bmc.osmanagementhub.OnboardingPaginators;
import com.oracle.bmc.osmanagementhub.OnboardingWaiters;
import com.oracle.bmc.osmanagementhub.model.Profile;
import com.oracle.bmc.osmanagementhub.model.ProfileCollection;
import com.oracle.bmc.osmanagementhub.requests.ChangeProfileCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.ListProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateProfileRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeProfileCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.ListProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateProfileResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardingClient
extends BaseSyncClient
implements Onboarding {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ONBOARDING").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OnboardingClient.class);
    private final OnboardingWaiters waiters;
    private final OnboardingPaginators paginators;

    OnboardingClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Onboarding-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OnboardingWaiters(executorService, this);
        this.paginators = new OnboardingPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeProfileCompartmentResponse changeProfileCompartment(ChangeProfileCompartmentRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProfileCompartmentDetails(), "changeProfileCompartmentDetails is required");
        return (ChangeProfileCompartmentResponse)this.clientCall(request, ChangeProfileCompartmentResponse::builder).logger(LOG, "changeProfileCompartment").serviceDetails("Onboarding", "ChangeProfileCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/ChangeProfileCompartment").method(Method.POST).requestBuilder(ChangeProfileCompartmentRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeProfileCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest request) {
        Objects.requireNonNull(request.getCreateProfileDetails(), "createProfileDetails is required");
        return (CreateProfileResponse)this.clientCall(request, CreateProfileResponse::builder).logger(LOG, "createProfile").serviceDetails("Onboarding", "CreateProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/CreateProfile").method(Method.POST).requestBuilder(CreateProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Profile.class, CreateProfileResponse.Builder::profile).handleResponseHeaderString("etag", CreateProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        return (DeleteProfileResponse)this.clientCall(request, DeleteProfileResponse::builder).logger(LOG, "deleteProfile").serviceDetails("Onboarding", "DeleteProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/DeleteProfile").method(Method.DELETE).requestBuilder(DeleteProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProfileResponse getProfile(GetProfileRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        return (GetProfileResponse)this.clientCall(request, GetProfileResponse::builder).logger(LOG, "getProfile").serviceDetails("Onboarding", "GetProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/GetProfile").method(Method.GET).requestBuilder(GetProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Profile.class, GetProfileResponse.Builder::profile).handleResponseHeaderString("etag", GetProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListProfilesResponse listProfiles(ListProfilesRequest request) {
        return (ListProfilesResponse)this.clientCall(request, ListProfilesResponse::builder).logger(LOG, "listProfiles").serviceDetails("Onboarding", "ListProfiles", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/ListProfiles").method(Method.GET).requestBuilder(ListProfilesRequest::builder).basePath("/20220901").appendPathParam("profiles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendListQueryParam("profileType", request.getProfileType(), CollectionFormatType.Multi).appendQueryParam("profileId", (Object)request.getProfileId()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendEnumQueryParam("archType", (BmcEnum)request.getArchType()).appendListQueryParam("registrationType", request.getRegistrationType(), CollectionFormatType.Multi).appendQueryParam("isDefaultProfile", (Object)request.getIsDefaultProfile()).appendQueryParam("isServiceProvidedProfile", (Object)request.getIsServiceProvidedProfile()).appendEnumQueryParam("vendorName", (BmcEnum)request.getVendorName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProfileCollection.class, ListProfilesResponse.Builder::profileCollection).handleResponseHeaderString("opc-request-id", ListProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProfilesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateProfileResponse updateProfile(UpdateProfileRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProfileDetails(), "updateProfileDetails is required");
        return (UpdateProfileResponse)this.clientCall(request, UpdateProfileResponse::builder).logger(LOG, "updateProfile").serviceDetails("Onboarding", "UpdateProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Profile/UpdateProfile").method(Method.PUT).requestBuilder(UpdateProfileRequest::builder).basePath("/20220901").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Profile.class, UpdateProfileResponse.Builder::profile).handleResponseHeaderString("etag", UpdateProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OnboardingWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OnboardingPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OnboardingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OnboardingClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OnboardingClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OnboardingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OnboardingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OnboardingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OnboardingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OnboardingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OnboardingClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OnboardingClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OnboardingClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OnboardingClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OnboardingClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

