/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.Onboarding;
import com.oracle.bmc.osmanagementhub.model.ProfileSummary;
import com.oracle.bmc.osmanagementhub.requests.ListProfilesRequest;
import com.oracle.bmc.osmanagementhub.responses.ListProfilesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OnboardingPaginators {
    private final Onboarding client;

    public OnboardingPaginators(Onboarding client) {
        this.client = client;
    }

    public Iterable<ListProfilesResponse> listProfilesResponseIterator(final ListProfilesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProfilesRequest.Builder>(){

            @Override
            public ListProfilesRequest.Builder get() {
                return ListProfilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfilesResponse, String>(){

            @Override
            public String apply(ListProfilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfilesRequest.Builder>, ListProfilesRequest>(){

            @Override
            public ListProfilesRequest apply(RequestBuilderAndToken<ListProfilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProfilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProfilesRequest, ListProfilesResponse>(){

            @Override
            public ListProfilesResponse apply(ListProfilesRequest request) {
                return OnboardingPaginators.this.client.listProfiles(request);
            }
        });
    }

    public Iterable<ProfileSummary> listProfilesRecordIterator(final ListProfilesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProfilesRequest.Builder>(){

            @Override
            public ListProfilesRequest.Builder get() {
                return ListProfilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfilesResponse, String>(){

            @Override
            public String apply(ListProfilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfilesRequest.Builder>, ListProfilesRequest>(){

            @Override
            public ListProfilesRequest apply(RequestBuilderAndToken<ListProfilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProfilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProfilesRequest, ListProfilesResponse>(){

            @Override
            public ListProfilesResponse apply(ListProfilesRequest request) {
                return OnboardingPaginators.this.client.listProfiles(request);
            }
        }, (Function)new Function<ListProfilesResponse, List<ProfileSummary>>(){

            @Override
            public List<ProfileSummary> apply(ListProfilesResponse response) {
                return response.getProfileCollection().getItems();
            }
        });
    }
}

