/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.Onboarding;
import com.oracle.bmc.osmanagementhub.model.Profile;
import com.oracle.bmc.osmanagementhub.requests.GetProfileRequest;
import com.oracle.bmc.osmanagementhub.responses.GetProfileResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OnboardingWaiters {
    private final ExecutorService executorService;
    private final Onboarding client;

    public OnboardingWaiters(ExecutorService executorService, Onboarding client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetProfileRequest, GetProfileResponse> forProfile(GetProfileRequest request, Profile.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProfile(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProfileRequest, GetProfileResponse> forProfile(GetProfileRequest request, Profile.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProfile(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProfileRequest, GetProfileResponse> forProfile(GetProfileRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Profile.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProfile(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProfileRequest, GetProfileResponse> forProfile(BmcGenericWaiter waiter, GetProfileRequest request, Profile.LifecycleState ... targetStates) {
        final HashSet<Profile.LifecycleState> targetStatesSet = new HashSet<Profile.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProfileRequest, GetProfileResponse>(){

            @Override
            public GetProfileResponse apply(GetProfileRequest request) {
                return OnboardingWaiters.this.client.getProfile(request);
            }
        }, (Predicate)new Predicate<GetProfileResponse>(){

            @Override
            public boolean test(GetProfileResponse response) {
                return targetStatesSet.contains((Object)response.getProfile().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Profile.LifecycleState.Deleted)), (Object)request);
    }
}

