/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagementhub.ReportingManagedInstanceAsync;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceAnalyticCollection;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceAnalyticContentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceContentRequest;
import com.oracle.bmc.osmanagementhub.requests.SummarizeManagedInstanceAnalyticsRequest;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceAnalyticContentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceContentResponse;
import com.oracle.bmc.osmanagementhub.responses.SummarizeManagedInstanceAnalyticsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingManagedInstanceAsyncClient
extends BaseAsyncClient
implements ReportingManagedInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REPORTINGMANAGEDINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ReportingManagedInstanceAsyncClient.class);

    ReportingManagedInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    ReportingManagedInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ReportingManagedInstanceAsyncClient", (String)"getManagedInstanceAnalyticContent,getManagedInstanceContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetManagedInstanceAnalyticContentResponse> getManagedInstanceAnalyticContent(GetManagedInstanceAnalyticContentRequest request, AsyncHandler<GetManagedInstanceAnalyticContentRequest, GetManagedInstanceAnalyticContentResponse> handler) {
        return this.clientCall(request, GetManagedInstanceAnalyticContentResponse::builder).logger(LOG, "getManagedInstanceAnalyticContent").serviceDetails("ReportingManagedInstance", "GetManagedInstanceAnalyticContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/GetManagedInstanceAnalyticContent").method(Method.GET).requestBuilder(GetManagedInstanceAnalyticContentRequest::builder).basePath("/20220901").appendPathParam("managedInstanceAnalytics").appendPathParam("content").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("lifecycleEnvironmentId", (Object)request.getLifecycleEnvironmentId()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("securityUpdatesAvailableEqualsTo", (Object)request.getSecurityUpdatesAvailableEqualsTo()).appendQueryParam("bugUpdatesAvailableEqualsTo", (Object)request.getBugUpdatesAvailableEqualsTo()).appendQueryParam("securityUpdatesAvailableGreaterThan", (Object)request.getSecurityUpdatesAvailableGreaterThan()).appendQueryParam("bugUpdatesAvailableGreaterThan", (Object)request.getBugUpdatesAvailableGreaterThan()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).appendEnumQueryParam("reportType", (BmcEnum)request.getReportType()).accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetManagedInstanceAnalyticContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetManagedInstanceAnalyticContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceAnalyticContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagedInstanceContentResponse> getManagedInstanceContent(GetManagedInstanceContentRequest request, AsyncHandler<GetManagedInstanceContentRequest, GetManagedInstanceContentResponse> handler) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getVulnerabilityType(), "vulnerabilityType is required");
        return this.clientCall(request, GetManagedInstanceContentResponse::builder).logger(LOG, "getManagedInstanceContent").serviceDetails("ReportingManagedInstance", "GetManagedInstanceContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/GetManagedInstanceContent").method(Method.GET).requestBuilder(GetManagedInstanceContentRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("content").appendListQueryParam("advisoryName", request.getAdvisoryName(), CollectionFormatType.Multi).appendQueryParam("advisoryNameContains", (Object)request.getAdvisoryNameContains()).appendListQueryParam("advisoryType", request.getAdvisoryType(), CollectionFormatType.Multi).appendListQueryParam("vulnerabilityName", request.getVulnerabilityName(), CollectionFormatType.Multi).appendQueryParam("vulnerabilityNameContains", (Object)request.getVulnerabilityNameContains()).appendListQueryParam("vulnerabilityType", request.getVulnerabilityType(), CollectionFormatType.Multi).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetManagedInstanceContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetManagedInstanceContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SummarizeManagedInstanceAnalyticsResponse> summarizeManagedInstanceAnalytics(SummarizeManagedInstanceAnalyticsRequest request, AsyncHandler<SummarizeManagedInstanceAnalyticsRequest, SummarizeManagedInstanceAnalyticsResponse> handler) {
        Objects.requireNonNull(request.getMetricNames(), "metricNames is required");
        return this.clientCall(request, SummarizeManagedInstanceAnalyticsResponse::builder).logger(LOG, "summarizeManagedInstanceAnalytics").serviceDetails("ReportingManagedInstance", "SummarizeManagedInstanceAnalytics", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceAnalyticCollection/SummarizeManagedInstanceAnalytics").method(Method.GET).requestBuilder(SummarizeManagedInstanceAnalyticsRequest::builder).basePath("/20220901").appendPathParam("managedInstanceAnalytics").appendListQueryParam("metricNames", request.getMetricNames(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("lifecycleEnvironmentId", (Object)request.getLifecycleEnvironmentId()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstanceAnalyticCollection.class, SummarizeManagedInstanceAnalyticsResponse.Builder::managedInstanceAnalyticCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedInstanceAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedInstanceAnalyticsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ReportingManagedInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ReportingManagedInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ReportingManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ReportingManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ReportingManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ReportingManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ReportingManagedInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ReportingManagedInstanceAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ReportingManagedInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ReportingManagedInstanceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

