/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagementhub.ReportingManagedInstance;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceAnalyticCollection;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceAnalyticContentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceContentRequest;
import com.oracle.bmc.osmanagementhub.requests.SummarizeManagedInstanceAnalyticsRequest;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceAnalyticContentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceContentResponse;
import com.oracle.bmc.osmanagementhub.responses.SummarizeManagedInstanceAnalyticsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingManagedInstanceClient
extends BaseSyncClient
implements ReportingManagedInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REPORTINGMANAGEDINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ReportingManagedInstanceClient.class);

    ReportingManagedInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    ReportingManagedInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ReportingManagedInstanceClient", (String)"getManagedInstanceAnalyticContent,getManagedInstanceContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetManagedInstanceAnalyticContentResponse getManagedInstanceAnalyticContent(GetManagedInstanceAnalyticContentRequest request) {
        return (GetManagedInstanceAnalyticContentResponse)this.clientCall(request, GetManagedInstanceAnalyticContentResponse::builder).logger(LOG, "getManagedInstanceAnalyticContent").serviceDetails("ReportingManagedInstance", "GetManagedInstanceAnalyticContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/GetManagedInstanceAnalyticContent").method(Method.GET).requestBuilder(GetManagedInstanceAnalyticContentRequest::builder).basePath("/20220901").appendPathParam("managedInstanceAnalytics").appendPathParam("content").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("lifecycleEnvironmentId", (Object)request.getLifecycleEnvironmentId()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("securityUpdatesAvailableEqualsTo", (Object)request.getSecurityUpdatesAvailableEqualsTo()).appendQueryParam("bugUpdatesAvailableEqualsTo", (Object)request.getBugUpdatesAvailableEqualsTo()).appendQueryParam("securityUpdatesAvailableGreaterThan", (Object)request.getSecurityUpdatesAvailableGreaterThan()).appendQueryParam("bugUpdatesAvailableGreaterThan", (Object)request.getBugUpdatesAvailableGreaterThan()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).appendEnumQueryParam("reportType", (BmcEnum)request.getReportType()).accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetManagedInstanceAnalyticContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetManagedInstanceAnalyticContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceAnalyticContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetManagedInstanceContentResponse getManagedInstanceContent(GetManagedInstanceContentRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getVulnerabilityType(), "vulnerabilityType is required");
        return (GetManagedInstanceContentResponse)this.clientCall(request, GetManagedInstanceContentResponse::builder).logger(LOG, "getManagedInstanceContent").serviceDetails("ReportingManagedInstance", "GetManagedInstanceContent", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstance/GetManagedInstanceContent").method(Method.GET).requestBuilder(GetManagedInstanceContentRequest::builder).basePath("/20220901").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("content").appendListQueryParam("advisoryName", request.getAdvisoryName(), CollectionFormatType.Multi).appendQueryParam("advisoryNameContains", (Object)request.getAdvisoryNameContains()).appendListQueryParam("advisoryType", request.getAdvisoryType(), CollectionFormatType.Multi).appendListQueryParam("vulnerabilityName", request.getVulnerabilityName(), CollectionFormatType.Multi).appendQueryParam("vulnerabilityNameContains", (Object)request.getVulnerabilityNameContains()).appendListQueryParam("vulnerabilityType", request.getVulnerabilityType(), CollectionFormatType.Multi).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetManagedInstanceContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetManagedInstanceContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetManagedInstanceContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SummarizeManagedInstanceAnalyticsResponse summarizeManagedInstanceAnalytics(SummarizeManagedInstanceAnalyticsRequest request) {
        Objects.requireNonNull(request.getMetricNames(), "metricNames is required");
        return (SummarizeManagedInstanceAnalyticsResponse)this.clientCall(request, SummarizeManagedInstanceAnalyticsResponse::builder).logger(LOG, "summarizeManagedInstanceAnalytics").serviceDetails("ReportingManagedInstance", "SummarizeManagedInstanceAnalytics", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ManagedInstanceAnalyticCollection/SummarizeManagedInstanceAnalytics").method(Method.GET).requestBuilder(SummarizeManagedInstanceAnalyticsRequest::builder).basePath("/20220901").appendPathParam("managedInstanceAnalytics").appendListQueryParam("metricNames", request.getMetricNames(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("lifecycleEnvironmentId", (Object)request.getLifecycleEnvironmentId()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceAnalyticCollection.class, SummarizeManagedInstanceAnalyticsResponse.Builder::managedInstanceAnalyticCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedInstanceAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedInstanceAnalyticsResponse.Builder::opcNextPage).callSync();
    }

    @Deprecated
    public ReportingManagedInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ReportingManagedInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ReportingManagedInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ReportingManagedInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ReportingManagedInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ReportingManagedInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ReportingManagedInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ReportingManagedInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ReportingManagedInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ReportingManagedInstanceClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ReportingManagedInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ReportingManagedInstanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

