/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagementhub.ScheduledJobAsync;
import com.oracle.bmc.osmanagementhub.model.ScheduledJob;
import com.oracle.bmc.osmanagementhub.model.ScheduledJobCollection;
import com.oracle.bmc.osmanagementhub.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagementhub.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagementhub.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledJobAsyncClient
extends BaseAsyncClient
implements ScheduledJobAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SCHEDULEDJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledJobAsyncClient.class);

    ScheduledJobAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeScheduledJobCompartmentResponse> changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request, AsyncHandler<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeScheduledJobCompartmentDetails(), "changeScheduledJobCompartmentDetails is required");
        return this.clientCall(request, ChangeScheduledJobCompartmentResponse::builder).logger(LOG, "changeScheduledJobCompartment").serviceDetails("ScheduledJob", "ChangeScheduledJobCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/ChangeScheduledJobCompartment").method(Method.POST).requestBuilder(ChangeScheduledJobCompartmentRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeScheduledJobCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateScheduledJobResponse> createScheduledJob(CreateScheduledJobRequest request, AsyncHandler<CreateScheduledJobRequest, CreateScheduledJobResponse> handler) {
        Objects.requireNonNull(request.getCreateScheduledJobDetails(), "createScheduledJobDetails is required");
        return this.clientCall(request, CreateScheduledJobResponse::builder).logger(LOG, "createScheduledJob").serviceDetails("ScheduledJob", "CreateScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/CreateScheduledJob").method(Method.POST).requestBuilder(CreateScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ScheduledJob.class, CreateScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("Location", CreateScheduledJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateScheduledJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduledJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteScheduledJobResponse> deleteScheduledJob(DeleteScheduledJobRequest request, AsyncHandler<DeleteScheduledJobRequest, DeleteScheduledJobResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteScheduledJobResponse::builder).logger(LOG, "deleteScheduledJob").serviceDetails("ScheduledJob", "DeleteScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/DeleteScheduledJob").method(Method.DELETE).requestBuilder(DeleteScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteScheduledJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetScheduledJobResponse> getScheduledJob(GetScheduledJobRequest request, AsyncHandler<GetScheduledJobRequest, GetScheduledJobResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScheduledJobResponse::builder).logger(LOG, "getScheduledJob").serviceDetails("ScheduledJob", "GetScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/GetScheduledJob").method(Method.GET).requestBuilder(GetScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledJob.class, GetScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("etag", GetScheduledJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScheduledJobResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetScheduledJobResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListScheduledJobsResponse> listScheduledJobs(ListScheduledJobsRequest request, AsyncHandler<ListScheduledJobsRequest, ListScheduledJobsResponse> handler) {
        return this.clientCall(request, ListScheduledJobsResponse::builder).logger(LOG, "listScheduledJobs").serviceDetails("ScheduledJob", "ListScheduledJobs", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/ListScheduledJobs").method(Method.GET).requestBuilder(ListScheduledJobsRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("managedCompartmentId", (Object)request.getManagedCompartmentId()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendEnumQueryParam("scheduleType", (BmcEnum)request.getScheduleType()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("isRestricted", (Object)request.getIsRestricted()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledJobCollection.class, ListScheduledJobsResponse.Builder::scheduledJobCollection).handleResponseHeaderString("opc-request-id", ListScheduledJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RunScheduledJobNowResponse> runScheduledJobNow(RunScheduledJobNowRequest request, AsyncHandler<RunScheduledJobNowRequest, RunScheduledJobNowResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RunScheduledJobNowResponse::builder).logger(LOG, "runScheduledJobNow").serviceDetails("ScheduledJob", "RunScheduledJobNow", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/RunScheduledJobNow").method(Method.POST).requestBuilder(RunScheduledJobNowRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("runNow").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RunScheduledJobNowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateScheduledJobResponse> updateScheduledJob(UpdateScheduledJobRequest request, AsyncHandler<UpdateScheduledJobRequest, UpdateScheduledJobResponse> handler) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScheduledJobDetails(), "updateScheduledJobDetails is required");
        return this.clientCall(request, UpdateScheduledJobResponse::builder).logger(LOG, "updateScheduledJob").serviceDetails("ScheduledJob", "UpdateScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/UpdateScheduledJob").method(Method.PUT).requestBuilder(UpdateScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ScheduledJob.class, UpdateScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("etag", UpdateScheduledJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateScheduledJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ScheduledJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ScheduledJobAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ScheduledJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ScheduledJobAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ScheduledJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ScheduledJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ScheduledJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ScheduledJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ScheduledJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ScheduledJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ScheduledJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ScheduledJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ScheduledJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ScheduledJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ScheduledJobAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ScheduledJobAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ScheduledJobAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

