/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.ScheduledJob;
import com.oracle.bmc.osmanagementhub.ScheduledJobPaginators;
import com.oracle.bmc.osmanagementhub.ScheduledJobWaiters;
import com.oracle.bmc.osmanagementhub.model.ScheduledJobCollection;
import com.oracle.bmc.osmanagementhub.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagementhub.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagementhub.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagementhub.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledJobClient
extends BaseSyncClient
implements ScheduledJob {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SCHEDULEDJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledJobClient.class);
    private final ScheduledJobWaiters waiters;
    private final ScheduledJobPaginators paginators;

    ScheduledJobClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ScheduledJob-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ScheduledJobWaiters(executorService, this);
        this.paginators = new ScheduledJobPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeScheduledJobCompartmentResponse changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeScheduledJobCompartmentDetails(), "changeScheduledJobCompartmentDetails is required");
        return (ChangeScheduledJobCompartmentResponse)this.clientCall(request, ChangeScheduledJobCompartmentResponse::builder).logger(LOG, "changeScheduledJobCompartment").serviceDetails("ScheduledJob", "ChangeScheduledJobCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/ChangeScheduledJobCompartment").method(Method.POST).requestBuilder(ChangeScheduledJobCompartmentRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeScheduledJobCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateScheduledJobResponse createScheduledJob(CreateScheduledJobRequest request) {
        Objects.requireNonNull(request.getCreateScheduledJobDetails(), "createScheduledJobDetails is required");
        return (CreateScheduledJobResponse)this.clientCall(request, CreateScheduledJobResponse::builder).logger(LOG, "createScheduledJob").serviceDetails("ScheduledJob", "CreateScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/CreateScheduledJob").method(Method.POST).requestBuilder(CreateScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.ScheduledJob.class, CreateScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("Location", CreateScheduledJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateScheduledJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduledJobResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteScheduledJobResponse deleteScheduledJob(DeleteScheduledJobRequest request) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return (DeleteScheduledJobResponse)this.clientCall(request, DeleteScheduledJobResponse::builder).logger(LOG, "deleteScheduledJob").serviceDetails("ScheduledJob", "DeleteScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/DeleteScheduledJob").method(Method.DELETE).requestBuilder(DeleteScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteScheduledJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetScheduledJobResponse getScheduledJob(GetScheduledJobRequest request) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return (GetScheduledJobResponse)this.clientCall(request, GetScheduledJobResponse::builder).logger(LOG, "getScheduledJob").serviceDetails("ScheduledJob", "GetScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/GetScheduledJob").method(Method.GET).requestBuilder(GetScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.osmanagementhub.model.ScheduledJob.class, GetScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("etag", GetScheduledJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScheduledJobResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetScheduledJobResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListScheduledJobsResponse listScheduledJobs(ListScheduledJobsRequest request) {
        return (ListScheduledJobsResponse)this.clientCall(request, ListScheduledJobsResponse::builder).logger(LOG, "listScheduledJobs").serviceDetails("ScheduledJob", "ListScheduledJobs", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/ListScheduledJobs").method(Method.GET).requestBuilder(ListScheduledJobsRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("managedInstanceGroupId", (Object)request.getManagedInstanceGroupId()).appendQueryParam("managedCompartmentId", (Object)request.getManagedCompartmentId()).appendQueryParam("lifecycleStageId", (Object)request.getLifecycleStageId()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendEnumQueryParam("scheduleType", (BmcEnum)request.getScheduleType()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("isRestricted", (Object)request.getIsRestricted()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendListQueryParam("location", request.getLocation(), CollectionFormatType.Multi).appendListQueryParam("locationNotEqualTo", request.getLocationNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("isManagedByAutonomousLinux", (Object)request.getIsManagedByAutonomousLinux()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ScheduledJobCollection.class, ListScheduledJobsResponse.Builder::scheduledJobCollection).handleResponseHeaderString("opc-request-id", ListScheduledJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledJobsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RunScheduledJobNowResponse runScheduledJobNow(RunScheduledJobNowRequest request) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        return (RunScheduledJobNowResponse)this.clientCall(request, RunScheduledJobNowResponse::builder).logger(LOG, "runScheduledJobNow").serviceDetails("ScheduledJob", "RunScheduledJobNow", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/RunScheduledJobNow").method(Method.POST).requestBuilder(RunScheduledJobNowRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).appendPathParam("actions").appendPathParam("runNow").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", RunScheduledJobNowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateScheduledJobResponse updateScheduledJob(UpdateScheduledJobRequest request) {
        Validate.notBlank((String)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScheduledJobDetails(), "updateScheduledJobDetails is required");
        return (UpdateScheduledJobResponse)this.clientCall(request, UpdateScheduledJobResponse::builder).logger(LOG, "updateScheduledJob").serviceDetails("ScheduledJob", "UpdateScheduledJob", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ScheduledJob/UpdateScheduledJob").method(Method.PUT).requestBuilder(UpdateScheduledJobRequest::builder).basePath("/20220901").appendPathParam("scheduledJobs").appendPathParam(request.getScheduledJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.ScheduledJob.class, UpdateScheduledJobResponse.Builder::scheduledJob).handleResponseHeaderString("etag", UpdateScheduledJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateScheduledJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScheduledJobWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ScheduledJobPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ScheduledJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ScheduledJobClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ScheduledJobClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ScheduledJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ScheduledJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ScheduledJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ScheduledJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ScheduledJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ScheduledJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ScheduledJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ScheduledJobClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ScheduledJobClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ScheduledJobClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

