/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.ScheduledJob;
import com.oracle.bmc.osmanagementhub.model.ScheduledJobSummary;
import com.oracle.bmc.osmanagementhub.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagementhub.responses.ListScheduledJobsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScheduledJobPaginators {
    private final ScheduledJob client;

    public ScheduledJobPaginators(ScheduledJob client) {
        this.client = client;
    }

    public Iterable<ListScheduledJobsResponse> listScheduledJobsResponseIterator(final ListScheduledJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListScheduledJobsRequest.Builder>(){

            @Override
            public ListScheduledJobsRequest.Builder get() {
                return ListScheduledJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScheduledJobsResponse, String>(){

            @Override
            public String apply(ListScheduledJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScheduledJobsRequest.Builder>, ListScheduledJobsRequest>(){

            @Override
            public ListScheduledJobsRequest apply(RequestBuilderAndToken<ListScheduledJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListScheduledJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScheduledJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListScheduledJobsRequest, ListScheduledJobsResponse>(){

            @Override
            public ListScheduledJobsResponse apply(ListScheduledJobsRequest request) {
                return ScheduledJobPaginators.this.client.listScheduledJobs(request);
            }
        });
    }

    public Iterable<ScheduledJobSummary> listScheduledJobsRecordIterator(final ListScheduledJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListScheduledJobsRequest.Builder>(){

            @Override
            public ListScheduledJobsRequest.Builder get() {
                return ListScheduledJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScheduledJobsResponse, String>(){

            @Override
            public String apply(ListScheduledJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScheduledJobsRequest.Builder>, ListScheduledJobsRequest>(){

            @Override
            public ListScheduledJobsRequest apply(RequestBuilderAndToken<ListScheduledJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListScheduledJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScheduledJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListScheduledJobsRequest, ListScheduledJobsResponse>(){

            @Override
            public ListScheduledJobsResponse apply(ListScheduledJobsRequest request) {
                return ScheduledJobPaginators.this.client.listScheduledJobs(request);
            }
        }, (Function)new Function<ListScheduledJobsResponse, List<ScheduledJobSummary>>(){

            @Override
            public List<ScheduledJobSummary> apply(ListScheduledJobsResponse response) {
                return response.getScheduledJobCollection().getItems();
            }
        });
    }
}

