/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.ScheduledJob;
import com.oracle.bmc.osmanagementhub.model.ScheduledJob;
import com.oracle.bmc.osmanagementhub.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagementhub.responses.GetScheduledJobResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ScheduledJobWaiters {
    private final ExecutorService executorService;
    private final ScheduledJob client;

    public ScheduledJobWaiters(ExecutorService executorService, ScheduledJob client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(GetScheduledJobRequest request, ScheduledJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forScheduledJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(GetScheduledJobRequest request, ScheduledJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forScheduledJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(GetScheduledJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ScheduledJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forScheduledJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(BmcGenericWaiter waiter, GetScheduledJobRequest request, ScheduledJob.LifecycleState ... targetStates) {
        final HashSet<ScheduledJob.LifecycleState> targetStatesSet = new HashSet<ScheduledJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetScheduledJobRequest, GetScheduledJobResponse>(){

            @Override
            public GetScheduledJobResponse apply(GetScheduledJobRequest request) {
                return ScheduledJobWaiters.this.client.getScheduledJob(request);
            }
        }, (Predicate)new Predicate<GetScheduledJobResponse>(){

            @Override
            public boolean test(GetScheduledJobResponse response) {
                return targetStatesSet.contains((Object)response.getScheduledJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ScheduledJob.LifecycleState.Deleted)), (Object)request);
    }
}

