/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.osmanagementhub.SoftwareSourceAsync;
import com.oracle.bmc.osmanagementhub.model.EntitlementCollection;
import com.oracle.bmc.osmanagementhub.model.Erratum;
import com.oracle.bmc.osmanagementhub.model.ErratumCollection;
import com.oracle.bmc.osmanagementhub.model.ModuleCollection;
import com.oracle.bmc.osmanagementhub.model.ModuleStream;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamCollection;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamProfile;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamProfileCollection;
import com.oracle.bmc.osmanagementhub.model.PackageGroup;
import com.oracle.bmc.osmanagementhub.model.PackageGroupCollection;
import com.oracle.bmc.osmanagementhub.model.SoftwarePackage;
import com.oracle.bmc.osmanagementhub.model.SoftwarePackageCollection;
import com.oracle.bmc.osmanagementhub.model.SoftwareSource;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceCollection;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceVendorCollection;
import com.oracle.bmc.osmanagementhub.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.ChangeAvailabilityOfSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateEntitlementRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.GetErratumRequest;
import com.oracle.bmc.osmanagementhub.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagementhub.requests.GetPackageGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwarePackageByNameRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.ListAllSoftwarePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListEntitlementsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListErrataRequest;
import com.oracle.bmc.osmanagementhub.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListPackageGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwarePackageSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwarePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwareSourceVendorsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourceModuleStreamsRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourceModulesRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourcePackageGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.ChangeAvailabilityOfSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateEntitlementResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.GetErratumResponse;
import com.oracle.bmc.osmanagementhub.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagementhub.responses.GetPackageGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwarePackageByNameResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.ListAllSoftwarePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListEntitlementsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListErrataResponse;
import com.oracle.bmc.osmanagementhub.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListPackageGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwarePackageSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwarePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwareSourceVendorsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourceModuleStreamsResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourceModulesResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourcePackageGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftwareSourceAsyncClient
extends BaseAsyncClient
implements SoftwareSourceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SOFTWARESOURCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SoftwareSourceAsyncClient.class);

    SoftwareSourceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddPackagesToSoftwareSourceResponse> addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request, AsyncHandler<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddPackagesToSoftwareSourceDetails(), "addPackagesToSoftwareSourceDetails is required");
        return this.clientCall(request, AddPackagesToSoftwareSourceResponse::builder).logger(LOG, "addPackagesToSoftwareSource").serviceDetails("SoftwareSource", "AddPackagesToSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/AddPackagesToSoftwareSource").method(Method.POST).requestBuilder(AddPackagesToSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("addPackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddPackagesToSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddPackagesToSoftwareSourceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAvailabilityOfSoftwareSourcesResponse> changeAvailabilityOfSoftwareSources(ChangeAvailabilityOfSoftwareSourcesRequest request, AsyncHandler<ChangeAvailabilityOfSoftwareSourcesRequest, ChangeAvailabilityOfSoftwareSourcesResponse> handler) {
        Objects.requireNonNull(request.getChangeAvailabilityOfSoftwareSourcesDetails(), "changeAvailabilityOfSoftwareSourcesDetails is required");
        return this.clientCall(request, ChangeAvailabilityOfSoftwareSourcesResponse::builder).logger(LOG, "changeAvailabilityOfSoftwareSources").serviceDetails("SoftwareSource", "ChangeAvailabilityOfSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ChangeAvailabilityOfSoftwareSources").method(Method.POST).requestBuilder(ChangeAvailabilityOfSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam("actions").appendPathParam("changeAvailability").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAvailabilityOfSoftwareSourcesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSoftwareSourceCompartmentResponse> changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request, AsyncHandler<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSoftwareSourceCompartmentDetails(), "changeSoftwareSourceCompartmentDetails is required");
        return this.clientCall(request, ChangeSoftwareSourceCompartmentResponse::builder).logger(LOG, "changeSoftwareSourceCompartment").serviceDetails("SoftwareSource", "ChangeSoftwareSourceCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ChangeSoftwareSourceCompartment").method(Method.POST).requestBuilder(ChangeSoftwareSourceCompartmentRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSoftwareSourceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEntitlementResponse> createEntitlement(CreateEntitlementRequest request, AsyncHandler<CreateEntitlementRequest, CreateEntitlementResponse> handler) {
        Objects.requireNonNull(request.getCreateEntitlementDetails(), "createEntitlementDetails is required");
        return this.clientCall(request, CreateEntitlementResponse::builder).logger(LOG, "createEntitlement").serviceDetails("SoftwareSource", "CreateEntitlement", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/CreateEntitlement").method(Method.POST).requestBuilder(CreateEntitlementRequest::builder).basePath("/20220901").appendPathParam("entitlements").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateEntitlementResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSoftwareSourceResponse> createSoftwareSource(CreateSoftwareSourceRequest request, AsyncHandler<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse> handler) {
        Objects.requireNonNull(request.getCreateSoftwareSourceDetails(), "createSoftwareSourceDetails is required");
        return this.clientCall(request, CreateSoftwareSourceResponse::builder).logger(LOG, "createSoftwareSource").serviceDetails("SoftwareSource", "CreateSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/CreateSoftwareSource").method(Method.POST).requestBuilder(CreateSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SoftwareSource.class, CreateSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", CreateSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateSoftwareSourceResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateSoftwareSourceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSoftwareSourceResponse> deleteSoftwareSource(DeleteSoftwareSourceRequest request, AsyncHandler<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSoftwareSourceResponse::builder).logger(LOG, "deleteSoftwareSource").serviceDetails("SoftwareSource", "DeleteSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/DeleteSoftwareSource").method(Method.DELETE).requestBuilder(DeleteSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSoftwareSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetErratumResponse> getErratum(GetErratumRequest request, AsyncHandler<GetErratumRequest, GetErratumResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetErratumResponse::builder).logger(LOG, "getErratum").serviceDetails("SoftwareSource", "GetErratum", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Erratum/GetErratum").method(Method.GET).requestBuilder(GetErratumRequest::builder).basePath("/20220901").appendPathParam("errata").appendPathParam(request.getName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Erratum.class, GetErratumResponse.Builder::erratum).handleResponseHeaderString("opc-request-id", GetErratumResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModuleStreamResponse> getModuleStream(GetModuleStreamRequest request, AsyncHandler<GetModuleStreamRequest, GetModuleStreamResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getModuleName(), (String)"moduleName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStreamName(), "streamName is required");
        return this.clientCall(request, GetModuleStreamResponse::builder).logger(LOG, "getModuleStream").serviceDetails("SoftwareSource", "GetModuleStream", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ModuleStream/GetModuleStream").method(Method.GET).requestBuilder(GetModuleStreamRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreams").appendPathParam(request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModuleStream.class, GetModuleStreamResponse.Builder::moduleStream).handleResponseHeaderString("opc-request-id", GetModuleStreamResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModuleStreamProfileResponse> getModuleStreamProfile(GetModuleStreamProfileRequest request, AsyncHandler<GetModuleStreamProfileRequest, GetModuleStreamProfileResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProfileName(), (String)"profileName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        Objects.requireNonNull(request.getStreamName(), "streamName is required");
        return this.clientCall(request, GetModuleStreamProfileResponse::builder).logger(LOG, "getModuleStreamProfile").serviceDetails("SoftwareSource", "GetModuleStreamProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ModuleStreamProfile/GetModuleStreamProfile").method(Method.GET).requestBuilder(GetModuleStreamProfileRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreamProfiles").appendPathParam(request.getProfileName()).appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModuleStreamProfile.class, GetModuleStreamProfileResponse.Builder::moduleStreamProfile).handleResponseHeaderString("opc-request-id", GetModuleStreamProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPackageGroupResponse> getPackageGroup(GetPackageGroupRequest request, AsyncHandler<GetPackageGroupRequest, GetPackageGroupResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageGroupId(), (String)"packageGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPackageGroupResponse::builder).logger(LOG, "getPackageGroup").serviceDetails("SoftwareSource", "GetPackageGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/PackageGroup/GetPackageGroup").method(Method.GET).requestBuilder(GetPackageGroupRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("packageGroups").appendPathParam(request.getPackageGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PackageGroup.class, GetPackageGroupResponse.Builder::packageGroup).handleResponseHeaderString("opc-request-id", GetPackageGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSoftwarePackageResponse> getSoftwarePackage(GetSoftwarePackageRequest request, AsyncHandler<GetSoftwarePackageRequest, GetSoftwarePackageResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSoftwarePackageResponse::builder).logger(LOG, "getSoftwarePackage").serviceDetails("SoftwareSource", "GetSoftwarePackage", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/GetSoftwarePackage").method(Method.GET).requestBuilder(GetSoftwarePackageRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwarePackage.class, GetSoftwarePackageResponse.Builder::softwarePackage).handleResponseHeaderString("opc-request-id", GetSoftwarePackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSoftwarePackageByNameResponse> getSoftwarePackageByName(GetSoftwarePackageByNameRequest request, AsyncHandler<GetSoftwarePackageByNameRequest, GetSoftwarePackageByNameResponse> handler) {
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSoftwarePackageByNameResponse::builder).logger(LOG, "getSoftwarePackageByName").serviceDetails("SoftwareSource", "GetSoftwarePackageByName", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/GetSoftwarePackageByName").method(Method.GET).requestBuilder(GetSoftwarePackageByNameRequest::builder).basePath("/20220901").appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwarePackage.class, GetSoftwarePackageByNameResponse.Builder::softwarePackage).handleResponseHeaderString("opc-request-id", GetSoftwarePackageByNameResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSoftwareSourceResponse> getSoftwareSource(GetSoftwareSourceRequest request, AsyncHandler<GetSoftwareSourceRequest, GetSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSoftwareSourceResponse::builder).logger(LOG, "getSoftwareSource").serviceDetails("SoftwareSource", "GetSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/GetSoftwareSource").method(Method.GET).requestBuilder(GetSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwareSource.class, GetSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", GetSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetSoftwareSourceResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAllSoftwarePackagesResponse> listAllSoftwarePackages(ListAllSoftwarePackagesRequest request, AsyncHandler<ListAllSoftwarePackagesRequest, ListAllSoftwarePackagesResponse> handler) {
        return this.clientCall(request, ListAllSoftwarePackagesResponse::builder).logger(LOG, "listAllSoftwarePackages").serviceDetails("SoftwareSource", "ListAllSoftwarePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListAllSoftwarePackages").method(Method.GET).requestBuilder(ListAllSoftwarePackagesRequest::builder).basePath("/20220901").appendPathParam("softwarePackages").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("version", (Object)request.getVersion()).appendEnumQueryParam("architecture", (BmcEnum)request.getArchitecture()).appendQueryParam("isLatest", (Object)request.getIsLatest()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwarePackageCollection.class, ListAllSoftwarePackagesResponse.Builder::softwarePackageCollection).handleResponseHeaderString("opc-request-id", ListAllSoftwarePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAllSoftwarePackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListEntitlementsResponse> listEntitlements(ListEntitlementsRequest request, AsyncHandler<ListEntitlementsRequest, ListEntitlementsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEntitlementsResponse::builder).logger(LOG, "listEntitlements").serviceDetails("SoftwareSource", "ListEntitlements", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListEntitlements").method(Method.GET).requestBuilder(ListEntitlementsRequest::builder).basePath("/20220901").appendPathParam("entitlements").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("csi", (Object)request.getCsi()).appendEnumQueryParam("vendorName", (BmcEnum)request.getVendorName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EntitlementCollection.class, ListEntitlementsResponse.Builder::entitlementCollection).handleResponseHeaderString("opc-request-id", ListEntitlementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEntitlementsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListErrataResponse> listErrata(ListErrataRequest request, AsyncHandler<ListErrataRequest, ListErrataResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListErrataResponse::builder).logger(LOG, "listErrata").serviceDetails("SoftwareSource", "ListErrata", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Erratum/ListErrata").method(Method.GET).requestBuilder(ListErrataRequest::builder).basePath("/20220901").appendPathParam("errata").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("classificationType", request.getClassificationType(), CollectionFormatType.Multi).appendListQueryParam("advisoryType", request.getAdvisoryType(), CollectionFormatType.Multi).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendListQueryParam("advisorySeverity", request.getAdvisorySeverity(), CollectionFormatType.Multi).appendQueryParam("timeIssueDateStart", (Object)request.getTimeIssueDateStart()).appendQueryParam("timeIssueDateEnd", (Object)request.getTimeIssueDateEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ErratumCollection.class, ListErrataResponse.Builder::erratumCollection).handleResponseHeaderString("opc-request-id", ListErrataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListErrataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModuleStreamProfilesResponse> listModuleStreamProfiles(ListModuleStreamProfilesRequest request, AsyncHandler<ListModuleStreamProfilesRequest, ListModuleStreamProfilesResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListModuleStreamProfilesResponse::builder).logger(LOG, "listModuleStreamProfiles").serviceDetails("SoftwareSource", "ListModuleStreamProfiles", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListModuleStreamProfiles").method(Method.GET).requestBuilder(ListModuleStreamProfilesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreamProfiles").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModuleStreamProfileCollection.class, ListModuleStreamProfilesResponse.Builder::moduleStreamProfileCollection).handleResponseHeaderString("opc-request-id", ListModuleStreamProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamProfilesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModuleStreamsResponse> listModuleStreams(ListModuleStreamsRequest request, AsyncHandler<ListModuleStreamsRequest, ListModuleStreamsResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListModuleStreamsResponse::builder).logger(LOG, "listModuleStreams").serviceDetails("SoftwareSource", "ListModuleStreams", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListModuleStreams").method(Method.GET).requestBuilder(ListModuleStreamsRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreams").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("isLatest", (Object)request.getIsLatest()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("moduleNameContains", (Object)request.getModuleNameContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModuleStreamCollection.class, ListModuleStreamsResponse.Builder::moduleStreamCollection).handleResponseHeaderString("opc-request-id", ListModuleStreamsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPackageGroupsResponse> listPackageGroups(ListPackageGroupsRequest request, AsyncHandler<ListPackageGroupsRequest, ListPackageGroupsResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPackageGroupsResponse::builder).logger(LOG, "listPackageGroups").serviceDetails("SoftwareSource", "ListPackageGroups", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListPackageGroups").method(Method.GET).requestBuilder(ListPackageGroupsRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("packageGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("groupType", request.getGroupType(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PackageGroupCollection.class, ListPackageGroupsResponse.Builder::packageGroupCollection).handleResponseHeaderString("opc-request-id", ListPackageGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPackageGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSoftwarePackageSoftwareSourcesResponse> listSoftwarePackageSoftwareSources(ListSoftwarePackageSoftwareSourcesRequest request, AsyncHandler<ListSoftwarePackageSoftwareSourcesRequest, ListSoftwarePackageSoftwareSourcesResponse> handler) {
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSoftwarePackageSoftwareSourcesResponse::builder).logger(LOG, "listSoftwarePackageSoftwareSources").serviceDetails("SoftwareSource", "ListSoftwarePackageSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwarePackageSoftwareSources").method(Method.GET).requestBuilder(ListSoftwarePackageSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).appendPathParam("softwareSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("softwareSourceType", request.getSoftwareSourceType(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendListQueryParam("archType", request.getArchType(), CollectionFormatType.Multi).appendListQueryParam("availability", request.getAvailability(), CollectionFormatType.Multi).appendListQueryParam("availabilityAtOci", request.getAvailabilityAtOci(), CollectionFormatType.Multi).appendListQueryParam("availabilityAnywhere", request.getAvailabilityAnywhere(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwareSourceCollection.class, ListSoftwarePackageSoftwareSourcesResponse.Builder::softwareSourceCollection).handleResponseHeaderString("opc-request-id", ListSoftwarePackageSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwarePackageSoftwareSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSoftwarePackagesResponse> listSoftwarePackages(ListSoftwarePackagesRequest request, AsyncHandler<ListSoftwarePackagesRequest, ListSoftwarePackagesResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSoftwarePackagesResponse::builder).logger(LOG, "listSoftwarePackages").serviceDetails("SoftwareSource", "ListSoftwarePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwarePackages").method(Method.GET).requestBuilder(ListSoftwarePackagesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("softwarePackages").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("isLatest", (Object)request.getIsLatest()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwarePackageCollection.class, ListSoftwarePackagesResponse.Builder::softwarePackageCollection).handleResponseHeaderString("opc-request-id", ListSoftwarePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwarePackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSoftwareSourceVendorsResponse> listSoftwareSourceVendors(ListSoftwareSourceVendorsRequest request, AsyncHandler<ListSoftwareSourceVendorsRequest, ListSoftwareSourceVendorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSoftwareSourceVendorsResponse::builder).logger(LOG, "listSoftwareSourceVendors").serviceDetails("SoftwareSource", "ListSoftwareSourceVendors", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwareSourceVendors").method(Method.GET).requestBuilder(ListSoftwareSourceVendorsRequest::builder).basePath("/20220901").appendPathParam("softwareSourceVendors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwareSourceVendorCollection.class, ListSoftwareSourceVendorsResponse.Builder::softwareSourceVendorCollection).handleResponseHeaderString("opc-request-id", ListSoftwareSourceVendorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSoftwareSourcesResponse> listSoftwareSources(ListSoftwareSourcesRequest request, AsyncHandler<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse> handler) {
        return this.clientCall(request, ListSoftwareSourcesResponse::builder).logger(LOG, "listSoftwareSources").serviceDetails("SoftwareSource", "ListSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwareSources").method(Method.GET).requestBuilder(ListSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("softwareSourceId", (Object)request.getSoftwareSourceId()).appendListQueryParam("softwareSourceType", request.getSoftwareSourceType(), CollectionFormatType.Multi).appendEnumQueryParam("vendorName", (BmcEnum)request.getVendorName()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendListQueryParam("archType", request.getArchType(), CollectionFormatType.Multi).appendListQueryParam("availability", request.getAvailability(), CollectionFormatType.Multi).appendListQueryParam("availabilityAtOci", request.getAvailabilityAtOci(), CollectionFormatType.Multi).appendListQueryParam("availabilityAnywhere", request.getAvailabilityAnywhere(), CollectionFormatType.Multi).appendQueryParam("isMandatoryForAutonomousLinux", (Object)request.getIsMandatoryForAutonomousLinux()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendListQueryParam("displayNameNotEqualTo", request.getDisplayNameNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SoftwareSourceCollection.class, ListSoftwareSourcesResponse.Builder::softwareSourceCollection).handleResponseHeaderString("opc-request-id", ListSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwareSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SearchSoftwareSourceModuleStreamsResponse> searchSoftwareSourceModuleStreams(SearchSoftwareSourceModuleStreamsRequest request, AsyncHandler<SearchSoftwareSourceModuleStreamsRequest, SearchSoftwareSourceModuleStreamsResponse> handler) {
        Objects.requireNonNull(request.getSearchSoftwareSourceModuleStreamsDetails(), "searchSoftwareSourceModuleStreamsDetails is required");
        return this.clientCall(request, SearchSoftwareSourceModuleStreamsResponse::builder).logger(LOG, "searchSoftwareSourceModuleStreams").serviceDetails("SoftwareSource", "SearchSoftwareSourceModuleStreams", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/SearchSoftwareSourceModuleStreams").method(Method.POST).requestBuilder(SearchSoftwareSourceModuleStreamsRequest::builder).basePath("/20220901").appendPathParam("softwareSourceModuleStreams").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ModuleStreamCollection.class, SearchSoftwareSourceModuleStreamsResponse.Builder::moduleStreamCollection).handleResponseHeaderString("opc-request-id", SearchSoftwareSourceModuleStreamsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwareSourceModuleStreamsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SearchSoftwareSourceModulesResponse> searchSoftwareSourceModules(SearchSoftwareSourceModulesRequest request, AsyncHandler<SearchSoftwareSourceModulesRequest, SearchSoftwareSourceModulesResponse> handler) {
        Objects.requireNonNull(request.getSearchSoftwareSourceModulesDetails(), "searchSoftwareSourceModulesDetails is required");
        return this.clientCall(request, SearchSoftwareSourceModulesResponse::builder).logger(LOG, "searchSoftwareSourceModules").serviceDetails("SoftwareSource", "SearchSoftwareSourceModules", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/SearchSoftwareSourceModules").method(Method.POST).requestBuilder(SearchSoftwareSourceModulesRequest::builder).basePath("/20220901").appendPathParam("softwareSourceModules").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ModuleCollection.class, SearchSoftwareSourceModulesResponse.Builder::moduleCollection).handleResponseHeaderString("opc-request-id", SearchSoftwareSourceModulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwareSourceModulesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SearchSoftwareSourcePackageGroupsResponse> searchSoftwareSourcePackageGroups(SearchSoftwareSourcePackageGroupsRequest request, AsyncHandler<SearchSoftwareSourcePackageGroupsRequest, SearchSoftwareSourcePackageGroupsResponse> handler) {
        Objects.requireNonNull(request.getSearchSoftwareSourcePackageGroupsDetails(), "searchSoftwareSourcePackageGroupsDetails is required");
        return this.clientCall(request, SearchSoftwareSourcePackageGroupsResponse::builder).logger(LOG, "searchSoftwareSourcePackageGroups").serviceDetails("SoftwareSource", "SearchSoftwareSourcePackageGroups", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/SearchSoftwareSourcePackageGroups").method(Method.POST).requestBuilder(SearchSoftwareSourcePackageGroupsRequest::builder).basePath("/20220901").appendPathParam("softwareSourcePackageGroups").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PackageGroupCollection.class, SearchSoftwareSourcePackageGroupsResponse.Builder::packageGroupCollection).handleResponseHeaderString("opc-request-id", SearchSoftwareSourcePackageGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwareSourcePackageGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateSoftwareSourceResponse> updateSoftwareSource(UpdateSoftwareSourceRequest request, AsyncHandler<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse> handler) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSoftwareSourceDetails(), "updateSoftwareSourceDetails is required");
        return this.clientCall(request, UpdateSoftwareSourceResponse::builder).logger(LOG, "updateSoftwareSource").serviceDetails("SoftwareSource", "UpdateSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/UpdateSoftwareSource").method(Method.PUT).requestBuilder(UpdateSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(SoftwareSource.class, UpdateSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", UpdateSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateSoftwareSourceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SoftwareSourceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SoftwareSourceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SoftwareSourceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SoftwareSourceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SoftwareSourceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SoftwareSourceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SoftwareSourceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SoftwareSourceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SoftwareSourceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SoftwareSourceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SoftwareSourceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

