/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.osmanagementhub.SoftwareSource;
import com.oracle.bmc.osmanagementhub.SoftwareSourcePaginators;
import com.oracle.bmc.osmanagementhub.SoftwareSourceWaiters;
import com.oracle.bmc.osmanagementhub.model.EntitlementCollection;
import com.oracle.bmc.osmanagementhub.model.Erratum;
import com.oracle.bmc.osmanagementhub.model.ErratumCollection;
import com.oracle.bmc.osmanagementhub.model.ModuleCollection;
import com.oracle.bmc.osmanagementhub.model.ModuleStream;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamCollection;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamProfile;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamProfileCollection;
import com.oracle.bmc.osmanagementhub.model.PackageGroup;
import com.oracle.bmc.osmanagementhub.model.PackageGroupCollection;
import com.oracle.bmc.osmanagementhub.model.SoftwarePackage;
import com.oracle.bmc.osmanagementhub.model.SoftwarePackageCollection;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceCollection;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceVendorCollection;
import com.oracle.bmc.osmanagementhub.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.ChangeAvailabilityOfSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateEntitlementRequest;
import com.oracle.bmc.osmanagementhub.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.GetErratumRequest;
import com.oracle.bmc.osmanagementhub.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagementhub.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagementhub.requests.GetPackageGroupRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwarePackageByNameRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.requests.ListAllSoftwarePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListEntitlementsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListErrataRequest;
import com.oracle.bmc.osmanagementhub.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListPackageGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwarePackageSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwarePackagesRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwareSourceVendorsRequest;
import com.oracle.bmc.osmanagementhub.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourceModuleStreamsRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourceModulesRequest;
import com.oracle.bmc.osmanagementhub.requests.SearchSoftwareSourcePackageGroupsRequest;
import com.oracle.bmc.osmanagementhub.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.ChangeAvailabilityOfSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateEntitlementResponse;
import com.oracle.bmc.osmanagementhub.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.GetErratumResponse;
import com.oracle.bmc.osmanagementhub.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagementhub.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagementhub.responses.GetPackageGroupResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwarePackageByNameResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagementhub.responses.ListAllSoftwarePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListEntitlementsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListErrataResponse;
import com.oracle.bmc.osmanagementhub.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListPackageGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwarePackageSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwarePackagesResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwareSourceVendorsResponse;
import com.oracle.bmc.osmanagementhub.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourceModuleStreamsResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourceModulesResponse;
import com.oracle.bmc.osmanagementhub.responses.SearchSoftwareSourcePackageGroupsResponse;
import com.oracle.bmc.osmanagementhub.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftwareSourceClient
extends BaseSyncClient
implements SoftwareSource {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SOFTWARESOURCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://osmh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SoftwareSourceClient.class);
    private final SoftwareSourceWaiters waiters;
    private final SoftwareSourcePaginators paginators;

    SoftwareSourceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("SoftwareSource-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new SoftwareSourceWaiters(executorService, this);
        this.paginators = new SoftwareSourcePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddPackagesToSoftwareSourceResponse addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddPackagesToSoftwareSourceDetails(), "addPackagesToSoftwareSourceDetails is required");
        return (AddPackagesToSoftwareSourceResponse)this.clientCall(request, AddPackagesToSoftwareSourceResponse::builder).logger(LOG, "addPackagesToSoftwareSource").serviceDetails("SoftwareSource", "AddPackagesToSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/AddPackagesToSoftwareSource").method(Method.POST).requestBuilder(AddPackagesToSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("addPackages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", AddPackagesToSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddPackagesToSoftwareSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeAvailabilityOfSoftwareSourcesResponse changeAvailabilityOfSoftwareSources(ChangeAvailabilityOfSoftwareSourcesRequest request) {
        Objects.requireNonNull(request.getChangeAvailabilityOfSoftwareSourcesDetails(), "changeAvailabilityOfSoftwareSourcesDetails is required");
        return (ChangeAvailabilityOfSoftwareSourcesResponse)this.clientCall(request, ChangeAvailabilityOfSoftwareSourcesResponse::builder).logger(LOG, "changeAvailabilityOfSoftwareSources").serviceDetails("SoftwareSource", "ChangeAvailabilityOfSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ChangeAvailabilityOfSoftwareSources").method(Method.POST).requestBuilder(ChangeAvailabilityOfSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam("actions").appendPathParam("changeAvailability").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeAvailabilityOfSoftwareSourcesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSoftwareSourceCompartmentResponse changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSoftwareSourceCompartmentDetails(), "changeSoftwareSourceCompartmentDetails is required");
        return (ChangeSoftwareSourceCompartmentResponse)this.clientCall(request, ChangeSoftwareSourceCompartmentResponse::builder).logger(LOG, "changeSoftwareSourceCompartment").serviceDetails("SoftwareSource", "ChangeSoftwareSourceCompartment", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ChangeSoftwareSourceCompartment").method(Method.POST).requestBuilder(ChangeSoftwareSourceCompartmentRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeSoftwareSourceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateEntitlementResponse createEntitlement(CreateEntitlementRequest request) {
        Objects.requireNonNull(request.getCreateEntitlementDetails(), "createEntitlementDetails is required");
        return (CreateEntitlementResponse)this.clientCall(request, CreateEntitlementResponse::builder).logger(LOG, "createEntitlement").serviceDetails("SoftwareSource", "CreateEntitlement", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/CreateEntitlement").method(Method.POST).requestBuilder(CreateEntitlementRequest::builder).basePath("/20220901").appendPathParam("entitlements").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", CreateEntitlementResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSoftwareSourceResponse createSoftwareSource(CreateSoftwareSourceRequest request) {
        Objects.requireNonNull(request.getCreateSoftwareSourceDetails(), "createSoftwareSourceDetails is required");
        return (CreateSoftwareSourceResponse)this.clientCall(request, CreateSoftwareSourceResponse::builder).logger(LOG, "createSoftwareSource").serviceDetails("SoftwareSource", "CreateSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/CreateSoftwareSource").method(Method.POST).requestBuilder(CreateSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.SoftwareSource.class, CreateSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", CreateSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateSoftwareSourceResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateSoftwareSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteSoftwareSourceResponse deleteSoftwareSource(DeleteSoftwareSourceRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return (DeleteSoftwareSourceResponse)this.clientCall(request, DeleteSoftwareSourceResponse::builder).logger(LOG, "deleteSoftwareSource").serviceDetails("SoftwareSource", "DeleteSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/DeleteSoftwareSource").method(Method.DELETE).requestBuilder(DeleteSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteSoftwareSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetErratumResponse getErratum(GetErratumRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (GetErratumResponse)this.clientCall(request, GetErratumResponse::builder).logger(LOG, "getErratum").serviceDetails("SoftwareSource", "GetErratum", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Erratum/GetErratum").method(Method.GET).requestBuilder(GetErratumRequest::builder).basePath("/20220901").appendPathParam("errata").appendPathParam(request.getName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Erratum.class, GetErratumResponse.Builder::erratum).handleResponseHeaderString("opc-request-id", GetErratumResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetModuleStreamResponse getModuleStream(GetModuleStreamRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getModuleName(), (String)"moduleName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStreamName(), "streamName is required");
        return (GetModuleStreamResponse)this.clientCall(request, GetModuleStreamResponse::builder).logger(LOG, "getModuleStream").serviceDetails("SoftwareSource", "GetModuleStream", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ModuleStream/GetModuleStream").method(Method.GET).requestBuilder(GetModuleStreamRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreams").appendPathParam(request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ModuleStream.class, GetModuleStreamResponse.Builder::moduleStream).handleResponseHeaderString("opc-request-id", GetModuleStreamResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetModuleStreamProfileResponse getModuleStreamProfile(GetModuleStreamProfileRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProfileName(), (String)"profileName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModuleName(), "moduleName is required");
        Objects.requireNonNull(request.getStreamName(), "streamName is required");
        return (GetModuleStreamProfileResponse)this.clientCall(request, GetModuleStreamProfileResponse::builder).logger(LOG, "getModuleStreamProfile").serviceDetails("SoftwareSource", "GetModuleStreamProfile", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/ModuleStreamProfile/GetModuleStreamProfile").method(Method.GET).requestBuilder(GetModuleStreamProfileRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreamProfiles").appendPathParam(request.getProfileName()).appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ModuleStreamProfile.class, GetModuleStreamProfileResponse.Builder::moduleStreamProfile).handleResponseHeaderString("opc-request-id", GetModuleStreamProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPackageGroupResponse getPackageGroup(GetPackageGroupRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageGroupId(), (String)"packageGroupId must not be blank", (Object[])new Object[0]);
        return (GetPackageGroupResponse)this.clientCall(request, GetPackageGroupResponse::builder).logger(LOG, "getPackageGroup").serviceDetails("SoftwareSource", "GetPackageGroup", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/PackageGroup/GetPackageGroup").method(Method.GET).requestBuilder(GetPackageGroupRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("packageGroups").appendPathParam(request.getPackageGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PackageGroup.class, GetPackageGroupResponse.Builder::packageGroup).handleResponseHeaderString("opc-request-id", GetPackageGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSoftwarePackageResponse getSoftwarePackage(GetSoftwarePackageRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        return (GetSoftwarePackageResponse)this.clientCall(request, GetSoftwarePackageResponse::builder).logger(LOG, "getSoftwarePackage").serviceDetails("SoftwareSource", "GetSoftwarePackage", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/GetSoftwarePackage").method(Method.GET).requestBuilder(GetSoftwarePackageRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwarePackage.class, GetSoftwarePackageResponse.Builder::softwarePackage).handleResponseHeaderString("opc-request-id", GetSoftwarePackageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSoftwarePackageByNameResponse getSoftwarePackageByName(GetSoftwarePackageByNameRequest request) {
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        return (GetSoftwarePackageByNameResponse)this.clientCall(request, GetSoftwarePackageByNameResponse::builder).logger(LOG, "getSoftwarePackageByName").serviceDetails("SoftwareSource", "GetSoftwarePackageByName", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/GetSoftwarePackageByName").method(Method.GET).requestBuilder(GetSoftwarePackageByNameRequest::builder).basePath("/20220901").appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwarePackage.class, GetSoftwarePackageByNameResponse.Builder::softwarePackage).handleResponseHeaderString("opc-request-id", GetSoftwarePackageByNameResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSoftwareSourceResponse getSoftwareSource(GetSoftwareSourceRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return (GetSoftwareSourceResponse)this.clientCall(request, GetSoftwareSourceResponse::builder).logger(LOG, "getSoftwareSource").serviceDetails("SoftwareSource", "GetSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/GetSoftwareSource").method(Method.GET).requestBuilder(GetSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.osmanagementhub.model.SoftwareSource.class, GetSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", GetSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetSoftwareSourceResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListAllSoftwarePackagesResponse listAllSoftwarePackages(ListAllSoftwarePackagesRequest request) {
        return (ListAllSoftwarePackagesResponse)this.clientCall(request, ListAllSoftwarePackagesResponse::builder).logger(LOG, "listAllSoftwarePackages").serviceDetails("SoftwareSource", "ListAllSoftwarePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListAllSoftwarePackages").method(Method.GET).requestBuilder(ListAllSoftwarePackagesRequest::builder).basePath("/20220901").appendPathParam("softwarePackages").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("version", (Object)request.getVersion()).appendEnumQueryParam("architecture", (BmcEnum)request.getArchitecture()).appendQueryParam("isLatest", (Object)request.getIsLatest()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwarePackageCollection.class, ListAllSoftwarePackagesResponse.Builder::softwarePackageCollection).handleResponseHeaderString("opc-request-id", ListAllSoftwarePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAllSoftwarePackagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListEntitlementsResponse listEntitlements(ListEntitlementsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEntitlementsResponse)this.clientCall(request, ListEntitlementsResponse::builder).logger(LOG, "listEntitlements").serviceDetails("SoftwareSource", "ListEntitlements", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListEntitlements").method(Method.GET).requestBuilder(ListEntitlementsRequest::builder).basePath("/20220901").appendPathParam("entitlements").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("csi", (Object)request.getCsi()).appendEnumQueryParam("vendorName", (BmcEnum)request.getVendorName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(EntitlementCollection.class, ListEntitlementsResponse.Builder::entitlementCollection).handleResponseHeaderString("opc-request-id", ListEntitlementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEntitlementsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListErrataResponse listErrata(ListErrataRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListErrataResponse)this.clientCall(request, ListErrataResponse::builder).logger(LOG, "listErrata").serviceDetails("SoftwareSource", "ListErrata", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/Erratum/ListErrata").method(Method.GET).requestBuilder(ListErrataRequest::builder).basePath("/20220901").appendPathParam("errata").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("classificationType", request.getClassificationType(), CollectionFormatType.Multi).appendListQueryParam("advisoryType", request.getAdvisoryType(), CollectionFormatType.Multi).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendListQueryParam("advisorySeverity", request.getAdvisorySeverity(), CollectionFormatType.Multi).appendQueryParam("timeIssueDateStart", (Object)request.getTimeIssueDateStart()).appendQueryParam("timeIssueDateEnd", (Object)request.getTimeIssueDateEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ErratumCollection.class, ListErrataResponse.Builder::erratumCollection).handleResponseHeaderString("opc-request-id", ListErrataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListErrataResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListModuleStreamProfilesResponse listModuleStreamProfiles(ListModuleStreamProfilesRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return (ListModuleStreamProfilesResponse)this.clientCall(request, ListModuleStreamProfilesResponse::builder).logger(LOG, "listModuleStreamProfiles").serviceDetails("SoftwareSource", "ListModuleStreamProfiles", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListModuleStreamProfiles").method(Method.GET).requestBuilder(ListModuleStreamProfilesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreamProfiles").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("streamName", (Object)request.getStreamName()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ModuleStreamProfileCollection.class, ListModuleStreamProfilesResponse.Builder::moduleStreamProfileCollection).handleResponseHeaderString("opc-request-id", ListModuleStreamProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamProfilesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListModuleStreamsResponse listModuleStreams(ListModuleStreamsRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return (ListModuleStreamsResponse)this.clientCall(request, ListModuleStreamsResponse::builder).logger(LOG, "listModuleStreams").serviceDetails("SoftwareSource", "ListModuleStreams", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListModuleStreams").method(Method.GET).requestBuilder(ListModuleStreamsRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("moduleStreams").appendQueryParam("moduleName", (Object)request.getModuleName()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("isLatest", (Object)request.getIsLatest()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("moduleNameContains", (Object)request.getModuleNameContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ModuleStreamCollection.class, ListModuleStreamsResponse.Builder::moduleStreamCollection).handleResponseHeaderString("opc-request-id", ListModuleStreamsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModuleStreamsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPackageGroupsResponse listPackageGroups(ListPackageGroupsRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return (ListPackageGroupsResponse)this.clientCall(request, ListPackageGroupsResponse::builder).logger(LOG, "listPackageGroups").serviceDetails("SoftwareSource", "ListPackageGroups", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListPackageGroups").method(Method.GET).requestBuilder(ListPackageGroupsRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("packageGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendListQueryParam("groupType", request.getGroupType(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PackageGroupCollection.class, ListPackageGroupsResponse.Builder::packageGroupCollection).handleResponseHeaderString("opc-request-id", ListPackageGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPackageGroupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSoftwarePackageSoftwareSourcesResponse listSoftwarePackageSoftwareSources(ListSoftwarePackageSoftwareSourcesRequest request) {
        Validate.notBlank((String)request.getSoftwarePackageName(), (String)"softwarePackageName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSoftwarePackageSoftwareSourcesResponse)this.clientCall(request, ListSoftwarePackageSoftwareSourcesResponse::builder).logger(LOG, "listSoftwarePackageSoftwareSources").serviceDetails("SoftwareSource", "ListSoftwarePackageSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwarePackageSoftwareSources").method(Method.GET).requestBuilder(ListSoftwarePackageSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("softwarePackages").appendPathParam(request.getSoftwarePackageName()).appendPathParam("softwareSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("softwareSourceType", request.getSoftwareSourceType(), CollectionFormatType.Multi).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendListQueryParam("archType", request.getArchType(), CollectionFormatType.Multi).appendListQueryParam("availability", request.getAvailability(), CollectionFormatType.Multi).appendListQueryParam("availabilityAtOci", request.getAvailabilityAtOci(), CollectionFormatType.Multi).appendListQueryParam("availabilityAnywhere", request.getAvailabilityAnywhere(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwareSourceCollection.class, ListSoftwarePackageSoftwareSourcesResponse.Builder::softwareSourceCollection).handleResponseHeaderString("opc-request-id", ListSoftwarePackageSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwarePackageSoftwareSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSoftwarePackagesResponse listSoftwarePackages(ListSoftwarePackagesRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        return (ListSoftwarePackagesResponse)this.clientCall(request, ListSoftwarePackagesResponse::builder).logger(LOG, "listSoftwarePackages").serviceDetails("SoftwareSource", "ListSoftwarePackages", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwarePackages").method(Method.GET).requestBuilder(ListSoftwarePackagesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).appendPathParam("softwarePackages").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("isLatest", (Object)request.getIsLatest()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwarePackageCollection.class, ListSoftwarePackagesResponse.Builder::softwarePackageCollection).handleResponseHeaderString("opc-request-id", ListSoftwarePackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwarePackagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSoftwareSourceVendorsResponse listSoftwareSourceVendors(ListSoftwareSourceVendorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSoftwareSourceVendorsResponse)this.clientCall(request, ListSoftwareSourceVendorsResponse::builder).logger(LOG, "listSoftwareSourceVendors").serviceDetails("SoftwareSource", "ListSoftwareSourceVendors", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwareSourceVendors").method(Method.GET).requestBuilder(ListSoftwareSourceVendorsRequest::builder).basePath("/20220901").appendPathParam("softwareSourceVendors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwareSourceVendorCollection.class, ListSoftwareSourceVendorsResponse.Builder::softwareSourceVendorCollection).handleResponseHeaderString("opc-request-id", ListSoftwareSourceVendorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSoftwareSourcesResponse listSoftwareSources(ListSoftwareSourcesRequest request) {
        return (ListSoftwareSourcesResponse)this.clientCall(request, ListSoftwareSourcesResponse::builder).logger(LOG, "listSoftwareSources").serviceDetails("SoftwareSource", "ListSoftwareSources", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/ListSoftwareSources").method(Method.GET).requestBuilder(ListSoftwareSourcesRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("softwareSourceId", (Object)request.getSoftwareSourceId()).appendListQueryParam("softwareSourceType", request.getSoftwareSourceType(), CollectionFormatType.Multi).appendEnumQueryParam("vendorName", (BmcEnum)request.getVendorName()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendListQueryParam("archType", request.getArchType(), CollectionFormatType.Multi).appendListQueryParam("availability", request.getAvailability(), CollectionFormatType.Multi).appendListQueryParam("availabilityAtOci", request.getAvailabilityAtOci(), CollectionFormatType.Multi).appendListQueryParam("availabilityAnywhere", request.getAvailabilityAnywhere(), CollectionFormatType.Multi).appendQueryParam("isMandatoryForAutonomousLinux", (Object)request.getIsMandatoryForAutonomousLinux()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendListQueryParam("displayNameNotEqualTo", request.getDisplayNameNotEqualTo(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SoftwareSourceCollection.class, ListSoftwareSourcesResponse.Builder::softwareSourceCollection).handleResponseHeaderString("opc-request-id", ListSoftwareSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSoftwareSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SearchSoftwareSourceModuleStreamsResponse searchSoftwareSourceModuleStreams(SearchSoftwareSourceModuleStreamsRequest request) {
        Objects.requireNonNull(request.getSearchSoftwareSourceModuleStreamsDetails(), "searchSoftwareSourceModuleStreamsDetails is required");
        return (SearchSoftwareSourceModuleStreamsResponse)this.clientCall(request, SearchSoftwareSourceModuleStreamsResponse::builder).logger(LOG, "searchSoftwareSourceModuleStreams").serviceDetails("SoftwareSource", "SearchSoftwareSourceModuleStreams", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/SearchSoftwareSourceModuleStreams").method(Method.POST).requestBuilder(SearchSoftwareSourceModuleStreamsRequest::builder).basePath("/20220901").appendPathParam("softwareSourceModuleStreams").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ModuleStreamCollection.class, SearchSoftwareSourceModuleStreamsResponse.Builder::moduleStreamCollection).handleResponseHeaderString("opc-request-id", SearchSoftwareSourceModuleStreamsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwareSourceModuleStreamsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SearchSoftwareSourceModulesResponse searchSoftwareSourceModules(SearchSoftwareSourceModulesRequest request) {
        Objects.requireNonNull(request.getSearchSoftwareSourceModulesDetails(), "searchSoftwareSourceModulesDetails is required");
        return (SearchSoftwareSourceModulesResponse)this.clientCall(request, SearchSoftwareSourceModulesResponse::builder).logger(LOG, "searchSoftwareSourceModules").serviceDetails("SoftwareSource", "SearchSoftwareSourceModules", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/SearchSoftwareSourceModules").method(Method.POST).requestBuilder(SearchSoftwareSourceModulesRequest::builder).basePath("/20220901").appendPathParam("softwareSourceModules").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ModuleCollection.class, SearchSoftwareSourceModulesResponse.Builder::moduleCollection).handleResponseHeaderString("opc-request-id", SearchSoftwareSourceModulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwareSourceModulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SearchSoftwareSourcePackageGroupsResponse searchSoftwareSourcePackageGroups(SearchSoftwareSourcePackageGroupsRequest request) {
        Objects.requireNonNull(request.getSearchSoftwareSourcePackageGroupsDetails(), "searchSoftwareSourcePackageGroupsDetails is required");
        return (SearchSoftwareSourcePackageGroupsResponse)this.clientCall(request, SearchSoftwareSourcePackageGroupsResponse::builder).logger(LOG, "searchSoftwareSourcePackageGroups").serviceDetails("SoftwareSource", "SearchSoftwareSourcePackageGroups", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/SearchSoftwareSourcePackageGroups").method(Method.POST).requestBuilder(SearchSoftwareSourcePackageGroupsRequest::builder).basePath("/20220901").appendPathParam("softwareSourcePackageGroups").appendPathParam("actions").appendPathParam("search").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PackageGroupCollection.class, SearchSoftwareSourcePackageGroupsResponse.Builder::packageGroupCollection).handleResponseHeaderString("opc-request-id", SearchSoftwareSourcePackageGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchSoftwareSourcePackageGroupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateSoftwareSourceResponse updateSoftwareSource(UpdateSoftwareSourceRequest request) {
        Validate.notBlank((String)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSoftwareSourceDetails(), "updateSoftwareSourceDetails is required");
        return (UpdateSoftwareSourceResponse)this.clientCall(request, UpdateSoftwareSourceResponse::builder).logger(LOG, "updateSoftwareSource").serviceDetails("SoftwareSource", "UpdateSoftwareSource", "https://docs.oracle.com/iaas/api/#/en/osmh/20220901/SoftwareSource/UpdateSoftwareSource").method(Method.PUT).requestBuilder(UpdateSoftwareSourceRequest::builder).basePath("/20220901").appendPathParam("softwareSources").appendPathParam(request.getSoftwareSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.osmanagementhub.model.SoftwareSource.class, UpdateSoftwareSourceResponse.Builder::softwareSource).handleResponseHeaderString("etag", UpdateSoftwareSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSoftwareSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateSoftwareSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public SoftwareSourceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public SoftwareSourcePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SoftwareSourceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SoftwareSourceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SoftwareSourceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SoftwareSourceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SoftwareSourceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SoftwareSourceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SoftwareSourceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SoftwareSourceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SoftwareSourceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SoftwareSourceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SoftwareSourceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "osmanagementhub";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"osmanagementhub");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SoftwareSourceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SoftwareSourceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

