/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub;

import com.oracle.bmc.osmanagementhub.SoftwareSource;
import com.oracle.bmc.osmanagementhub.model.SoftwareSource;
import com.oracle.bmc.osmanagementhub.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagementhub.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class SoftwareSourceWaiters {
    private final ExecutorService executorService;
    private final SoftwareSource client;

    public SoftwareSourceWaiters(ExecutorService executorService, SoftwareSource client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(GetSoftwareSourceRequest request, SoftwareSource.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSoftwareSource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(GetSoftwareSourceRequest request, SoftwareSource.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSoftwareSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(GetSoftwareSourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SoftwareSource.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSoftwareSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(BmcGenericWaiter waiter, GetSoftwareSourceRequest request, SoftwareSource.LifecycleState ... targetStates) {
        final HashSet<SoftwareSource.LifecycleState> targetStatesSet = new HashSet<SoftwareSource.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSoftwareSourceRequest, GetSoftwareSourceResponse>(){

            @Override
            public GetSoftwareSourceResponse apply(GetSoftwareSourceRequest request) {
                return SoftwareSourceWaiters.this.client.getSoftwareSource(request);
            }
        }, (Predicate)new Predicate<GetSoftwareSourceResponse>(){

            @Override
            public boolean test(GetSoftwareSourceResponse response) {
                return targetStatesSet.contains((Object)response.getSoftwareSource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SoftwareSource.LifecycleState.Deleted)), (Object)request);
    }
}

